package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.xgap.PairedSample;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class PairedSampleService
{
	private static final Logger logger = Logger.getLogger(PairedSampleService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_PAIREDSAMPLE')")
	public PairedSample create(PairedSample pairedSample) throws DatabaseException
	{
		logger.debug("creating PairedSample");
		db.add(pairedSample);
		return pairedSample;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_PAIREDSAMPLE')")
	public PairedSample read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving PairedSample");
		return db.findById(PairedSample.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_PAIREDSAMPLE')")
	public void update(PairedSample pairedSample) throws DatabaseException
	{
		logger.debug("updating PairedSample");
		db.update(pairedSample);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_PAIREDSAMPLE')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting PairedSample");
		PairedSample pairedSample = db.findById(PairedSample.class, id);
		return db.remove(pairedSample) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_PAIREDSAMPLE')")
	public Iterable<PairedSample> readAll() throws DatabaseException
	{
		logger.debug("retrieving all PairedSample instances");
		return db.find(PairedSample.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_PAIREDSAMPLE')")
	public EntityPager<PairedSample> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all PairedSample instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(PairedSample.class, queryRules.toArray(new QueryRule[0]));
		List<PairedSample> pairedSampleCollection = db.find(PairedSample.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<PairedSample>(start, num, count, pairedSampleCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_PAIREDSAMPLE')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("PairedSample");
	}
}