package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.xgap.Polymorphism;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class PolymorphismService
{
	private static final Logger logger = Logger.getLogger(PolymorphismService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_POLYMORPHISM')")
	public Polymorphism create(Polymorphism polymorphism) throws DatabaseException
	{
		logger.debug("creating Polymorphism");
		db.add(polymorphism);
		return polymorphism;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_POLYMORPHISM')")
	public Polymorphism read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving Polymorphism");
		return db.findById(Polymorphism.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_POLYMORPHISM')")
	public void update(Polymorphism polymorphism) throws DatabaseException
	{
		logger.debug("updating Polymorphism");
		db.update(polymorphism);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_POLYMORPHISM')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting Polymorphism");
		Polymorphism polymorphism = db.findById(Polymorphism.class, id);
		return db.remove(polymorphism) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_POLYMORPHISM')")
	public Iterable<Polymorphism> readAll() throws DatabaseException
	{
		logger.debug("retrieving all Polymorphism instances");
		return db.find(Polymorphism.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_POLYMORPHISM')")
	public EntityPager<Polymorphism> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all Polymorphism instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(Polymorphism.class, queryRules.toArray(new QueryRule[0]));
		List<Polymorphism> polymorphismCollection = db.find(Polymorphism.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<Polymorphism>(start, num, count, polymorphismCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_POLYMORPHISM')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("Polymorphism");
	}
}