package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.xgap.Probe;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class ProbeService
{
	private static final Logger logger = Logger.getLogger(ProbeService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_PROBE')")
	public Probe create(Probe probe) throws DatabaseException
	{
		logger.debug("creating Probe");
		db.add(probe);
		return probe;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_PROBE')")
	public Probe read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving Probe");
		return db.findById(Probe.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_PROBE')")
	public void update(Probe probe) throws DatabaseException
	{
		logger.debug("updating Probe");
		db.update(probe);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_PROBE')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting Probe");
		Probe probe = db.findById(Probe.class, id);
		return db.remove(probe) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_PROBE')")
	public Iterable<Probe> readAll() throws DatabaseException
	{
		logger.debug("retrieving all Probe instances");
		return db.find(Probe.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_PROBE')")
	public EntityPager<Probe> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all Probe instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(Probe.class, queryRules.toArray(new QueryRule[0]));
		List<Probe> probeCollection = db.find(Probe.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<Probe>(start, num, count, probeCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_PROBE')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("Probe");
	}
}