package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.xgap.ProbeSet;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class ProbeSetService
{
	private static final Logger logger = Logger.getLogger(ProbeSetService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_PROBESET')")
	public ProbeSet create(ProbeSet probeSet) throws DatabaseException
	{
		logger.debug("creating ProbeSet");
		db.add(probeSet);
		return probeSet;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_PROBESET')")
	public ProbeSet read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving ProbeSet");
		return db.findById(ProbeSet.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_PROBESET')")
	public void update(ProbeSet probeSet) throws DatabaseException
	{
		logger.debug("updating ProbeSet");
		db.update(probeSet);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_PROBESET')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting ProbeSet");
		ProbeSet probeSet = db.findById(ProbeSet.class, id);
		return db.remove(probeSet) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_PROBESET')")
	public Iterable<ProbeSet> readAll() throws DatabaseException
	{
		logger.debug("retrieving all ProbeSet instances");
		return db.find(ProbeSet.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_PROBESET')")
	public EntityPager<ProbeSet> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all ProbeSet instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(ProbeSet.class, queryRules.toArray(new QueryRule[0]));
		List<ProbeSet> probeSetCollection = db.find(ProbeSet.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<ProbeSet>(start, num, count, probeSetCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_PROBESET')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("ProbeSet");
	}
}