package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.xgap.SNP;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class SNPService
{
	private static final Logger logger = Logger.getLogger(SNPService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_SNP')")
	public SNP create(SNP sNP) throws DatabaseException
	{
		logger.debug("creating SNP");
		db.add(sNP);
		return sNP;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_SNP')")
	public SNP read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving SNP");
		return db.findById(SNP.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_SNP')")
	public void update(SNP sNP) throws DatabaseException
	{
		logger.debug("updating SNP");
		db.update(sNP);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_SNP')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting SNP");
		SNP sNP = db.findById(SNP.class, id);
		return db.remove(sNP) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_SNP')")
	public Iterable<SNP> readAll() throws DatabaseException
	{
		logger.debug("retrieving all SNP instances");
		return db.find(SNP.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_SNP')")
	public EntityPager<SNP> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all SNP instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(SNP.class, queryRules.toArray(new QueryRule[0]));
		List<SNP> sNPCollection = db.find(SNP.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<SNP>(start, num, count, sNPCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_SNP')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("SNP");
	}
}