package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.xgap.Spot;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class SpotService
{
	private static final Logger logger = Logger.getLogger(SpotService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_SPOT')")
	public Spot create(Spot spot) throws DatabaseException
	{
		logger.debug("creating Spot");
		db.add(spot);
		return spot;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_SPOT')")
	public Spot read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving Spot");
		return db.findById(Spot.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_SPOT')")
	public void update(Spot spot) throws DatabaseException
	{
		logger.debug("updating Spot");
		db.update(spot);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_SPOT')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting Spot");
		Spot spot = db.findById(Spot.class, id);
		return db.remove(spot) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_SPOT')")
	public Iterable<Spot> readAll() throws DatabaseException
	{
		logger.debug("retrieving all Spot instances");
		return db.find(Spot.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_SPOT')")
	public EntityPager<Spot> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all Spot instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(Spot.class, queryRules.toArray(new QueryRule[0]));
		List<Spot> spotCollection = db.find(Spot.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<Spot>(start, num, count, spotCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_SPOT')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("Spot");
	}
}