package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.xgap.Variant;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class VariantService
{
	private static final Logger logger = Logger.getLogger(VariantService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_VARIANT')")
	public Variant create(Variant variant) throws DatabaseException
	{
		logger.debug("creating Variant");
		db.add(variant);
		return variant;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_VARIANT')")
	public Variant read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving Variant");
		return db.findById(Variant.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_VARIANT')")
	public void update(Variant variant) throws DatabaseException
	{
		logger.debug("updating Variant");
		db.update(variant);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_VARIANT')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting Variant");
		Variant variant = db.findById(Variant.class, id);
		return db.remove(variant) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_VARIANT')")
	public Iterable<Variant> readAll() throws DatabaseException
	{
		logger.debug("retrieving all Variant instances");
		return db.find(Variant.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_VARIANT')")
	public EntityPager<Variant> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all Variant instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(Variant.class, queryRules.toArray(new QueryRule[0]));
		List<Variant> variantCollection = db.find(Variant.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<Variant>(start, num, count, variantCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_VARIANT')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("Variant");
	}
}