
/* File:        org.molgenis.omx/model/SNP.java
 * Generator:   org.molgenis.generators.DataTypeGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
 

package org.molgenis.omx.xgap;

import java.util.LinkedHashSet;
import java.util.Set;

import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.support.MapEntity;


/**
 * SNP: A SNP is a special kind of Marker, but can also be seen as a phenotype to map against in some cases. A single-nucleotide polymorphism is a DNA sequence variation occurring when a single nucleotide in the genome (or other shared sequence) differs between members of a biological species or paired chromosomes in an individual..
 * @author MOLGENIS generator
 */
@javax.persistence.Entity
@javax.persistence.Table(name = "SNP"
)

@javax.xml.bind.annotation.XmlAccessorType(javax.xml.bind.annotation.XmlAccessType.FIELD)
@edu.umd.cs.findbugs.annotations.SuppressWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"}, justification="Exposing internal representation is accepted")
public class SNP extends org.molgenis.omx.xgap.Marker implements org.molgenis.data.Entity
{
    /** default serial version ID */
    private static final long serialVersionUID = 1L;
    
    public final static String ENTITY_NAME = "SNP";
    
	// fieldname constants
	public final static String STATUS = "Status";
	public final static String POLYMORPHISM = "Polymorphism";
	public final static String ID = "id";
	
	// member variables (including setters.getters for interface)
	public String getEntityName()
	{
		return ENTITY_NAME;
	}
	

	//The status of this SNP, eg 'confirmed'.[type=string]

	@javax.persistence.Column(name="Status", length=255)
	@javax.xml.bind.annotation.XmlElement(name="status")
	
				

	private String status =  null;

	//The polymorphism that belongs to this SNP.[type=mref]

	@javax.persistence.OrderColumn 	
    @javax.persistence.ManyToMany(fetch=javax.persistence.FetchType.LAZY /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="Polymorphism", insertable=true, updatable=true, nullable=true)
	@javax.persistence.JoinTable(name="SNP_Polymorphism", 
			joinColumns=@javax.persistence.JoinColumn(name="SNP"), inverseJoinColumns=@javax.persistence.JoinColumn(name="Polymorphism"))
	
				

	private java.util.List<org.molgenis.omx.xgap.Polymorphism> polymorphism = new java.util.ArrayList<org.molgenis.omx.xgap.Polymorphism>();

	//automatically generated internal id, only for internal use.[type=int]

	

	//constructors
	public SNP()
	{
		//set the type for a new instance
		set__Type(this.getClass().getSimpleName());
	}
	
	//getters and setters
	/**
	 * Get the The status of this SNP, eg 'confirmed'..
	 * @return status.
	 */
	public String getStatus()
	{
		return this.status;
	}	
	
	/**
	 * Set the The status of this SNP, eg 'confirmed'..
	 * @param status
	 */
	public void setStatus( String status)
	{
		
		this.status = status;
	}

	

	/**
	 * Get the The polymorphism that belongs to this SNP..
	 * @return polymorphism.
	 */
	public java.util.List<org.molgenis.omx.xgap.Polymorphism> getPolymorphism()
	{
		return this.polymorphism;
	}	
	
	/**
	 * Set the The polymorphism that belongs to this SNP..
	 * @param polymorphism
	 */
	public void setPolymorphism( java.util.List<org.molgenis.omx.xgap.Polymorphism> polymorphism)
	{
		
		this.polymorphism = polymorphism;
	}

	

	

	


	/**
	 * Generic getter. Get the property by using the name.
	 */
	@Override
	public Object get(String name)
	{
		name = name.toLowerCase();
		if (name.equals("id"))
			return getId();
		if (name.equals("identifier"))
			return getIdentifier();
		if (name.equals("name"))
			return getName();
		if (name.equals("__type"))
			return get__Type();
		if(name.equals("__type_label"))
			return get__TypeLabel();			
		if (name.equals("description"))
			return getDescription();
		if (name.equals("chromosome"))
			return getChromosome();
		if (name.equals("cm"))
			return getCM();
		if (name.equals("bpstart"))
			return getBpStart();
		if (name.equals("bpend"))
			return getBpEnd();
		if (name.equals("seq"))
			return getSeq();
		if (name.equals("symbol"))
			return getSymbol();
		if (name.equals("reportsfor"))
			return getReportsFor();
		if (name.equals("status"))
			return getStatus();
		if (name.equals("polymorphism"))
			return getPolymorphism();
		return null;
	}	
	
	@Override
	public void set(org.molgenis.data.Entity entity, boolean strict)
	{
		//set Id
		// query formal name, else lowercase name
		if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(strict) this.setId(entity.getInt("id")); // setting null is not an option due to function overloading
		if( entity.getInt("snp_id") != null) this.setId(entity.getInt("snp_id"));
		else if( entity.getInt("SNP_id") != null) this.setId(entity.getInt("SNP_id"));
		//set Identifier
		// query formal name, else lowercase name
		if(entity.getString("identifier") != null) this.setIdentifier(entity.getString("identifier"));
		else if(entity.getString("Identifier") != null) this.setIdentifier(entity.getString("Identifier"));
		else if(strict) this.setIdentifier(entity.getString("identifier")); // setting null is not an option due to function overloading
		if( entity.getString("snp_identifier") != null) this.setIdentifier(entity.getString("snp_identifier"));
		else if( entity.getString("SNP_Identifier") != null) this.setIdentifier(entity.getString("SNP_Identifier"));
		//set Name
		// query formal name, else lowercase name
		if(entity.getString("name") != null) this.setName(entity.getString("name"));
		else if(entity.getString("Name") != null) this.setName(entity.getString("Name"));
		else if(strict) this.setName(entity.getString("name")); // setting null is not an option due to function overloading
		if( entity.getString("snp_name") != null) this.setName(entity.getString("snp_name"));
		else if( entity.getString("SNP_Name") != null) this.setName(entity.getString("SNP_Name"));
		//set __Type
		// query formal name, else lowercase name
		if(entity.getString("__type") != null) this.set__Type(entity.getString("__type"));
		else if(entity.getString("__Type") != null) this.set__Type(entity.getString("__Type"));
		else if(strict) this.set__Type(entity.getString("__type")); // setting null is not an option due to function overloading
		if( entity.getString("snp___type") != null) this.set__Type(entity.getString("snp___type"));
		else if( entity.getString("SNP___Type") != null) this.set__Type(entity.getString("SNP___Type"));
		//set Description
		// query formal name, else lowercase name
		if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(strict) this.setDescription(entity.getString("description")); // setting null is not an option due to function overloading
		if( entity.getString("snp_description") != null) this.setDescription(entity.getString("snp_description"));
		else if( entity.getString("SNP_description") != null) this.setDescription(entity.getString("SNP_description"));
		//set Chromosome
		// query formal name, else lowercase name
		if( entity.get("Chromosome") != null) { 
			this.setChromosome((org.molgenis.omx.xgap.Chromosome)entity.get("Chromosome"));				
		}
		else if( entity.get("chromosome") != null) { 
			this.setChromosome((org.molgenis.omx.xgap.Chromosome)entity.get("chromosome"));				
		}
		else if( entity.get("SNP_Chromosome") != null) { 
			this.setChromosome((org.molgenis.omx.xgap.Chromosome)entity.get("SNP_Chromosome"));				
		}
		else if( entity.get("snp_chromosome") != null) { 
			this.setChromosome((org.molgenis.omx.xgap.Chromosome)entity.get("SNP_Chromosome"));				
		}
		//set CM
		// query formal name, else lowercase name
		if(entity.getDouble("cm") != null) this.setCM(entity.getDouble("cm"));
		else if(entity.getDouble("cM") != null) this.setCM(entity.getDouble("cM"));
		else if(strict) this.setCM(entity.getDouble("cm")); // setting null is not an option due to function overloading
		if( entity.getDouble("snp_cm") != null) this.setCM(entity.getDouble("snp_cm"));
		else if( entity.getDouble("SNP_cM") != null) this.setCM(entity.getDouble("SNP_cM"));
		//set BpStart
		// query formal name, else lowercase name
		if(entity.getLong("bpstart") != null) this.setBpStart(entity.getLong("bpstart"));
		else if(entity.getLong("bpStart") != null) this.setBpStart(entity.getLong("bpStart"));
		else if(strict) this.setBpStart(entity.getLong("bpstart")); // setting null is not an option due to function overloading
		if( entity.getLong("snp_bpstart") != null) this.setBpStart(entity.getLong("snp_bpstart"));
		else if( entity.getLong("SNP_bpStart") != null) this.setBpStart(entity.getLong("SNP_bpStart"));
		//set BpEnd
		// query formal name, else lowercase name
		if(entity.getLong("bpend") != null) this.setBpEnd(entity.getLong("bpend"));
		else if(entity.getLong("bpEnd") != null) this.setBpEnd(entity.getLong("bpEnd"));
		else if(strict) this.setBpEnd(entity.getLong("bpend")); // setting null is not an option due to function overloading
		if( entity.getLong("snp_bpend") != null) this.setBpEnd(entity.getLong("snp_bpend"));
		else if( entity.getLong("SNP_bpEnd") != null) this.setBpEnd(entity.getLong("SNP_bpEnd"));
		//set Seq
		// query formal name, else lowercase name
		if(entity.getString("seq") != null) this.setSeq(entity.getString("seq"));
		else if(entity.getString("Seq") != null) this.setSeq(entity.getString("Seq"));
		else if(strict) this.setSeq(entity.getString("seq")); // setting null is not an option due to function overloading
		if( entity.getString("snp_seq") != null) this.setSeq(entity.getString("snp_seq"));
		else if( entity.getString("SNP_Seq") != null) this.setSeq(entity.getString("SNP_Seq"));
		//set Symbol
		// query formal name, else lowercase name
		if(entity.getString("symbol") != null) this.setSymbol(entity.getString("symbol"));
		else if(entity.getString("Symbol") != null) this.setSymbol(entity.getString("Symbol"));
		else if(strict) this.setSymbol(entity.getString("symbol")); // setting null is not an option due to function overloading
		if( entity.getString("snp_symbol") != null) this.setSymbol(entity.getString("snp_symbol"));
		else if( entity.getString("SNP_Symbol") != null) this.setSymbol(entity.getString("SNP_Symbol"));
		//set ReportsFor
		if( entity.get("ReportsFor") != null || entity.get("reportsfor") != null ) 
		{
			Object mrefs = entity.get("ReportsFor");
			if(mrefs == null) mrefs = entity.get("reportsfor");
			if(entity.get("snp_reportsfor")!= null) mrefs = entity.get("snp_reportsfor");
			else if(entity.get("SNP_ReportsFor")!= null) mrefs = entity.get("SNP_ReportsFor");									
			this.setReportsFor((java.util.List<org.molgenis.omx.xgap.Marker>) mrefs );
		}				
		//set Status
		// query formal name, else lowercase name
		if(entity.getString("status") != null) this.setStatus(entity.getString("status"));
		else if(entity.getString("Status") != null) this.setStatus(entity.getString("Status"));
		else if(strict) this.setStatus(entity.getString("status")); // setting null is not an option due to function overloading
		if( entity.getString("snp_status") != null) this.setStatus(entity.getString("snp_status"));
		else if( entity.getString("SNP_Status") != null) this.setStatus(entity.getString("SNP_Status"));
		//set Polymorphism
		if( entity.get("Polymorphism") != null || entity.get("polymorphism") != null ) 
		{
			Object mrefs = entity.get("Polymorphism");
			if(mrefs == null) mrefs = entity.get("polymorphism");
			if(entity.get("snp_polymorphism")!= null) mrefs = entity.get("snp_polymorphism");
			else if(entity.get("SNP_Polymorphism")!= null) mrefs = entity.get("SNP_Polymorphism");									
			this.setPolymorphism((java.util.List<org.molgenis.omx.xgap.Polymorphism>) mrefs );
		}				
	}
	
	@Override
	public String toString()
	{
		return this.toString(false);
	}
	
	public String toString(boolean verbose)
	{
		StringBuilder sb = new StringBuilder("SNP(");
		sb.append("id='" + getId()+"' ");	
		sb.append("identifier='" + getIdentifier()+"' ");	
		sb.append("name='" + getName()+"' ");	
		sb.append("__Type='" + get__Type()+"' ");	
		sb.append("description='" + getDescription()+"' ");	
		sb.append("chromosome='" + getChromosome()+"' ");	
		sb.append("cM='" + getCM()+"' ");	
		sb.append("bpStart='" + getBpStart()+"' ");	
		sb.append("bpEnd='" + getBpEnd()+"' ");	
		sb.append("seq='" + getSeq()+"' ");	
		sb.append("symbol='" + getSymbol()+"' ");	
		sb.append("reportsFor='" + getReportsFor()+"' ");	
		sb.append("status='" + getStatus()+"' ");	
		sb.append("polymorphism='" + getPolymorphism()+"'");	
		sb.append(");");
		return sb.toString();
	}

	@Override
	public Integer getIdValue()
	{
		return getId();
	}		
	

	@Override
	public Iterable<String> getAttributeNames()
	{
		Set<String> attributeNames = new LinkedHashSet<String>();
		for (AttributeMetaData attr : new SNPMetaData().getAttributes())
		{
			attributeNames.add(attr.getName());
		}

		return attributeNames;
	}
	
	@Override
	public java.util.List<String> getLabelAttributeNames()
	{
		java.util.List<String> result = new java.util.ArrayList<String>();
		result.add("Identifier");
		return result;
	}

	@Override
	public void set(String attributeName, Object value)
	{
		set(new MapEntity(attributeName, value), false);
	}

	@Override
	public boolean equals(Object obj)
	{
		if (this == obj) return true;
		if (obj == null) return false;
		if (!super.equals(obj)) return false;
		if (getClass() != obj.getClass()) return false;
		return true;
	}
	
	@Override
	public int hashCode()
	{
		int result = super.hashCode();
		return result;
	}
	
	@Override
	public org.molgenis.data.EntityMetaData getEntityMetaData()
	{
		return new SNPMetaData();
	}
}
