
/* File:        org.molgenis.omx/model/Variant.java
 * Generator:   org.molgenis.generators.DataTypeGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
 

package org.molgenis.omx.xgap;

import java.util.LinkedHashSet;
import java.util.Set;

import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.support.MapEntity;


/**
 * Variant: A SNP is a special kind of Marker, but can also be seen as a phenotype to map against in some cases. A single-nucleotide polymorphism is a DNA sequence variation occurring when a single nucleotide in the genome (or other shared sequence) differs between members of a biological species or paired chromosomes in an individual..
 * @author MOLGENIS generator
 */
@javax.persistence.Entity
@javax.persistence.Table(name = "Variant"
)

@javax.xml.bind.annotation.XmlAccessorType(javax.xml.bind.annotation.XmlAccessType.FIELD)
@edu.umd.cs.findbugs.annotations.SuppressWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"}, justification="Exposing internal representation is accepted")
public class Variant extends org.molgenis.omx.observ.ObservationTarget implements org.molgenis.data.Entity, org.molgenis.omx.xgap.Locus
{
    /** default serial version ID */
    private static final long serialVersionUID = 1L;
    
    public final static String ENTITY_NAME = "Variant";
    
	// fieldname constants
	public final static String CHROMOSOME = "Chromosome";
	public final static String CM = "cM";
	public final static String BPSTART = "bpStart";
	public final static String BPEND = "bpEnd";
	public final static String SEQ = "Seq";
	public final static String SYMBOL = "Symbol";
	public final static String MUTATIONPOSITION = "MutationPosition";
	public final static String CDNAPOSITION = "CdnaPosition";
	public final static String AAPOSITION = "AaPosition";
	public final static String VARIANTLENGTH = "VariantLength";
	public final static String EVENT = "Event";
	public final static String NTCHANGE = "NtChange";
	public final static String CODONCHANGE = "Codonchange";
	public final static String CDNANOTATION = "CdnaNotation";
	public final static String GDNANOTATION = "GdnaNotation";
	public final static String AANOTATION = "AaNotation";
	public final static String EXON = "Exon";
	public final static String CONSEQUENCE = "Consequence";
	public final static String INHERITANCE = "Inheritance";
	public final static String REPORTEDSNP = "ReportedSNP";
	public final static String EFFECTONSPLICING = "EffectOnSplicing";
	public final static String PATHOGENICITY = "Pathogenicity";
	public final static String GENE = "Gene";
	public final static String IDMUTATION = "IdMutation";
	public final static String DETAILSFORMUTATION = "DetailsForMutation";
	public final static String TRACK = "Track";
	public final static String ID = "id";
	
	// member variables (including setters.getters for interface)
	public String getEntityName()
	{
		return ENTITY_NAME;
	}
	

	//Reference to the chromosome this     position belongs to.[type=xref]

    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="Chromosome")  
	
				

	private org.molgenis.omx.xgap.Chromosome chromosome = null;

	//genetic map position in centi morgan (cM).[type=decimal]

	@javax.persistence.Column(name="cM")
	@javax.xml.bind.annotation.XmlElement(name="cM")
	
				

	private Double cM =  null;

	//numeric basepair postion (5') on the chromosome[type=long]

	@javax.persistence.Column(name="bpStart")
	@javax.xml.bind.annotation.XmlElement(name="bpStart")
	
				

	private Long bpStart =  null;

	//numeric basepair postion (3') on the chromosome[type=long]

	@javax.persistence.Column(name="bpEnd")
	@javax.xml.bind.annotation.XmlElement(name="bpEnd")
	
				

	private Long bpEnd =  null;

	//The FASTA text representation of the sequence.[type=text]

	@javax.persistence.Lob
	@javax.persistence.Column(name="Seq")
	
				

	private String seq =  null;

	//todo[type=string]

	@javax.persistence.Column(name="Symbol", length=255)
	@javax.xml.bind.annotation.XmlElement(name="symbol")
	
				

	private String symbol =  null;

	//[type=int]

	@javax.persistence.Column(name="MutationPosition")
	@javax.xml.bind.annotation.XmlElement(name="mutationPosition")
	
				

	private Integer mutationPosition =  null;

	//[type=int]

	@javax.persistence.Column(name="CdnaPosition")
	@javax.xml.bind.annotation.XmlElement(name="cdnaPosition")
	
				

	private Integer cdnaPosition =  null;

	//[type=int]

	@javax.persistence.Column(name="AaPosition")
	@javax.xml.bind.annotation.XmlElement(name="aaPosition")
	
				

	private Integer aaPosition =  null;

	//[type=int]

	@javax.persistence.Column(name="VariantLength")
	@javax.xml.bind.annotation.XmlElement(name="variantLength")
	
				

	private Integer variantLength =  null;

	//[type=string]

	@javax.persistence.Column(name="Event", length=255)
	@javax.xml.bind.annotation.XmlElement(name="event")
	
				

	private String event =  null;

	//[type=string]

	@javax.persistence.Column(name="NtChange", length=255)
	@javax.xml.bind.annotation.XmlElement(name="ntChange")
	
				

	private String ntChange =  null;

	//[type=string]

	@javax.persistence.Column(name="Codonchange", length=255)
	@javax.xml.bind.annotation.XmlElement(name="codonchange")
	
				

	private String codonchange =  null;

	//[type=string]

	@javax.persistence.Column(name="CdnaNotation", length=255)
	@javax.xml.bind.annotation.XmlElement(name="cdnaNotation")
	
				

	private String cdnaNotation =  null;

	//[type=string]

	@javax.persistence.Column(name="GdnaNotation", length=255)
	@javax.xml.bind.annotation.XmlElement(name="gdnaNotation")
	
				

	private String gdnaNotation =  null;

	//[type=string]

	@javax.persistence.Column(name="AaNotation", length=255)
	@javax.xml.bind.annotation.XmlElement(name="aaNotation")
	
				

	private String aaNotation =  null;

	//[type=string]

	@javax.persistence.Column(name="Exon", length=255)
	@javax.xml.bind.annotation.XmlElement(name="exon")
	
				

	private String exon =  null;

	//[type=string]

	@javax.persistence.Column(name="Consequence", length=255)
	@javax.xml.bind.annotation.XmlElement(name="consequence")
	
				

	private String consequence =  null;

	//[type=string]

	@javax.persistence.Column(name="Inheritance", length=255)
	@javax.xml.bind.annotation.XmlElement(name="inheritance")
	
				

	private String inheritance =  null;

	//[type=bool]

	@javax.persistence.Column(name="ReportedSNP")
	@javax.xml.bind.annotation.XmlElement(name="reportedSNP")
	
				

	private Boolean reportedSNP =  null;

	//[type=bool]

	@javax.persistence.Column(name="EffectOnSplicing")
	@javax.xml.bind.annotation.XmlElement(name="effectOnSplicing")
	
				

	private Boolean effectOnSplicing =  null;

	//[type=string]

	@javax.persistence.Column(name="Pathogenicity", length=255)
	@javax.xml.bind.annotation.XmlElement(name="pathogenicity")
	
				

	private String pathogenicity =  null;

	//[type=string]

	@javax.persistence.Column(name="Gene", length=255)
	@javax.xml.bind.annotation.XmlElement(name="gene")
	
				

	private String gene =  null;

	//[type=int]

	@javax.persistence.Column(name="IdMutation")
	@javax.xml.bind.annotation.XmlElement(name="idMutation")
	
				

	private Integer idMutation =  null;

	//[type=hyperlink]

	@javax.persistence.Column(name="DetailsForMutation")
	@javax.xml.bind.annotation.XmlElement(name="detailsForMutation")
	
				

	private String detailsForMutation =  null;

	//[type=xref]

    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="Track", nullable=false)  
	
				

	@javax.validation.constraints.NotNull
	private org.molgenis.omx.xgap.Track track = null;

	//automatically generated internal id, only for internal use.[type=int]

	

	//constructors
	public Variant()
	{
		//set the type for a new instance
		set__Type(this.getClass().getSimpleName());
	}
	
	//getters and setters
	/**
	 * Get the Reference to the chromosome this     position belongs to..
	 * @return chromosome.
	 */
	public org.molgenis.omx.xgap.Chromosome getChromosome()
	{
		return this.chromosome;
	}	
	
	/**
	 * Set the Reference to the chromosome this     position belongs to..
	 * @param chromosome
	 */
	public void setChromosome( org.molgenis.omx.xgap.Chromosome chromosome)
	{
		
		this.chromosome = chromosome;
	}

	

	/**
	 * Get the genetic map position in centi morgan (cM)..
	 * @return cM.
	 */
	public Double getCM()
	{
		return this.cM;
	}	
	
	/**
	 * Set the genetic map position in centi morgan (cM)..
	 * @param cM
	 */
	public void setCM( Double cM)
	{
		
		this.cM = cM;
	}

	

	/**
	 * Get the numeric basepair postion (5') on the chromosome.
	 * @return bpStart.
	 */
	public Long getBpStart()
	{
		return this.bpStart;
	}	
	
	/**
	 * Set the numeric basepair postion (5') on the chromosome.
	 * @param bpStart
	 */
	public void setBpStart( Long bpStart)
	{
		
		this.bpStart = bpStart;
	}

	

	/**
	 * Get the numeric basepair postion (3') on the chromosome.
	 * @return bpEnd.
	 */
	public Long getBpEnd()
	{
		return this.bpEnd;
	}	
	
	/**
	 * Set the numeric basepair postion (3') on the chromosome.
	 * @param bpEnd
	 */
	public void setBpEnd( Long bpEnd)
	{
		
		this.bpEnd = bpEnd;
	}

	

	/**
	 * Get the The FASTA text representation of the sequence..
	 * @return seq.
	 */
	public String getSeq()
	{
		return this.seq;
	}	
	
	/**
	 * Set the The FASTA text representation of the sequence..
	 * @param seq
	 */
	public void setSeq( String seq)
	{
		
		this.seq = seq;
	}

	

	/**
	 * Get the todo.
	 * @return symbol.
	 */
	public String getSymbol()
	{
		return this.symbol;
	}	
	
	/**
	 * Set the todo.
	 * @param symbol
	 */
	public void setSymbol( String symbol)
	{
		
		this.symbol = symbol;
	}

	

	/**
	 * Get the .
	 * @return mutationPosition.
	 */
	public Integer getMutationPosition()
	{
		return this.mutationPosition;
	}	
	
	/**
	 * Set the .
	 * @param mutationPosition
	 */
	public void setMutationPosition( Integer mutationPosition)
	{
		
		this.mutationPosition = mutationPosition;
	}

	

	/**
	 * Get the .
	 * @return cdnaPosition.
	 */
	public Integer getCdnaPosition()
	{
		return this.cdnaPosition;
	}	
	
	/**
	 * Set the .
	 * @param cdnaPosition
	 */
	public void setCdnaPosition( Integer cdnaPosition)
	{
		
		this.cdnaPosition = cdnaPosition;
	}

	

	/**
	 * Get the .
	 * @return aaPosition.
	 */
	public Integer getAaPosition()
	{
		return this.aaPosition;
	}	
	
	/**
	 * Set the .
	 * @param aaPosition
	 */
	public void setAaPosition( Integer aaPosition)
	{
		
		this.aaPosition = aaPosition;
	}

	

	/**
	 * Get the .
	 * @return variantLength.
	 */
	public Integer getVariantLength()
	{
		return this.variantLength;
	}	
	
	/**
	 * Set the .
	 * @param variantLength
	 */
	public void setVariantLength( Integer variantLength)
	{
		
		this.variantLength = variantLength;
	}

	

	/**
	 * Get the .
	 * @return event.
	 */
	public String getEvent()
	{
		return this.event;
	}	
	
	/**
	 * Set the .
	 * @param event
	 */
	public void setEvent( String event)
	{
		
		this.event = event;
	}

	

	/**
	 * Get the .
	 * @return ntChange.
	 */
	public String getNtChange()
	{
		return this.ntChange;
	}	
	
	/**
	 * Set the .
	 * @param ntChange
	 */
	public void setNtChange( String ntChange)
	{
		
		this.ntChange = ntChange;
	}

	

	/**
	 * Get the .
	 * @return codonchange.
	 */
	public String getCodonchange()
	{
		return this.codonchange;
	}	
	
	/**
	 * Set the .
	 * @param codonchange
	 */
	public void setCodonchange( String codonchange)
	{
		
		this.codonchange = codonchange;
	}

	

	/**
	 * Get the .
	 * @return cdnaNotation.
	 */
	public String getCdnaNotation()
	{
		return this.cdnaNotation;
	}	
	
	/**
	 * Set the .
	 * @param cdnaNotation
	 */
	public void setCdnaNotation( String cdnaNotation)
	{
		
		this.cdnaNotation = cdnaNotation;
	}

	

	/**
	 * Get the .
	 * @return gdnaNotation.
	 */
	public String getGdnaNotation()
	{
		return this.gdnaNotation;
	}	
	
	/**
	 * Set the .
	 * @param gdnaNotation
	 */
	public void setGdnaNotation( String gdnaNotation)
	{
		
		this.gdnaNotation = gdnaNotation;
	}

	

	/**
	 * Get the .
	 * @return aaNotation.
	 */
	public String getAaNotation()
	{
		return this.aaNotation;
	}	
	
	/**
	 * Set the .
	 * @param aaNotation
	 */
	public void setAaNotation( String aaNotation)
	{
		
		this.aaNotation = aaNotation;
	}

	

	/**
	 * Get the .
	 * @return exon.
	 */
	public String getExon()
	{
		return this.exon;
	}	
	
	/**
	 * Set the .
	 * @param exon
	 */
	public void setExon( String exon)
	{
		
		this.exon = exon;
	}

	

	/**
	 * Get the .
	 * @return consequence.
	 */
	public String getConsequence()
	{
		return this.consequence;
	}	
	
	/**
	 * Set the .
	 * @param consequence
	 */
	public void setConsequence( String consequence)
	{
		
		this.consequence = consequence;
	}

	

	/**
	 * Get the .
	 * @return inheritance.
	 */
	public String getInheritance()
	{
		return this.inheritance;
	}	
	
	/**
	 * Set the .
	 * @param inheritance
	 */
	public void setInheritance( String inheritance)
	{
		
		this.inheritance = inheritance;
	}

	

	/**
	 * Get the .
	 * @return reportedSNP.
	 */
	public Boolean getReportedSNP()
	{
		return this.reportedSNP;
	}	
	
	/**
	 * Set the .
	 * @param reportedSNP
	 */
	public void setReportedSNP( Boolean reportedSNP)
	{
		
		this.reportedSNP = reportedSNP;
	}

	

	/**
	 * Get the .
	 * @return effectOnSplicing.
	 */
	public Boolean getEffectOnSplicing()
	{
		return this.effectOnSplicing;
	}	
	
	/**
	 * Set the .
	 * @param effectOnSplicing
	 */
	public void setEffectOnSplicing( Boolean effectOnSplicing)
	{
		
		this.effectOnSplicing = effectOnSplicing;
	}

	

	/**
	 * Get the .
	 * @return pathogenicity.
	 */
	public String getPathogenicity()
	{
		return this.pathogenicity;
	}	
	
	/**
	 * Set the .
	 * @param pathogenicity
	 */
	public void setPathogenicity( String pathogenicity)
	{
		
		this.pathogenicity = pathogenicity;
	}

	

	/**
	 * Get the .
	 * @return gene.
	 */
	public String getGene()
	{
		return this.gene;
	}	
	
	/**
	 * Set the .
	 * @param gene
	 */
	public void setGene( String gene)
	{
		
		this.gene = gene;
	}

	

	/**
	 * Get the .
	 * @return idMutation.
	 */
	public Integer getIdMutation()
	{
		return this.idMutation;
	}	
	
	/**
	 * Set the .
	 * @param idMutation
	 */
	public void setIdMutation( Integer idMutation)
	{
		
		this.idMutation = idMutation;
	}

	

	/**
	 * Get the .
	 * @return detailsForMutation.
	 */
	public String getDetailsForMutation()
	{
		return this.detailsForMutation;
	}	
	
	/**
	 * Set the .
	 * @param detailsForMutation
	 */
	public void setDetailsForMutation( String detailsForMutation)
	{
		
		this.detailsForMutation = detailsForMutation;
	}

	

	/**
	 * Get the .
	 * @return track.
	 */
	public org.molgenis.omx.xgap.Track getTrack()
	{
		return this.track;
	}	
	
	/**
	 * Set the .
	 * @param track
	 */
	public void setTrack( org.molgenis.omx.xgap.Track track)
	{
		
		this.track = track;
	}

	

	

	


	/**
	 * Generic getter. Get the property by using the name.
	 */
	@Override
	public Object get(String name)
	{
		name = name.toLowerCase();
		if (name.equals("id"))
			return getId();
		if (name.equals("identifier"))
			return getIdentifier();
		if (name.equals("name"))
			return getName();
		if (name.equals("__type"))
			return get__Type();
		if(name.equals("__type_label"))
			return get__TypeLabel();			
		if (name.equals("description"))
			return getDescription();
		if (name.equals("chromosome"))
			return getChromosome();
		if (name.equals("cm"))
			return getCM();
		if (name.equals("bpstart"))
			return getBpStart();
		if (name.equals("bpend"))
			return getBpEnd();
		if (name.equals("seq"))
			return getSeq();
		if (name.equals("symbol"))
			return getSymbol();
		if (name.equals("mutationposition"))
			return getMutationPosition();
		if (name.equals("cdnaposition"))
			return getCdnaPosition();
		if (name.equals("aaposition"))
			return getAaPosition();
		if (name.equals("variantlength"))
			return getVariantLength();
		if (name.equals("event"))
			return getEvent();
		if (name.equals("ntchange"))
			return getNtChange();
		if (name.equals("codonchange"))
			return getCodonchange();
		if (name.equals("cdnanotation"))
			return getCdnaNotation();
		if (name.equals("gdnanotation"))
			return getGdnaNotation();
		if (name.equals("aanotation"))
			return getAaNotation();
		if (name.equals("exon"))
			return getExon();
		if (name.equals("consequence"))
			return getConsequence();
		if (name.equals("inheritance"))
			return getInheritance();
		if (name.equals("reportedsnp"))
			return getReportedSNP();
		if (name.equals("effectonsplicing"))
			return getEffectOnSplicing();
		if (name.equals("pathogenicity"))
			return getPathogenicity();
		if (name.equals("gene"))
			return getGene();
		if (name.equals("idmutation"))
			return getIdMutation();
		if (name.equals("detailsformutation"))
			return getDetailsForMutation();
		if (name.equals("track"))
			return getTrack();
		return null;
	}	
	
	@Override
	public void set(org.molgenis.data.Entity entity, boolean strict)
	{
		//set Id
		// query formal name, else lowercase name
		if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(strict) this.setId(entity.getInt("id")); // setting null is not an option due to function overloading
		if( entity.getInt("variant_id") != null) this.setId(entity.getInt("variant_id"));
		else if( entity.getInt("Variant_id") != null) this.setId(entity.getInt("Variant_id"));
		//set Identifier
		// query formal name, else lowercase name
		if(entity.getString("identifier") != null) this.setIdentifier(entity.getString("identifier"));
		else if(entity.getString("Identifier") != null) this.setIdentifier(entity.getString("Identifier"));
		else if(strict) this.setIdentifier(entity.getString("identifier")); // setting null is not an option due to function overloading
		if( entity.getString("variant_identifier") != null) this.setIdentifier(entity.getString("variant_identifier"));
		else if( entity.getString("Variant_Identifier") != null) this.setIdentifier(entity.getString("Variant_Identifier"));
		//set Name
		// query formal name, else lowercase name
		if(entity.getString("name") != null) this.setName(entity.getString("name"));
		else if(entity.getString("Name") != null) this.setName(entity.getString("Name"));
		else if(strict) this.setName(entity.getString("name")); // setting null is not an option due to function overloading
		if( entity.getString("variant_name") != null) this.setName(entity.getString("variant_name"));
		else if( entity.getString("Variant_Name") != null) this.setName(entity.getString("Variant_Name"));
		//set __Type
		// query formal name, else lowercase name
		if(entity.getString("__type") != null) this.set__Type(entity.getString("__type"));
		else if(entity.getString("__Type") != null) this.set__Type(entity.getString("__Type"));
		else if(strict) this.set__Type(entity.getString("__type")); // setting null is not an option due to function overloading
		if( entity.getString("variant___type") != null) this.set__Type(entity.getString("variant___type"));
		else if( entity.getString("Variant___Type") != null) this.set__Type(entity.getString("Variant___Type"));
		//set Description
		// query formal name, else lowercase name
		if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(strict) this.setDescription(entity.getString("description")); // setting null is not an option due to function overloading
		if( entity.getString("variant_description") != null) this.setDescription(entity.getString("variant_description"));
		else if( entity.getString("Variant_description") != null) this.setDescription(entity.getString("Variant_description"));
		//set Chromosome
		// query formal name, else lowercase name
		if( entity.get("Chromosome") != null) { 
			this.setChromosome((org.molgenis.omx.xgap.Chromosome)entity.get("Chromosome"));				
		}
		else if( entity.get("chromosome") != null) { 
			this.setChromosome((org.molgenis.omx.xgap.Chromosome)entity.get("chromosome"));				
		}
		else if( entity.get("Variant_Chromosome") != null) { 
			this.setChromosome((org.molgenis.omx.xgap.Chromosome)entity.get("Variant_Chromosome"));				
		}
		else if( entity.get("variant_chromosome") != null) { 
			this.setChromosome((org.molgenis.omx.xgap.Chromosome)entity.get("Variant_Chromosome"));				
		}
		//set CM
		// query formal name, else lowercase name
		if(entity.getDouble("cm") != null) this.setCM(entity.getDouble("cm"));
		else if(entity.getDouble("cM") != null) this.setCM(entity.getDouble("cM"));
		else if(strict) this.setCM(entity.getDouble("cm")); // setting null is not an option due to function overloading
		if( entity.getDouble("variant_cm") != null) this.setCM(entity.getDouble("variant_cm"));
		else if( entity.getDouble("Variant_cM") != null) this.setCM(entity.getDouble("Variant_cM"));
		//set BpStart
		// query formal name, else lowercase name
		if(entity.getLong("bpstart") != null) this.setBpStart(entity.getLong("bpstart"));
		else if(entity.getLong("bpStart") != null) this.setBpStart(entity.getLong("bpStart"));
		else if(strict) this.setBpStart(entity.getLong("bpstart")); // setting null is not an option due to function overloading
		if( entity.getLong("variant_bpstart") != null) this.setBpStart(entity.getLong("variant_bpstart"));
		else if( entity.getLong("Variant_bpStart") != null) this.setBpStart(entity.getLong("Variant_bpStart"));
		//set BpEnd
		// query formal name, else lowercase name
		if(entity.getLong("bpend") != null) this.setBpEnd(entity.getLong("bpend"));
		else if(entity.getLong("bpEnd") != null) this.setBpEnd(entity.getLong("bpEnd"));
		else if(strict) this.setBpEnd(entity.getLong("bpend")); // setting null is not an option due to function overloading
		if( entity.getLong("variant_bpend") != null) this.setBpEnd(entity.getLong("variant_bpend"));
		else if( entity.getLong("Variant_bpEnd") != null) this.setBpEnd(entity.getLong("Variant_bpEnd"));
		//set Seq
		// query formal name, else lowercase name
		if(entity.getString("seq") != null) this.setSeq(entity.getString("seq"));
		else if(entity.getString("Seq") != null) this.setSeq(entity.getString("Seq"));
		else if(strict) this.setSeq(entity.getString("seq")); // setting null is not an option due to function overloading
		if( entity.getString("variant_seq") != null) this.setSeq(entity.getString("variant_seq"));
		else if( entity.getString("Variant_Seq") != null) this.setSeq(entity.getString("Variant_Seq"));
		//set Symbol
		// query formal name, else lowercase name
		if(entity.getString("symbol") != null) this.setSymbol(entity.getString("symbol"));
		else if(entity.getString("Symbol") != null) this.setSymbol(entity.getString("Symbol"));
		else if(strict) this.setSymbol(entity.getString("symbol")); // setting null is not an option due to function overloading
		if( entity.getString("variant_symbol") != null) this.setSymbol(entity.getString("variant_symbol"));
		else if( entity.getString("Variant_Symbol") != null) this.setSymbol(entity.getString("Variant_Symbol"));
		//set MutationPosition
		// query formal name, else lowercase name
		if(entity.getInt("mutationposition") != null) this.setMutationPosition(entity.getInt("mutationposition"));
		else if(entity.getInt("MutationPosition") != null) this.setMutationPosition(entity.getInt("MutationPosition"));
		else if(strict) this.setMutationPosition(entity.getInt("mutationposition")); // setting null is not an option due to function overloading
		if( entity.getInt("variant_mutationposition") != null) this.setMutationPosition(entity.getInt("variant_mutationposition"));
		else if( entity.getInt("Variant_MutationPosition") != null) this.setMutationPosition(entity.getInt("Variant_MutationPosition"));
		//set CdnaPosition
		// query formal name, else lowercase name
		if(entity.getInt("cdnaposition") != null) this.setCdnaPosition(entity.getInt("cdnaposition"));
		else if(entity.getInt("CdnaPosition") != null) this.setCdnaPosition(entity.getInt("CdnaPosition"));
		else if(strict) this.setCdnaPosition(entity.getInt("cdnaposition")); // setting null is not an option due to function overloading
		if( entity.getInt("variant_cdnaposition") != null) this.setCdnaPosition(entity.getInt("variant_cdnaposition"));
		else if( entity.getInt("Variant_CdnaPosition") != null) this.setCdnaPosition(entity.getInt("Variant_CdnaPosition"));
		//set AaPosition
		// query formal name, else lowercase name
		if(entity.getInt("aaposition") != null) this.setAaPosition(entity.getInt("aaposition"));
		else if(entity.getInt("AaPosition") != null) this.setAaPosition(entity.getInt("AaPosition"));
		else if(strict) this.setAaPosition(entity.getInt("aaposition")); // setting null is not an option due to function overloading
		if( entity.getInt("variant_aaposition") != null) this.setAaPosition(entity.getInt("variant_aaposition"));
		else if( entity.getInt("Variant_AaPosition") != null) this.setAaPosition(entity.getInt("Variant_AaPosition"));
		//set VariantLength
		// query formal name, else lowercase name
		if(entity.getInt("variantlength") != null) this.setVariantLength(entity.getInt("variantlength"));
		else if(entity.getInt("VariantLength") != null) this.setVariantLength(entity.getInt("VariantLength"));
		else if(strict) this.setVariantLength(entity.getInt("variantlength")); // setting null is not an option due to function overloading
		if( entity.getInt("variant_variantlength") != null) this.setVariantLength(entity.getInt("variant_variantlength"));
		else if( entity.getInt("Variant_VariantLength") != null) this.setVariantLength(entity.getInt("Variant_VariantLength"));
		//set Event
		// query formal name, else lowercase name
		if(entity.getString("event") != null) this.setEvent(entity.getString("event"));
		else if(entity.getString("Event") != null) this.setEvent(entity.getString("Event"));
		else if(strict) this.setEvent(entity.getString("event")); // setting null is not an option due to function overloading
		if( entity.getString("variant_event") != null) this.setEvent(entity.getString("variant_event"));
		else if( entity.getString("Variant_Event") != null) this.setEvent(entity.getString("Variant_Event"));
		//set NtChange
		// query formal name, else lowercase name
		if(entity.getString("ntchange") != null) this.setNtChange(entity.getString("ntchange"));
		else if(entity.getString("NtChange") != null) this.setNtChange(entity.getString("NtChange"));
		else if(strict) this.setNtChange(entity.getString("ntchange")); // setting null is not an option due to function overloading
		if( entity.getString("variant_ntchange") != null) this.setNtChange(entity.getString("variant_ntchange"));
		else if( entity.getString("Variant_NtChange") != null) this.setNtChange(entity.getString("Variant_NtChange"));
		//set Codonchange
		// query formal name, else lowercase name
		if(entity.getString("codonchange") != null) this.setCodonchange(entity.getString("codonchange"));
		else if(entity.getString("Codonchange") != null) this.setCodonchange(entity.getString("Codonchange"));
		else if(strict) this.setCodonchange(entity.getString("codonchange")); // setting null is not an option due to function overloading
		if( entity.getString("variant_codonchange") != null) this.setCodonchange(entity.getString("variant_codonchange"));
		else if( entity.getString("Variant_Codonchange") != null) this.setCodonchange(entity.getString("Variant_Codonchange"));
		//set CdnaNotation
		// query formal name, else lowercase name
		if(entity.getString("cdnanotation") != null) this.setCdnaNotation(entity.getString("cdnanotation"));
		else if(entity.getString("CdnaNotation") != null) this.setCdnaNotation(entity.getString("CdnaNotation"));
		else if(strict) this.setCdnaNotation(entity.getString("cdnanotation")); // setting null is not an option due to function overloading
		if( entity.getString("variant_cdnanotation") != null) this.setCdnaNotation(entity.getString("variant_cdnanotation"));
		else if( entity.getString("Variant_CdnaNotation") != null) this.setCdnaNotation(entity.getString("Variant_CdnaNotation"));
		//set GdnaNotation
		// query formal name, else lowercase name
		if(entity.getString("gdnanotation") != null) this.setGdnaNotation(entity.getString("gdnanotation"));
		else if(entity.getString("GdnaNotation") != null) this.setGdnaNotation(entity.getString("GdnaNotation"));
		else if(strict) this.setGdnaNotation(entity.getString("gdnanotation")); // setting null is not an option due to function overloading
		if( entity.getString("variant_gdnanotation") != null) this.setGdnaNotation(entity.getString("variant_gdnanotation"));
		else if( entity.getString("Variant_GdnaNotation") != null) this.setGdnaNotation(entity.getString("Variant_GdnaNotation"));
		//set AaNotation
		// query formal name, else lowercase name
		if(entity.getString("aanotation") != null) this.setAaNotation(entity.getString("aanotation"));
		else if(entity.getString("AaNotation") != null) this.setAaNotation(entity.getString("AaNotation"));
		else if(strict) this.setAaNotation(entity.getString("aanotation")); // setting null is not an option due to function overloading
		if( entity.getString("variant_aanotation") != null) this.setAaNotation(entity.getString("variant_aanotation"));
		else if( entity.getString("Variant_AaNotation") != null) this.setAaNotation(entity.getString("Variant_AaNotation"));
		//set Exon
		// query formal name, else lowercase name
		if(entity.getString("exon") != null) this.setExon(entity.getString("exon"));
		else if(entity.getString("Exon") != null) this.setExon(entity.getString("Exon"));
		else if(strict) this.setExon(entity.getString("exon")); // setting null is not an option due to function overloading
		if( entity.getString("variant_exon") != null) this.setExon(entity.getString("variant_exon"));
		else if( entity.getString("Variant_Exon") != null) this.setExon(entity.getString("Variant_Exon"));
		//set Consequence
		// query formal name, else lowercase name
		if(entity.getString("consequence") != null) this.setConsequence(entity.getString("consequence"));
		else if(entity.getString("Consequence") != null) this.setConsequence(entity.getString("Consequence"));
		else if(strict) this.setConsequence(entity.getString("consequence")); // setting null is not an option due to function overloading
		if( entity.getString("variant_consequence") != null) this.setConsequence(entity.getString("variant_consequence"));
		else if( entity.getString("Variant_Consequence") != null) this.setConsequence(entity.getString("Variant_Consequence"));
		//set Inheritance
		// query formal name, else lowercase name
		if(entity.getString("inheritance") != null) this.setInheritance(entity.getString("inheritance"));
		else if(entity.getString("Inheritance") != null) this.setInheritance(entity.getString("Inheritance"));
		else if(strict) this.setInheritance(entity.getString("inheritance")); // setting null is not an option due to function overloading
		if( entity.getString("variant_inheritance") != null) this.setInheritance(entity.getString("variant_inheritance"));
		else if( entity.getString("Variant_Inheritance") != null) this.setInheritance(entity.getString("Variant_Inheritance"));
		//set ReportedSNP
		// query formal name, else lowercase name
		if(entity.getBoolean("reportedsnp") != null) this.setReportedSNP(entity.getBoolean("reportedsnp"));
		else if(entity.getBoolean("ReportedSNP") != null) this.setReportedSNP(entity.getBoolean("ReportedSNP"));
		else if(strict) this.setReportedSNP(entity.getBoolean("reportedsnp")); // setting null is not an option due to function overloading
		if( entity.getBoolean("variant_reportedsnp") != null) this.setReportedSNP(entity.getBoolean("variant_reportedsnp"));
		else if( entity.getBoolean("Variant_ReportedSNP") != null) this.setReportedSNP(entity.getBoolean("Variant_ReportedSNP"));
		//set EffectOnSplicing
		// query formal name, else lowercase name
		if(entity.getBoolean("effectonsplicing") != null) this.setEffectOnSplicing(entity.getBoolean("effectonsplicing"));
		else if(entity.getBoolean("EffectOnSplicing") != null) this.setEffectOnSplicing(entity.getBoolean("EffectOnSplicing"));
		else if(strict) this.setEffectOnSplicing(entity.getBoolean("effectonsplicing")); // setting null is not an option due to function overloading
		if( entity.getBoolean("variant_effectonsplicing") != null) this.setEffectOnSplicing(entity.getBoolean("variant_effectonsplicing"));
		else if( entity.getBoolean("Variant_EffectOnSplicing") != null) this.setEffectOnSplicing(entity.getBoolean("Variant_EffectOnSplicing"));
		//set Pathogenicity
		// query formal name, else lowercase name
		if(entity.getString("pathogenicity") != null) this.setPathogenicity(entity.getString("pathogenicity"));
		else if(entity.getString("Pathogenicity") != null) this.setPathogenicity(entity.getString("Pathogenicity"));
		else if(strict) this.setPathogenicity(entity.getString("pathogenicity")); // setting null is not an option due to function overloading
		if( entity.getString("variant_pathogenicity") != null) this.setPathogenicity(entity.getString("variant_pathogenicity"));
		else if( entity.getString("Variant_Pathogenicity") != null) this.setPathogenicity(entity.getString("Variant_Pathogenicity"));
		//set Gene
		// query formal name, else lowercase name
		if(entity.getString("gene") != null) this.setGene(entity.getString("gene"));
		else if(entity.getString("Gene") != null) this.setGene(entity.getString("Gene"));
		else if(strict) this.setGene(entity.getString("gene")); // setting null is not an option due to function overloading
		if( entity.getString("variant_gene") != null) this.setGene(entity.getString("variant_gene"));
		else if( entity.getString("Variant_Gene") != null) this.setGene(entity.getString("Variant_Gene"));
		//set IdMutation
		// query formal name, else lowercase name
		if(entity.getInt("idmutation") != null) this.setIdMutation(entity.getInt("idmutation"));
		else if(entity.getInt("IdMutation") != null) this.setIdMutation(entity.getInt("IdMutation"));
		else if(strict) this.setIdMutation(entity.getInt("idmutation")); // setting null is not an option due to function overloading
		if( entity.getInt("variant_idmutation") != null) this.setIdMutation(entity.getInt("variant_idmutation"));
		else if( entity.getInt("Variant_IdMutation") != null) this.setIdMutation(entity.getInt("Variant_IdMutation"));
		//set DetailsForMutation
		// query formal name, else lowercase name
		if(entity.getString("detailsformutation") != null) this.setDetailsForMutation(entity.getString("detailsformutation"));
		else if(entity.getString("DetailsForMutation") != null) this.setDetailsForMutation(entity.getString("DetailsForMutation"));
		else if(strict) this.setDetailsForMutation(entity.getString("detailsformutation")); // setting null is not an option due to function overloading
		if( entity.getString("variant_detailsformutation") != null) this.setDetailsForMutation(entity.getString("variant_detailsformutation"));
		else if( entity.getString("Variant_DetailsForMutation") != null) this.setDetailsForMutation(entity.getString("Variant_DetailsForMutation"));
		//set Track
		// query formal name, else lowercase name
		if( entity.get("Track") != null) { 
			this.setTrack((org.molgenis.omx.xgap.Track)entity.get("Track"));				
		}
		else if( entity.get("track") != null) { 
			this.setTrack((org.molgenis.omx.xgap.Track)entity.get("track"));				
		}
		else if( entity.get("Variant_Track") != null) { 
			this.setTrack((org.molgenis.omx.xgap.Track)entity.get("Variant_Track"));				
		}
		else if( entity.get("variant_track") != null) { 
			this.setTrack((org.molgenis.omx.xgap.Track)entity.get("Variant_Track"));				
		}
	}
	
	@Override
	public String toString()
	{
		return this.toString(false);
	}
	
	public String toString(boolean verbose)
	{
		StringBuilder sb = new StringBuilder("Variant(");
		sb.append("id='" + getId()+"' ");	
		sb.append("identifier='" + getIdentifier()+"' ");	
		sb.append("name='" + getName()+"' ");	
		sb.append("__Type='" + get__Type()+"' ");	
		sb.append("description='" + getDescription()+"' ");	
		sb.append("chromosome='" + getChromosome()+"' ");	
		sb.append("cM='" + getCM()+"' ");	
		sb.append("bpStart='" + getBpStart()+"' ");	
		sb.append("bpEnd='" + getBpEnd()+"' ");	
		sb.append("seq='" + getSeq()+"' ");	
		sb.append("symbol='" + getSymbol()+"' ");	
		sb.append("mutationPosition='" + getMutationPosition()+"' ");	
		sb.append("cdnaPosition='" + getCdnaPosition()+"' ");	
		sb.append("aaPosition='" + getAaPosition()+"' ");	
		sb.append("variantLength='" + getVariantLength()+"' ");	
		sb.append("event='" + getEvent()+"' ");	
		sb.append("ntChange='" + getNtChange()+"' ");	
		sb.append("codonchange='" + getCodonchange()+"' ");	
		sb.append("cdnaNotation='" + getCdnaNotation()+"' ");	
		sb.append("gdnaNotation='" + getGdnaNotation()+"' ");	
		sb.append("aaNotation='" + getAaNotation()+"' ");	
		sb.append("exon='" + getExon()+"' ");	
		sb.append("consequence='" + getConsequence()+"' ");	
		sb.append("inheritance='" + getInheritance()+"' ");	
		sb.append("reportedSNP='" + getReportedSNP()+"' ");	
		sb.append("effectOnSplicing='" + getEffectOnSplicing()+"' ");	
		sb.append("pathogenicity='" + getPathogenicity()+"' ");	
		sb.append("gene='" + getGene()+"' ");	
		sb.append("idMutation='" + getIdMutation()+"' ");	
		sb.append("detailsForMutation='" + getDetailsForMutation()+"' ");	
		sb.append("track='" + getTrack()+"'");	
		sb.append(");");
		return sb.toString();
	}

	@Override
	public Integer getIdValue()
	{
		return getId();
	}		
	

	@Override
	public Iterable<String> getAttributeNames()
	{
		Set<String> attributeNames = new LinkedHashSet<String>();
		for (AttributeMetaData attr : new VariantMetaData().getAttributes())
		{
			attributeNames.add(attr.getName());
		}

		return attributeNames;
	}
	
	@Override
	public java.util.List<String> getLabelAttributeNames()
	{
		java.util.List<String> result = new java.util.ArrayList<String>();
		result.add("Identifier");
		return result;
	}

	@Override
	public void set(String attributeName, Object value)
	{
		set(new MapEntity(attributeName, value), false);
	}

	@Override
	public boolean equals(Object obj)
	{
		if (this == obj) return true;
		if (obj == null) return false;
		if (!super.equals(obj)) return false;
		if (getClass() != obj.getClass()) return false;
		return true;
	}
	
	@Override
	public int hashCode()
	{
		int result = super.hashCode();
		return result;
	}
	
	@Override
	public org.molgenis.data.EntityMetaData getEntityMetaData()
	{
		return new VariantMetaData();
	}
}
