
/* File:        org.molgenis.omx/model/Protein.java
 * Generator:   org.molgenis.generators.DataTypeGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
 

package org.molgenis.omx.xgap;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.support.MapEntity;
import org.molgenis.data.Entity;

/**
 * Protein:  Trait annotations specific for proteins..
 * @author MOLGENIS generator
 */
@javax.persistence.Entity
@javax.persistence.Table(name = "Protein"
)

@javax.xml.bind.annotation.XmlAccessorType(javax.xml.bind.annotation.XmlAccessType.FIELD)
@edu.umd.cs.findbugs.annotations.SuppressWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"}, justification="Exposing internal representation is accepted")
public class Protein extends org.molgenis.omx.observ.ObservationTarget implements org.molgenis.data.Entity
{
    /** default serial version ID */
    private static final long serialVersionUID = 1L;
    
    public final static String ENTITY_NAME = "Protein";
    
	// fieldname constants
	public final static String GENE = "Gene";
	public final static String TRANSCRIPT = "Transcript";
	public final static String AMINOSEQUENCE = "AminoSequence";
	public final static String MASS = "Mass";
	public final static String ID = "id";
	
	// member variables (including setters.getters for interface)
	public String getEntityName()
	{
		return ENTITY_NAME;
	}
	

	//The gene that produces this protein[type=xref]

    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="Gene")  
	
				

	private org.molgenis.omx.xgap.Gene gene = null;

	//The transcript variant that produces this protein[type=xref]

    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="Transcript")  
	
				

	private org.molgenis.omx.xgap.Transcript transcript = null;

	//The aminoacid sequence.[type=text]

	@javax.persistence.Lob
	@javax.persistence.Column(name="AminoSequence")
	
				

	private String aminoSequence =  null;

	//The mass of this metabolite[type=decimal]

	@javax.persistence.Column(name="Mass")
	@javax.xml.bind.annotation.XmlElement(name="mass")
	
				

	private Double mass =  null;

	//automatically generated internal id, only for internal use.[type=int]

	

	//constructors
	public Protein()
	{
		//set the type for a new instance
		set__Type(this.getClass().getSimpleName());
	}
	
	//getters and setters
	/**
	 * Get the The gene that produces this protein.
	 * @return gene.
	 */
	public org.molgenis.omx.xgap.Gene getGene()
	{
		return this.gene;
	}	
	
	/**
	 * Set the The gene that produces this protein.
	 * @param gene
	 */
	public void setGene( org.molgenis.omx.xgap.Gene gene)
	{
		
		this.gene = gene;
	}

	

	/**
	 * Get the The transcript variant that produces this protein.
	 * @return transcript.
	 */
	public org.molgenis.omx.xgap.Transcript getTranscript()
	{
		return this.transcript;
	}	
	
	/**
	 * Set the The transcript variant that produces this protein.
	 * @param transcript
	 */
	public void setTranscript( org.molgenis.omx.xgap.Transcript transcript)
	{
		
		this.transcript = transcript;
	}

	

	/**
	 * Get the The aminoacid sequence..
	 * @return aminoSequence.
	 */
	public String getAminoSequence()
	{
		return this.aminoSequence;
	}	
	
	/**
	 * Set the The aminoacid sequence..
	 * @param aminoSequence
	 */
	public void setAminoSequence( String aminoSequence)
	{
		
		this.aminoSequence = aminoSequence;
	}

	

	/**
	 * Get the The mass of this metabolite.
	 * @return mass.
	 */
	public Double getMass()
	{
		return this.mass;
	}	
	
	/**
	 * Set the The mass of this metabolite.
	 * @param mass
	 */
	public void setMass( Double mass)
	{
		
		this.mass = mass;
	}

	

	

	


	/**
	 * Generic getter. Get the property by using the name.
	 */
	@Override
	public Object get(String name)
	{
		name = name.toLowerCase();
		if (name.equals("id"))
			return getId();
		if (name.equals("identifier"))
			return getIdentifier();
		if (name.equals("name"))
			return getName();
		if (name.equals("__type"))
			return get__Type();
		if(name.equals("__type_label"))
			return get__TypeLabel();			
		if (name.equals("description"))
			return getDescription();
		if (name.equals("gene"))
			return getGene();
		if (name.equals("transcript"))
			return getTranscript();
		if (name.equals("aminosequence"))
			return getAminoSequence();
		if (name.equals("mass"))
			return getMass();
		return null;
	}	
	
	@Override
	public void set(org.molgenis.data.Entity entity, boolean strict)
	{
		//set Id
		// query formal name, else lowercase name
		if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(strict) this.setId(entity.getInt("id")); // setting null is not an option due to function overloading
		if( entity.getInt("protein_id") != null) this.setId(entity.getInt("protein_id"));
		else if( entity.getInt("Protein_id") != null) this.setId(entity.getInt("Protein_id"));
		//set Identifier
		// query formal name, else lowercase name
		if(entity.getString("identifier") != null) this.setIdentifier(entity.getString("identifier"));
		else if(entity.getString("Identifier") != null) this.setIdentifier(entity.getString("Identifier"));
		else if(strict) this.setIdentifier(entity.getString("identifier")); // setting null is not an option due to function overloading
		if( entity.getString("protein_identifier") != null) this.setIdentifier(entity.getString("protein_identifier"));
		else if( entity.getString("Protein_Identifier") != null) this.setIdentifier(entity.getString("Protein_Identifier"));
		//set Name
		// query formal name, else lowercase name
		if(entity.getString("name") != null) this.setName(entity.getString("name"));
		else if(entity.getString("Name") != null) this.setName(entity.getString("Name"));
		else if(strict) this.setName(entity.getString("name")); // setting null is not an option due to function overloading
		if( entity.getString("protein_name") != null) this.setName(entity.getString("protein_name"));
		else if( entity.getString("Protein_Name") != null) this.setName(entity.getString("Protein_Name"));
		//set __Type
		// query formal name, else lowercase name
		if(entity.getString("__type") != null) this.set__Type(entity.getString("__type"));
		else if(entity.getString("__Type") != null) this.set__Type(entity.getString("__Type"));
		else if(strict) this.set__Type(entity.getString("__type")); // setting null is not an option due to function overloading
		if( entity.getString("protein___type") != null) this.set__Type(entity.getString("protein___type"));
		else if( entity.getString("Protein___Type") != null) this.set__Type(entity.getString("Protein___Type"));
		//set Description
		// query formal name, else lowercase name
		if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(strict) this.setDescription(entity.getString("description")); // setting null is not an option due to function overloading
		if( entity.getString("protein_description") != null) this.setDescription(entity.getString("protein_description"));
		else if( entity.getString("Protein_description") != null) this.setDescription(entity.getString("Protein_description"));
		//set Gene
		// query formal name, else lowercase name
		if( entity.getEntity("Gene", org.molgenis.omx.xgap.Gene.class) != null) { 
			this.setGene(entity.getEntity("Gene", org.molgenis.omx.xgap.Gene.class));				
		}
		else if( entity.getEntity("gene", org.molgenis.omx.xgap.Gene.class) != null) { 
			this.setGene(entity.getEntity("gene", org.molgenis.omx.xgap.Gene.class));				
		}
		else if( entity.getEntity("Protein_Gene", org.molgenis.omx.xgap.Gene.class) != null) { 
			this.setGene(entity.getEntity("Protein_Gene", org.molgenis.omx.xgap.Gene.class));				
		}
		else if( entity.getEntity("protein_gene", org.molgenis.omx.xgap.Gene.class) != null) { 
			this.setGene(entity.getEntity("Protein_Gene", org.molgenis.omx.xgap.Gene.class));				
		}
		//set Transcript
		// query formal name, else lowercase name
		if( entity.getEntity("Transcript", org.molgenis.omx.xgap.Transcript.class) != null) { 
			this.setTranscript(entity.getEntity("Transcript", org.molgenis.omx.xgap.Transcript.class));				
		}
		else if( entity.getEntity("transcript", org.molgenis.omx.xgap.Transcript.class) != null) { 
			this.setTranscript(entity.getEntity("transcript", org.molgenis.omx.xgap.Transcript.class));				
		}
		else if( entity.getEntity("Protein_Transcript", org.molgenis.omx.xgap.Transcript.class) != null) { 
			this.setTranscript(entity.getEntity("Protein_Transcript", org.molgenis.omx.xgap.Transcript.class));				
		}
		else if( entity.getEntity("protein_transcript", org.molgenis.omx.xgap.Transcript.class) != null) { 
			this.setTranscript(entity.getEntity("Protein_Transcript", org.molgenis.omx.xgap.Transcript.class));				
		}
		//set AminoSequence
		// query formal name, else lowercase name
		if(entity.getString("aminosequence") != null) this.setAminoSequence(entity.getString("aminosequence"));
		else if(entity.getString("AminoSequence") != null) this.setAminoSequence(entity.getString("AminoSequence"));
		else if(strict) this.setAminoSequence(entity.getString("aminosequence")); // setting null is not an option due to function overloading
		if( entity.getString("protein_aminosequence") != null) this.setAminoSequence(entity.getString("protein_aminosequence"));
		else if( entity.getString("Protein_AminoSequence") != null) this.setAminoSequence(entity.getString("Protein_AminoSequence"));
		//set Mass
		// query formal name, else lowercase name
		if(entity.getDouble("mass") != null) this.setMass(entity.getDouble("mass"));
		else if(entity.getDouble("Mass") != null) this.setMass(entity.getDouble("Mass"));
		else if(strict) this.setMass(entity.getDouble("mass")); // setting null is not an option due to function overloading
		if( entity.getDouble("protein_mass") != null) this.setMass(entity.getDouble("protein_mass"));
		else if( entity.getDouble("Protein_Mass") != null) this.setMass(entity.getDouble("Protein_Mass"));
	}
	
	@Override
	public String toString()
	{
		return this.toString(false);
	}
	
	public String toString(boolean verbose)
	{
		StringBuilder sb = new StringBuilder("Protein(");
		sb.append("id='" + getId()+"' ");	
		sb.append("identifier='" + getIdentifier()+"' ");	
		sb.append("name='" + getName()+"' ");	
		sb.append("__Type='" + get__Type()+"' ");	
		sb.append("description='" + getDescription()+"' ");	
		sb.append("gene='" + getGene()+"' ");	
		sb.append("transcript='" + getTranscript()+"' ");	
		sb.append("aminoSequence='" + getAminoSequence()+"' ");	
		sb.append("mass='" + getMass()+"'");	
		sb.append(");");
		return sb.toString();
	}

	@Override
	public Integer getIdValue()
	{
		return getId();
	}		
	

	@Override
	public Iterable<String> getAttributeNames()
	{
		Set<String> attributeNames = new LinkedHashSet<String>();
		for (AttributeMetaData attr : new ProteinMetaData().getAttributes())
		{
			attributeNames.add(attr.getName());
		}

		return attributeNames;
	}
	
	@Override
	public java.util.List<String> getLabelAttributeNames()
	{
		java.util.List<String> result = new java.util.ArrayList<String>();
		result.add("Identifier");
		return result;
	}

	@Override
	public void set(String attributeName, Object value)
	{
		if("id".equalsIgnoreCase(attributeName)) {
			this.setId((Integer)value); 
			return;
		}
		if("Identifier".equalsIgnoreCase(attributeName)) {
			this.setIdentifier((String)value); 
			return;
		}
		if("Name".equalsIgnoreCase(attributeName)) {
			this.setName((String)value); 
			return;
		}
		if("__Type".equalsIgnoreCase(attributeName)) {
			this.set__Type((String)value); 
			return;
		}
		if("description".equalsIgnoreCase(attributeName)) {
			this.setDescription((String)value); 
			return;
		}
		if("Gene".equalsIgnoreCase(attributeName)) {
			org.molgenis.omx.xgap.Gene e = new org.molgenis.omx.xgap.Gene();
			e.set((Entity)value);
			this.setGene(e); 
			return;
		}
		if("Transcript".equalsIgnoreCase(attributeName)) {
			org.molgenis.omx.xgap.Transcript e = new org.molgenis.omx.xgap.Transcript();
			e.set((Entity)value);
			this.setTranscript(e); 
			return;
		}
		if("AminoSequence".equalsIgnoreCase(attributeName)) {
			this.setAminoSequence((String)value); 
			return;
		}
		if("Mass".equalsIgnoreCase(attributeName)) {
			this.setMass((Double)value); 
			return;
		}
	}

	@Override
	public boolean equals(Object obj)
	{
		if (this == obj) return true;
		if (obj == null) return false;
		if (!super.equals(obj)) return false;
		if (getClass() != obj.getClass()) return false;
		return true;
	}
	
	@Override
	public int hashCode()
	{
		int result = super.hashCode();
		return result;
	}
	
	@Override
	public org.molgenis.data.EntityMetaData getEntityMetaData()
	{
		return new ProteinMetaData();
	}
}
