
/* File:        org.molgenis.omx/model/Probe.java
 * Generator:   org.molgenis.generators.DataTypeGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
 

package org.molgenis.omx.xgap;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.support.MapEntity;


/**
 * Probe:  A piece of sequence that reports for the expression of
				a gene, typically spotted onto a microarray..
 * @author MOLGENIS generator
 */
@javax.persistence.Entity
@javax.persistence.Table(name = "Probe"
)

@javax.xml.bind.annotation.XmlAccessorType(javax.xml.bind.annotation.XmlAccessType.FIELD)
@edu.umd.cs.findbugs.annotations.SuppressWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"}, justification="Exposing internal representation is accepted")
public class Probe extends org.molgenis.omx.observ.ObservationTarget implements org.molgenis.data.Entity, org.molgenis.omx.xgap.Locus
{
    /** default serial version ID */
    private static final long serialVersionUID = 1L;
    
    public final static String ENTITY_NAME = "Probe";
    
	// fieldname constants
	public final static String CHROMOSOME = "Chromosome";
	public final static String CM = "cM";
	public final static String BPSTART = "bpStart";
	public final static String BPEND = "bpEnd";
	public final static String SEQ = "Seq";
	public final static String SYMBOL = "Symbol";
	public final static String MISMATCH = "Mismatch";
	public final static String PROBESET = "ProbeSet";
	public final static String REPORTSFOR = "ReportsFor";
	public final static String ID = "id";
	
	// member variables (including setters.getters for interface)
	public String getEntityName()
	{
		return ENTITY_NAME;
	}
	

	//Reference to the chromosome this     position belongs to.[type=xref]

    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="Chromosome")  
	
				

	private org.molgenis.omx.xgap.Chromosome chromosome = null;

	//genetic map position in centi morgan (cM).[type=decimal]

	@javax.persistence.Column(name="cM")
	@javax.xml.bind.annotation.XmlElement(name="cM")
	
				

	private Double cM =  null;

	//numeric basepair postion (5') on the chromosome[type=long]

	@javax.persistence.Column(name="bpStart")
	@javax.xml.bind.annotation.XmlElement(name="bpStart")
	
				

	private Long bpStart =  null;

	//numeric basepair postion (3') on the chromosome[type=long]

	@javax.persistence.Column(name="bpEnd")
	@javax.xml.bind.annotation.XmlElement(name="bpEnd")
	
				

	private Long bpEnd =  null;

	//The FASTA text representation of the sequence.[type=text]

	@javax.persistence.Lob
	@javax.persistence.Column(name="Seq")
	
				

	private String seq =  null;

	//todo[type=string]

	@javax.persistence.Column(name="Symbol", length=255)
	@javax.xml.bind.annotation.XmlElement(name="symbol")
	
				

	private String symbol =  null;

	//Indicating whether the probe is a match[type=bool]

	@javax.persistence.Column(name="Mismatch", nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="mismatch")
	
				

	@javax.validation.constraints.NotNull
	private Boolean mismatch =  false;

	//Optional: probeset this probe belongs to (e.g., in Affymetrix assays).[type=xref]

    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="ProbeSet")  
	
				

	private org.molgenis.omx.xgap.ProbeSet probeSet = null;

	//The gene this probe reports for.[type=xref]

    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="ReportsFor")  
	
				

	private org.molgenis.omx.xgap.Gene reportsFor = null;

	//automatically generated internal id, only for internal use.[type=int]

	

	//constructors
	public Probe()
	{
		//set the type for a new instance
		set__Type(this.getClass().getSimpleName());
	}
	
	//getters and setters
	/**
	 * Get the Reference to the chromosome this     position belongs to..
	 * @return chromosome.
	 */
	public org.molgenis.omx.xgap.Chromosome getChromosome()
	{
		return this.chromosome;
	}	
	
	/**
	 * Set the Reference to the chromosome this     position belongs to..
	 * @param chromosome
	 */
	public void setChromosome( org.molgenis.omx.xgap.Chromosome chromosome)
	{
		
		this.chromosome = chromosome;
	}

	

	/**
	 * Get the genetic map position in centi morgan (cM)..
	 * @return cM.
	 */
	public Double getCM()
	{
		return this.cM;
	}	
	
	/**
	 * Set the genetic map position in centi morgan (cM)..
	 * @param cM
	 */
	public void setCM( Double cM)
	{
		
		this.cM = cM;
	}

	

	/**
	 * Get the numeric basepair postion (5') on the chromosome.
	 * @return bpStart.
	 */
	public Long getBpStart()
	{
		return this.bpStart;
	}	
	
	/**
	 * Set the numeric basepair postion (5') on the chromosome.
	 * @param bpStart
	 */
	public void setBpStart( Long bpStart)
	{
		
		this.bpStart = bpStart;
	}

	

	/**
	 * Get the numeric basepair postion (3') on the chromosome.
	 * @return bpEnd.
	 */
	public Long getBpEnd()
	{
		return this.bpEnd;
	}	
	
	/**
	 * Set the numeric basepair postion (3') on the chromosome.
	 * @param bpEnd
	 */
	public void setBpEnd( Long bpEnd)
	{
		
		this.bpEnd = bpEnd;
	}

	

	/**
	 * Get the The FASTA text representation of the sequence..
	 * @return seq.
	 */
	public String getSeq()
	{
		return this.seq;
	}	
	
	/**
	 * Set the The FASTA text representation of the sequence..
	 * @param seq
	 */
	public void setSeq( String seq)
	{
		
		this.seq = seq;
	}

	

	/**
	 * Get the todo.
	 * @return symbol.
	 */
	public String getSymbol()
	{
		return this.symbol;
	}	
	
	/**
	 * Set the todo.
	 * @param symbol
	 */
	public void setSymbol( String symbol)
	{
		
		this.symbol = symbol;
	}

	

	/**
	 * Get the Indicating whether the probe is a match.
	 * @return mismatch.
	 */
	public Boolean getMismatch()
	{
		return this.mismatch;
	}	
	
	/**
	 * Set the Indicating whether the probe is a match.
	 * @param mismatch
	 */
	public void setMismatch( Boolean mismatch)
	{
		
		this.mismatch = mismatch;
	}

	

	/**
	 * Get the Optional: probeset this probe belongs to (e.g., in Affymetrix assays)..
	 * @return probeSet.
	 */
	public org.molgenis.omx.xgap.ProbeSet getProbeSet()
	{
		return this.probeSet;
	}	
	
	/**
	 * Set the Optional: probeset this probe belongs to (e.g., in Affymetrix assays)..
	 * @param probeSet
	 */
	public void setProbeSet( org.molgenis.omx.xgap.ProbeSet probeSet)
	{
		
		this.probeSet = probeSet;
	}

	

	/**
	 * Get the The gene this probe reports for..
	 * @return reportsFor.
	 */
	public org.molgenis.omx.xgap.Gene getReportsFor()
	{
		return this.reportsFor;
	}	
	
	/**
	 * Set the The gene this probe reports for..
	 * @param reportsFor
	 */
	public void setReportsFor( org.molgenis.omx.xgap.Gene reportsFor)
	{
		
		this.reportsFor = reportsFor;
	}

	

	

	


	/**
	 * Generic getter. Get the property by using the name.
	 */
	@Override
	public Object get(String name)
	{
		name = name.toLowerCase();
		if (name.equals("id"))
			return getId();
		if (name.equals("identifier"))
			return getIdentifier();
		if (name.equals("name"))
			return getName();
		if (name.equals("__type"))
			return get__Type();
		if(name.equals("__type_label"))
			return get__TypeLabel();			
		if (name.equals("description"))
			return getDescription();
		if (name.equals("chromosome"))
			return getChromosome();
		if (name.equals("cm"))
			return getCM();
		if (name.equals("bpstart"))
			return getBpStart();
		if (name.equals("bpend"))
			return getBpEnd();
		if (name.equals("seq"))
			return getSeq();
		if (name.equals("symbol"))
			return getSymbol();
		if (name.equals("mismatch"))
			return getMismatch();
		if (name.equals("probeset"))
			return getProbeSet();
		if (name.equals("reportsfor"))
			return getReportsFor();
		return null;
	}	
	
	@Override
	public void set(org.molgenis.data.Entity entity, boolean strict)
	{
		//set Id
		// query formal name, else lowercase name
		if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(strict) this.setId(entity.getInt("id")); // setting null is not an option due to function overloading
		if( entity.getInt("probe_id") != null) this.setId(entity.getInt("probe_id"));
		else if( entity.getInt("Probe_id") != null) this.setId(entity.getInt("Probe_id"));
		//set Identifier
		// query formal name, else lowercase name
		if(entity.getString("identifier") != null) this.setIdentifier(entity.getString("identifier"));
		else if(entity.getString("Identifier") != null) this.setIdentifier(entity.getString("Identifier"));
		else if(strict) this.setIdentifier(entity.getString("identifier")); // setting null is not an option due to function overloading
		if( entity.getString("probe_identifier") != null) this.setIdentifier(entity.getString("probe_identifier"));
		else if( entity.getString("Probe_Identifier") != null) this.setIdentifier(entity.getString("Probe_Identifier"));
		//set Name
		// query formal name, else lowercase name
		if(entity.getString("name") != null) this.setName(entity.getString("name"));
		else if(entity.getString("Name") != null) this.setName(entity.getString("Name"));
		else if(strict) this.setName(entity.getString("name")); // setting null is not an option due to function overloading
		if( entity.getString("probe_name") != null) this.setName(entity.getString("probe_name"));
		else if( entity.getString("Probe_Name") != null) this.setName(entity.getString("Probe_Name"));
		//set __Type
		// query formal name, else lowercase name
		if(entity.getString("__type") != null) this.set__Type(entity.getString("__type"));
		else if(entity.getString("__Type") != null) this.set__Type(entity.getString("__Type"));
		else if(strict) this.set__Type(entity.getString("__type")); // setting null is not an option due to function overloading
		if( entity.getString("probe___type") != null) this.set__Type(entity.getString("probe___type"));
		else if( entity.getString("Probe___Type") != null) this.set__Type(entity.getString("Probe___Type"));
		//set Description
		// query formal name, else lowercase name
		if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(strict) this.setDescription(entity.getString("description")); // setting null is not an option due to function overloading
		if( entity.getString("probe_description") != null) this.setDescription(entity.getString("probe_description"));
		else if( entity.getString("Probe_description") != null) this.setDescription(entity.getString("Probe_description"));
		//set Chromosome
		// query formal name, else lowercase name
		if( entity.get("Chromosome") != null) { 
			this.setChromosome((org.molgenis.omx.xgap.Chromosome)entity.get("Chromosome"));				
		}
		else if( entity.get("chromosome") != null) { 
			this.setChromosome((org.molgenis.omx.xgap.Chromosome)entity.get("chromosome"));				
		}
		else if( entity.get("Probe_Chromosome") != null) { 
			this.setChromosome((org.molgenis.omx.xgap.Chromosome)entity.get("Probe_Chromosome"));				
		}
		else if( entity.get("probe_chromosome") != null) { 
			this.setChromosome((org.molgenis.omx.xgap.Chromosome)entity.get("Probe_Chromosome"));				
		}
		//set CM
		// query formal name, else lowercase name
		if(entity.getDouble("cm") != null) this.setCM(entity.getDouble("cm"));
		else if(entity.getDouble("cM") != null) this.setCM(entity.getDouble("cM"));
		else if(strict) this.setCM(entity.getDouble("cm")); // setting null is not an option due to function overloading
		if( entity.getDouble("probe_cm") != null) this.setCM(entity.getDouble("probe_cm"));
		else if( entity.getDouble("Probe_cM") != null) this.setCM(entity.getDouble("Probe_cM"));
		//set BpStart
		// query formal name, else lowercase name
		if(entity.getLong("bpstart") != null) this.setBpStart(entity.getLong("bpstart"));
		else if(entity.getLong("bpStart") != null) this.setBpStart(entity.getLong("bpStart"));
		else if(strict) this.setBpStart(entity.getLong("bpstart")); // setting null is not an option due to function overloading
		if( entity.getLong("probe_bpstart") != null) this.setBpStart(entity.getLong("probe_bpstart"));
		else if( entity.getLong("Probe_bpStart") != null) this.setBpStart(entity.getLong("Probe_bpStart"));
		//set BpEnd
		// query formal name, else lowercase name
		if(entity.getLong("bpend") != null) this.setBpEnd(entity.getLong("bpend"));
		else if(entity.getLong("bpEnd") != null) this.setBpEnd(entity.getLong("bpEnd"));
		else if(strict) this.setBpEnd(entity.getLong("bpend")); // setting null is not an option due to function overloading
		if( entity.getLong("probe_bpend") != null) this.setBpEnd(entity.getLong("probe_bpend"));
		else if( entity.getLong("Probe_bpEnd") != null) this.setBpEnd(entity.getLong("Probe_bpEnd"));
		//set Seq
		// query formal name, else lowercase name
		if(entity.getString("seq") != null) this.setSeq(entity.getString("seq"));
		else if(entity.getString("Seq") != null) this.setSeq(entity.getString("Seq"));
		else if(strict) this.setSeq(entity.getString("seq")); // setting null is not an option due to function overloading
		if( entity.getString("probe_seq") != null) this.setSeq(entity.getString("probe_seq"));
		else if( entity.getString("Probe_Seq") != null) this.setSeq(entity.getString("Probe_Seq"));
		//set Symbol
		// query formal name, else lowercase name
		if(entity.getString("symbol") != null) this.setSymbol(entity.getString("symbol"));
		else if(entity.getString("Symbol") != null) this.setSymbol(entity.getString("Symbol"));
		else if(strict) this.setSymbol(entity.getString("symbol")); // setting null is not an option due to function overloading
		if( entity.getString("probe_symbol") != null) this.setSymbol(entity.getString("probe_symbol"));
		else if( entity.getString("Probe_Symbol") != null) this.setSymbol(entity.getString("Probe_Symbol"));
		//set Mismatch
		// query formal name, else lowercase name
		if(entity.getBoolean("mismatch") != null) this.setMismatch(entity.getBoolean("mismatch"));
		else if(entity.getBoolean("Mismatch") != null) this.setMismatch(entity.getBoolean("Mismatch"));
		else if(strict) this.setMismatch(entity.getBoolean("mismatch")); // setting null is not an option due to function overloading
		if( entity.getBoolean("probe_mismatch") != null) this.setMismatch(entity.getBoolean("probe_mismatch"));
		else if( entity.getBoolean("Probe_Mismatch") != null) this.setMismatch(entity.getBoolean("Probe_Mismatch"));
		//set ProbeSet
		// query formal name, else lowercase name
		if( entity.get("ProbeSet") != null) { 
			this.setProbeSet((org.molgenis.omx.xgap.ProbeSet)entity.get("ProbeSet"));				
		}
		else if( entity.get("probeset") != null) { 
			this.setProbeSet((org.molgenis.omx.xgap.ProbeSet)entity.get("probeset"));				
		}
		else if( entity.get("Probe_ProbeSet") != null) { 
			this.setProbeSet((org.molgenis.omx.xgap.ProbeSet)entity.get("Probe_ProbeSet"));				
		}
		else if( entity.get("probe_probeset") != null) { 
			this.setProbeSet((org.molgenis.omx.xgap.ProbeSet)entity.get("Probe_ProbeSet"));				
		}
		//set ReportsFor
		// query formal name, else lowercase name
		if( entity.get("ReportsFor") != null) { 
			this.setReportsFor((org.molgenis.omx.xgap.Gene)entity.get("ReportsFor"));				
		}
		else if( entity.get("reportsfor") != null) { 
			this.setReportsFor((org.molgenis.omx.xgap.Gene)entity.get("reportsfor"));				
		}
		else if( entity.get("Probe_ReportsFor") != null) { 
			this.setReportsFor((org.molgenis.omx.xgap.Gene)entity.get("Probe_ReportsFor"));				
		}
		else if( entity.get("probe_reportsfor") != null) { 
			this.setReportsFor((org.molgenis.omx.xgap.Gene)entity.get("Probe_ReportsFor"));				
		}
	}
	
	@Override
	public String toString()
	{
		return this.toString(false);
	}
	
	public String toString(boolean verbose)
	{
		StringBuilder sb = new StringBuilder("Probe(");
		sb.append("id='" + getId()+"' ");	
		sb.append("identifier='" + getIdentifier()+"' ");	
		sb.append("name='" + getName()+"' ");	
		sb.append("__Type='" + get__Type()+"' ");	
		sb.append("description='" + getDescription()+"' ");	
		sb.append("chromosome='" + getChromosome()+"' ");	
		sb.append("cM='" + getCM()+"' ");	
		sb.append("bpStart='" + getBpStart()+"' ");	
		sb.append("bpEnd='" + getBpEnd()+"' ");	
		sb.append("seq='" + getSeq()+"' ");	
		sb.append("symbol='" + getSymbol()+"' ");	
		sb.append("mismatch='" + getMismatch()+"' ");	
		sb.append("probeSet='" + getProbeSet()+"' ");	
		sb.append("reportsFor='" + getReportsFor()+"'");	
		sb.append(");");
		return sb.toString();
	}

	@Override
	public Integer getIdValue()
	{
		return getId();
	}		
	

	@Override
	public Iterable<String> getAttributeNames()
	{
		Set<String> attributeNames = new LinkedHashSet<String>();
		for (AttributeMetaData attr : new ProbeMetaData().getAttributes())
		{
			attributeNames.add(attr.getName());
		}

		return attributeNames;
	}
	
	@Override
	public java.util.List<String> getLabelAttributeNames()
	{
		java.util.List<String> result = new java.util.ArrayList<String>();
		result.add("Identifier");
		return result;
	}

	@Override
	public void set(String attributeName, Object value)
	{
		if("id".equalsIgnoreCase(attributeName)) {
			this.setId((Integer) value); 
			return;
		}
		if("Identifier".equalsIgnoreCase(attributeName)) {
			this.setIdentifier((String) value); 
			return;
		}
		if("Name".equalsIgnoreCase(attributeName)) {
			this.setName((String) value); 
			return;
		}
		if("__Type".equalsIgnoreCase(attributeName)) {
			this.set__Type((String) value); 
			return;
		}
		if("description".equalsIgnoreCase(attributeName)) {
			this.setDescription((String) value); 
			return;
		}
		if("Chromosome".equalsIgnoreCase(attributeName)) {
			this.setChromosome((org.molgenis.omx.xgap.Chromosome) value); 
			return;
		}
		if("cM".equalsIgnoreCase(attributeName)) {
			this.setCM((Double) value); 
			return;
		}
		if("bpStart".equalsIgnoreCase(attributeName)) {
			this.setBpStart((Long) value); 
			return;
		}
		if("bpEnd".equalsIgnoreCase(attributeName)) {
			this.setBpEnd((Long) value); 
			return;
		}
		if("Seq".equalsIgnoreCase(attributeName)) {
			this.setSeq((String) value); 
			return;
		}
		if("Symbol".equalsIgnoreCase(attributeName)) {
			this.setSymbol((String) value); 
			return;
		}
		if("Mismatch".equalsIgnoreCase(attributeName)) {
			this.setMismatch((Boolean) value); 
			return;
		}
		if("ProbeSet".equalsIgnoreCase(attributeName)) {
			this.setProbeSet((org.molgenis.omx.xgap.ProbeSet) value); 
			return;
		}
		if("ReportsFor".equalsIgnoreCase(attributeName)) {
			this.setReportsFor((org.molgenis.omx.xgap.Gene) value); 
			return;
		}
	}

	@Override
	public boolean equals(Object obj)
	{
		if (this == obj) return true;
		if (obj == null) return false;
		if (!super.equals(obj)) return false;
		if (getClass() != obj.getClass()) return false;
		return true;
	}
	
	@Override
	public int hashCode()
	{
		int result = super.hashCode();
		return result;
	}
	
	@Override
	public org.molgenis.data.EntityMetaData getEntityMetaData()
	{
		return new ProbeMetaData();
	}
}
