/* Date:        November 14, 2013
 * Template:	MapperSecurityDecoratorGen.java.ftl
 * generator:   org.molgenis.generators.db.MapperSecurityDecoratorGen 4.0.0-testing
 */

package org.molgenis.omx.xgap.db;

import static org.molgenis.security.SecurityUtils.currentUserHasRole;

import java.util.List;

import java.text.ParseException;
import org.molgenis.framework.db.DatabaseAccessException;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Mapper;
import org.molgenis.framework.db.MapperDecorator;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.util.ApplicationContextProvider;

/**
 * TODO add column level security filters
 */
public class SpotSecurityDecorator<E extends org.molgenis.omx.xgap.Spot> extends MapperDecorator<E>
{
	public SpotSecurityDecorator(Mapper<E> generatedMapper)
	{
		super(generatedMapper);
	}

	@Override
	public int add(List<E> entities) throws DatabaseException
	{
		if (!currentUserHasRole("ROLE_SU", "ROLE_ENTITY_WRITE_SPOT"))
		{
			throw new DatabaseAccessException("No write permission on org.molgenis.omx.xgap.Spot");
		}
		
		return super.add(entities);
	}

	@Override
	public int update(List<E> entities) throws DatabaseException
	{
		if (!currentUserHasRole("ROLE_SU", "ROLE_ENTITY_WRITE_SPOT"))
		{
			throw new DatabaseAccessException("No write permission on org.molgenis.omx.xgap.Spot");
		}
		return super.update(entities);
	}

	@Override
	public int remove(List<E> entities) throws DatabaseException
	{
		if (!currentUserHasRole("ROLE_SU", "ROLE_ENTITY_WRITE_SPOT"))
		{
			throw new DatabaseAccessException("No write permission on org.molgenis.omx.xgap.Spot");
		}
		return super.remove(entities);
	}

	@Override
	public int count(QueryRule... rules) throws DatabaseException
	{
		if (!currentUserHasRole("ROLE_SU", "ROLE_ENTITY_READ_SPOT"))
		{
			throw new DatabaseAccessException("No read permission on org.molgenis.omx.xgap.Spot");
		}
		return super.count(rules);
	}

	@Override
	public List<E> find(QueryRule ...rules) throws DatabaseException
	{
		if (!currentUserHasRole("ROLE_SU", "ROLE_ENTITY_READ_SPOT"))
		{
			throw new DatabaseAccessException("No read permission on org.molgenis.omx.xgap.Spot");
		}
		return super.find(rules);
	}


	@Override
	public E findById(Object id) throws DatabaseException
	{
		if (!currentUserHasRole("ROLE_SU", "ROLE_ENTITY_READ_SPOT"))
		{
			throw new DatabaseAccessException("No read permission on org.molgenis.omx.xgap.Spot");
		}
		return super.findById(id);
	}

	@Override
	public int executeAdd(List<? extends E> entities) throws DatabaseException
	{
		if (!currentUserHasRole("ROLE_SU", "ROLE_ENTITY_WRITE_SPOT"))
		{
			throw new DatabaseAccessException("No write permission on org.molgenis.omx.xgap.Spot");
		}
		return super.executeAdd(entities);
	}
	
	@Override
	public int executeUpdate(List<? extends E> entities) throws DatabaseException
	{
		if (!currentUserHasRole("ROLE_SU", "ROLE_ENTITY_WRITE_SPOT"))
		{
			throw new DatabaseAccessException("No write permission on org.molgenis.omx.xgap.Spot");
		}
		return super.executeUpdate(entities);
	}
	
	@Override
	public int executeRemove(List<? extends E> entities) throws DatabaseException
	{
		if (!currentUserHasRole("ROLE_SU", "ROLE_ENTITY_WRITE_SPOT"))
		{
			throw new DatabaseAccessException("No write permission on org.molgenis.omx.xgap.Spot");
		}
		return super.executeRemove(entities);
	}
	
	@Override
	public void resolveForeignKeys(List<E> entities) throws ParseException, DatabaseException
	{
		if (!currentUserHasRole("ROLE_SU", "ROLE_ENTITY_WRITE_SPOT"))
		{
			throw new DatabaseAccessException("No write permission on org.molgenis.omx.xgap.Spot");
		}
		super.resolveForeignKeys(entities);
	}
	
	
	@Override
	public String createFindSqlInclRules(QueryRule[] rules) throws DatabaseException
	{
		if (!currentUserHasRole("ROLE_SU", "ROLE_ENTITY_READ_SPOT"))
		{
			throw new DatabaseAccessException("No write permission on org.molgenis.omx.xgap.Spot");
		}	
		return super.createFindSqlInclRules(rules);
	}
}