/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.importer.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseAccessException;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.server.MolgenisSettings;
import org.molgenis.omx.observ.Category;
import org.molgenis.omx.observ.Characteristic;
import org.molgenis.omx.observ.DataSet;
import org.molgenis.omx.observ.ObservableFeature;
import org.molgenis.omx.observ.ObservationSet;
import org.molgenis.omx.observ.ObservedValue;
import org.molgenis.omx.observ.Protocol;
import org.molgenis.omx.observ.value.CategoricalValue;
import org.molgenis.search.SearchService;
import org.molgenis.util.Entity;
import org.molgenis.util.HandleRequestDelegationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;

@Controller
@RequestMapping(value={"/plugin/datasetdeleter"})
public class DataSetDeleterController {
    public static final String URI = "/plugin/datasetdeleter";
    private static final String[] runtimeProperties = new String[]{"app.href.logo", "app.href.css"};
    private static final Logger logger = Logger.getLogger(DataSetDeleterController.class);
    int teller = 0;
    @Autowired
    private Database database;
    @Autowired
    private MolgenisSettings molgenisSettings;
    @Autowired
    private SearchService searchService;

    @RequestMapping(method={RequestMethod.GET})
    public String init(Model model) throws Exception {
        for (String property : runtimeProperties) {
            String value = this.molgenisSettings.getProperty(property);
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            model.addAttribute(property.replaceAll("\\.", "_"), (Object)value);
        }
        return "datasetdeleter";
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public String delete(@RequestParam(value="dataset") String datasetIdentifier, WebRequest webRequest) throws HandleRequestDelegationException, Exception {
        this.database.beginTx();
        boolean deletemetadata = webRequest.getParameter("deletemetadata") != null;
        String dataSetName = this.delete(datasetIdentifier, deletemetadata);
        return dataSetName;
    }

    public String delete(String datasetIdentifier, boolean deletemetadata) throws DatabaseException, IOException {
        DataSet dataSet = (DataSet)this.database.find(DataSet.class, new QueryRule[]{new QueryRule("Id", QueryRule.Operator.EQUALS, datasetIdentifier)}).get(0);
        String dataSetName = dataSet.getName();
        try {
            this.deleteData(dataSet);
            if (deletemetadata) {
                List allProtocols = this.database.find(Protocol.class, new QueryRule[0]);
                Protocol protocolUsed = dataSet.getProtocolUsed();
                this.database.remove((Entity)dataSet);
                this.deleteProtocol(protocolUsed, allProtocols);
            }
            this.searchService.deleteDocumentsByType(dataSet.getIdentifier());
            this.database.commitTx();
        }
        catch (DatabaseException e) {
            this.database.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.database.rollbackTx();
            throw new IOException(e);
        }
        return dataSetName;
    }

    protected void deleteData(DataSet dataset) throws DatabaseException {
        List observationSets = this.database.find(ObservationSet.class, new QueryRule[]{new QueryRule("partOfDataSet", QueryRule.Operator.EQUALS, dataset.getIdValue())});
        ArrayList observedValues = new ArrayList();
        for (ObservationSet observationSet : observationSets) {
            observedValues.addAll(this.database.find(ObservedValue.class, new QueryRule[]{new QueryRule("ObservationSet_id", QueryRule.Operator.EQUALS, observationSet.getIdValue())}));
            if (this.teller % 20 == 0) {
                this.database.remove(observedValues);
                observedValues = new ArrayList();
            }
            ++this.teller;
        }
        if (observedValues.size() != 0) {
            this.database.remove(observedValues);
        }
        this.database.remove(observationSets);
    }

    protected void deleteObservedValues(ObservationSet observationSet) throws DatabaseException {
        List observedValues = this.database.find(ObservedValue.class, new QueryRule[]{new QueryRule("ObservationSet_id", QueryRule.Operator.EQUALS, observationSet.getIdValue())});
        this.database.remove(observedValues);
    }

    protected List<Protocol> deleteProtocol(Protocol protocol, List<Protocol> allProtocols) throws DatabaseException {
        boolean deleteInBatch = true;
        List subprotocols = protocol.getSubprotocols();
        for (Protocol subprotocol : subprotocols) {
            if (subprotocol.getSubprotocols().size() <= 0) continue;
            deleteInBatch = false;
        }
        for (Protocol subprotocol : subprotocols) {
            int superprotocolcount = this.countReferringProtocols((Characteristic)subprotocol, allProtocols);
            if (superprotocolcount > 1) continue;
            if (!deleteInBatch) {
                allProtocols = this.deleteProtocol(subprotocol, allProtocols);
                continue;
            }
            List features = subprotocol.getFeatures();
            this.deleteFeatures(features, allProtocols);
        }
        List features = protocol.getFeatures();
        if (deleteInBatch) {
            this.database.remove(subprotocols);
            allProtocols.removeAll(subprotocols);
        }
        this.database.remove((Entity)protocol);
        this.deleteFeatures(features, allProtocols);
        allProtocols.remove(protocol);
        return allProtocols;
    }

    protected void deleteFeatures(List<ObservableFeature> features, List<Protocol> allProtocols) throws DatabaseException {
        ArrayList<ObservableFeature> removableFeatures = new ArrayList<ObservableFeature>();
        for (ObservableFeature feature : features) {
            List categories = this.database.find(Category.class, new QueryRule[]{new QueryRule("observableFeature", QueryRule.Operator.EQUALS, feature.getIdValue())});
            this.deleteCategories(categories);
            int protocolcount = this.countReferringProtocols((Characteristic)feature, allProtocols);
            if (protocolcount > 1) continue;
            removableFeatures.add(feature);
        }
        this.database.remove(removableFeatures);
    }

    protected void deleteCategories(List<Category> categories) throws DatabaseException {
        for (Category category : categories) {
            List categoricalValues = this.database.find(CategoricalValue.class, new QueryRule[]{new QueryRule("Value", QueryRule.Operator.EQUALS, category.getIdValue())});
            for (CategoricalValue cat : categoricalValues) {
                this.database.remove((Entity)cat);
            }
            this.database.remove((Entity)category);
        }
    }

    protected int countReferringProtocols(Characteristic characteristic, List<Protocol> allProtocols) {
        int protocolcount = 0;
        Class<?> clazz = characteristic.getClass();
        for (Protocol p : allProtocols) {
            if ((!clazz.equals(ObservableFeature.class) || !p.getFeatures_Id().contains(characteristic.getId())) && (!clazz.equals(Protocol.class) || !p.getSubprotocols_Id().contains(characteristic.getId()))) continue;
            System.out.println(p.getIdentifier());
            ++protocolcount;
        }
        return protocolcount;
    }

    @ExceptionHandler(value={DatabaseAccessException.class})
    public String handleNotAuthenticated() {
        return "redirect:/";
    }
}

