/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.dataset;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.io.TableReader;
import org.molgenis.io.TableReaderFactory;
import org.molgenis.io.TupleReader;
import org.molgenis.omx.converters.ValueConverter;
import org.molgenis.omx.converters.ValueConverterException;
import org.molgenis.omx.observ.DataSet;
import org.molgenis.omx.observ.ObservableFeature;
import org.molgenis.omx.observ.ObservationSet;
import org.molgenis.omx.observ.ObservedValue;
import org.molgenis.omx.observ.value.Value;
import org.molgenis.util.Entity;
import org.molgenis.util.tuple.Tuple;

public class DataSetImporter {
    private static final Logger LOG = Logger.getLogger(DataSetImporter.class);
    private static final String DATASET_SHEET_PREFIX = "dataset_";
    private final Database db;
    private final ValueConverter valueConverter;

    public DataSetImporter(Database db) {
        if (db == null) {
            throw new IllegalArgumentException();
        }
        this.db = db;
        this.valueConverter = new ValueConverter(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importDataSet(File file, List<String> dataSetEntityNames) throws IOException, DatabaseException {
        TableReader tableReader = TableReaderFactory.create((File)file);
        try {
            for (String tableName : tableReader.getTableNames()) {
                if (!dataSetEntityNames.contains(tableName)) continue;
                LOG.info((Object)("importing dataset " + tableName + " from file " + file + "..."));
                TupleReader tupleReader = tableReader.getTupleReader(tableName);
                try {
                    this.importSheet(tupleReader, tableName);
                }
                finally {
                    tupleReader.close();
                }
            }
        }
        finally {
            tableReader.close();
        }
    }

    private void importSheet(TupleReader sheetReader, String sheetName) throws DatabaseException, IOException {
        String identifier = sheetName.substring(DATASET_SHEET_PREFIX.length());
        DataSet dataSet = DataSet.findByIdentifier((Database)this.db, (String)identifier);
        if (dataSet == null) {
            throw new DatabaseException("dataset '" + identifier + "' does not exist in db");
        }
        Iterator colIt = sheetReader.colNamesIterator();
        if (colIt == null || !colIt.hasNext()) {
            throw new IOException("sheet '" + sheetName + "' contains no header");
        }
        LinkedHashMap<String, ObservableFeature> featureMap = new LinkedHashMap<String, ObservableFeature>();
        while (colIt.hasNext()) {
            String featureIdentifier = (String)colIt.next();
            if (featureIdentifier != null && !featureIdentifier.isEmpty()) {
                ObservableFeature feature = ObservableFeature.findByIdentifier((Database)this.db, (String)featureIdentifier);
                if (feature == null) {
                    throw new DatabaseException(ObservableFeature.class.getSimpleName() + " with identifier '" + featureIdentifier + "' does not exist. This is probably due to the fact that the feature is in the dataset_" + identifier + " but is not annotated in the observablefeature entity");
                }
                featureMap.put(featureIdentifier, feature);
                continue;
            }
            throw new DatabaseException("sheet '" + sheetName + "' contains empty column header");
        }
        if (featureMap.isEmpty()) {
            throw new DatabaseException("sheet '" + sheetName + "' contains no header");
        }
        int rownr = 0;
        int transactionRows = Math.max(1, 5000 / featureMap.size());
        this.db.beginTx();
        for (Tuple row : sheetReader) {
            if (!row.isEmpty()) {
                ArrayList<ObservedValue> obsValueList = new ArrayList<ObservedValue>();
                HashMap valueMap = new HashMap();
                ObservationSet observationSet = new ObservationSet();
                observationSet.setPartOfDataSet(dataSet);
                this.db.add((Entity)observationSet);
                for (Map.Entry entry : featureMap.entrySet()) {
                    try {
                        Value value = this.valueConverter.fromTuple(row, (String)entry.getKey(), (ObservableFeature)entry.getValue());
                        if (value == null) continue;
                        ObservedValue observedValue = new ObservedValue();
                        observedValue.setFeature((ObservableFeature)entry.getValue());
                        observedValue.setValue(value);
                        observedValue.setObservationSet(observationSet);
                        ArrayList<Value> valueList = (ArrayList<Value>)valueMap.get(value.getClass());
                        if (valueList == null) {
                            valueList = new ArrayList<Value>();
                            valueMap.put(value.getClass(), valueList);
                        }
                        valueList.add(value);
                        obsValueList.add(observedValue);
                    }
                    catch (ValueConverterException e) {
                        e.printStackTrace();
                    }
                }
                this.db.add(obsValueList);
                for (Map.Entry entry : valueMap.entrySet()) {
                    this.db.add((List)entry.getValue());
                }
            }
            if (++rownr % transactionRows != 0) continue;
            this.db.getEntityManager().flush();
            this.db.getEntityManager().clear();
        }
        if (rownr % transactionRows != 0) {
            this.db.getEntityManager().flush();
            this.db.getEntityManager().clear();
        }
        this.db.commitTx();
    }
}

