/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.plugins;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.molgenis.framework.db.EntityImportReport;
import org.molgenis.omx.plugins.ImportResultsWizardPage;
import org.molgenis.omx.plugins.UploadWizardPage;
import org.molgenis.omx.plugins.ValidationResultWizardPage;
import org.molgenis.omx.plugins.WizardPage;

public class ImportWizard {
    private List<WizardPage> pages = new ArrayList<WizardPage>();
    private int currentPageIndex = 0;
    private String errorMessage;
    private String validationMessage;
    private String successMessage;
    private File file;
    private EntityImportReport importResult;
    private Map<String, Boolean> entitiesImportable;
    private Map<String, Boolean> dataImportable;
    private Map<String, Collection<String>> fieldsDetected;
    private Map<String, Collection<String>> fieldsUnknown;
    private Map<String, Collection<String>> fieldsRequired;
    private Map<String, Collection<String>> fieldsAvailable;
    private String entityImportOption;

    public ImportWizard() {
        this.addPage(new UploadWizardPage());
        this.addPage(new ValidationResultWizardPage());
        this.addPage(new ImportResultsWizardPage());
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getValidationMessage() {
        return this.validationMessage;
    }

    public void setValidationMessage(String validationMessage) {
        this.validationMessage = validationMessage;
    }

    public String getSuccessMessage() {
        return this.successMessage;
    }

    public void setSuccessMessage(String successMessage) {
        this.successMessage = successMessage;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public EntityImportReport getImportResult() {
        return this.importResult;
    }

    public void setImportResult(EntityImportReport importResult) {
        this.importResult = importResult;
    }

    public void addPage(WizardPage page) {
        page.setWizard(this);
        this.pages.add(page);
    }

    public WizardPage getCurrentPage() {
        return this.pages.get(this.currentPageIndex);
    }

    public int getCurrentPageIndex() {
        return this.currentPageIndex;
    }

    public List<WizardPage> getPages() {
        return Collections.unmodifiableList(this.pages);
    }

    public boolean isLastPage() {
        return this.getCurrentPageIndex() == this.getPages().size() - 1;
    }

    public boolean isFirstPage() {
        return this.getCurrentPageIndex() == 0;
    }

    public void next() {
        if (this.currentPageIndex < this.pages.size() - 1) {
            ++this.currentPageIndex;
        }
    }

    public void previous() {
        if (this.currentPageIndex > 0) {
            --this.currentPageIndex;
        }
    }

    public Map<String, Boolean> getEntitiesImportable() {
        return this.entitiesImportable;
    }

    public void setEntitiesImportable(Map<String, Boolean> entitiesImportable) {
        this.entitiesImportable = entitiesImportable;
    }

    public Map<String, Boolean> getDataImportable() {
        return this.dataImportable;
    }

    public void setDataImportable(Map<String, Boolean> dataImportable) {
        this.dataImportable = dataImportable;
    }

    public Map<String, Collection<String>> getFieldsDetected() {
        return this.fieldsDetected;
    }

    public void setFieldsDetected(Map<String, Collection<String>> fieldsDetected) {
        this.fieldsDetected = fieldsDetected;
    }

    public Map<String, Collection<String>> getFieldsUnknown() {
        return this.fieldsUnknown;
    }

    public void setFieldsUnknown(Map<String, Collection<String>> fieldsUnknown) {
        this.fieldsUnknown = fieldsUnknown;
    }

    public Map<String, Collection<String>> getFieldsRequired() {
        return this.fieldsRequired;
    }

    public void setFieldsRequired(Map<String, Collection<String>> fieldsRequired) {
        this.fieldsRequired = fieldsRequired;
    }

    public Map<String, Collection<String>> getFieldsAvailable() {
        return this.fieldsAvailable;
    }

    public void setFieldsAvailable(Map<String, Collection<String>> fieldsAvailable) {
        this.fieldsAvailable = fieldsAvailable;
    }

    public void setCurrentPageIndex(int currentPageIndex) {
        this.currentPageIndex = currentPageIndex;
    }

    public void setPages(List<WizardPage> pages) {
        this.pages = pages;
    }

    public String getEntityImportOption() {
        return this.entityImportOption;
    }

    public void setEntityImportOption(String entityImportOption) {
        this.entityImportOption = entityImportOption;
    }
}

