/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.plugins;

import org.molgenis.framework.db.Database;
import org.molgenis.framework.server.MolgenisRequest;
import org.molgenis.framework.ui.PluginModel;
import org.molgenis.framework.ui.ScreenController;
import org.molgenis.omx.plugins.ImportWizard;
import org.molgenis.util.Entity;

public class ImportWizardController
extends PluginModel<Entity> {
    private static final long serialVersionUID = 6673296137881226020L;
    private transient ImportWizard importWizard = new ImportWizard();

    public ImportWizardController(String name, ScreenController<?> parent) {
        super(name, parent);
    }

    public ImportWizard getWizard() {
        return this.importWizard;
    }

    public String getViewName() {
        return ImportWizard.class.getSimpleName();
    }

    public String getViewTemplate() {
        return "templates/" + ImportWizard.class.getName().replace('.', '/') + ".ftl";
    }

    public String getCustomHtmlHeaders() {
        StringBuilder s = new StringBuilder();
        s.append("<link rel=\"stylesheet\" href=\"css/bwizard.min.css\" type=\"text/css\" />");
        s.append("<link rel=\"stylesheet\" href=\"css/importer.css\" type=\"text/css\" />");
        s.append("<script type=\"text/javascript\" src=\"js/bwizard.min.js\"></script>");
        return s.toString();
    }

    public void handleRequest(Database db, MolgenisRequest request) {
        String action = request.getString("__action");
        if (action == null) {
            return;
        }
        this.importWizard.setErrorMessage(null);
        this.importWizard.setValidationMessage(null);
        this.importWizard.setSuccessMessage(null);
        if (action.equals("next")) {
            this.importWizard.getCurrentPage().handleRequest(db, request);
            if (this.importWizard.getErrorMessage() == null) {
                this.importWizard.next();
            }
        } else if (action.equals("previous")) {
            this.importWizard.previous();
        } else if (action.equals("finish") || action.equals("cancel")) {
            this.importWizard = new ImportWizard();
        }
    }

    public void reload(Database db) {
    }
}

