/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.plugins;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.EntitiesValidationReport;
import org.molgenis.framework.server.MolgenisRequest;
import org.molgenis.io.TableReader;
import org.molgenis.io.TableReaderFactory;
import org.molgenis.io.TupleReader;
import org.molgenis.io.processor.CellProcessor;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.omx.observ.DataSet;
import org.molgenis.omx.plugins.ImportWizard;
import org.molgenis.omx.plugins.WizardPage;
import org.molgenis.util.ApplicationUtil;
import org.molgenis.util.tuple.Tuple;

public class UploadWizardPage
extends WizardPage {
    private static final String DATASET_PREFIX = DataSet.class.getSimpleName().toLowerCase();

    public UploadWizardPage() {
        super("Upload file");
    }

    @Override
    public void handleRequest(Database db, MolgenisRequest request) {
        String entityImportOption = request.getString("entity_option");
        ImportWizard importWizard = this.getWizard();
        importWizard.setEntityImportOption(entityImportOption);
        File file = request.getFile("upload");
        if (file == null) {
            this.getWizard().setErrorMessage("No file selected");
        } else {
            try {
                this.validateInput(db, file);
            }
            catch (Exception e) {
                this.getWizard().setErrorMessage("Error validating import file: " + e.getMessage());
                this.logger.error((Object)"Exception validating import file", (Throwable)e);
            }
        }
    }

    private void validateInput(Database db, File file) throws Exception {
        EntitiesValidationReport validationReport = ApplicationUtil.getEntitiesValidator().validate(file);
        Map entitiesImportable = validationReport.getSheetsImportable();
        if (entitiesImportable != null) {
            Iterator it = entitiesImportable.entrySet().iterator();
            while (it.hasNext()) {
                if (!((String)it.next().getKey()).toLowerCase().startsWith("dataset_")) continue;
                it.remove();
            }
        }
        Map<String, Boolean> dataSetsImportable = this.validateDataSetInstances(db, file);
        boolean ok = true;
        if (entitiesImportable != null) {
            for (Boolean b : entitiesImportable.values()) {
                ok &= b.booleanValue();
            }
            for (Collection fields : validationReport.getFieldsRequired().values()) {
                ok &= fields == null || fields.isEmpty();
            }
        }
        if (dataSetsImportable != null) {
            for (Boolean b : dataSetsImportable.values()) {
                ok &= b.booleanValue();
            }
        }
        if (ok) {
            this.getWizard().setFile(file);
            this.getWizard().setSuccessMessage("File is validated and can be imported.");
        } else {
            this.getWizard().setValidationMessage("File did not pass validation see results below. Please resolve the errors and try again.");
        }
        this.getWizard().setEntitiesImportable(entitiesImportable);
        this.getWizard().setDataImportable(dataSetsImportable);
        this.getWizard().setFieldsDetected(validationReport.getFieldsImportable());
        this.getWizard().setFieldsRequired(validationReport.getFieldsRequired());
        this.getWizard().setFieldsAvailable(validationReport.getFieldsAvailable());
        this.getWizard().setFieldsUnknown(validationReport.getFieldsUnknown());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Boolean> validateDataSetInstances(Database db, File file) throws IOException, DatabaseException {
        TableReader tableReader = TableReaderFactory.create((File)file);
        try {
            TupleReader dataSetReader = tableReader.getTupleReader(DATASET_PREFIX);
            HashSet<String> datasetIdentifiers = new HashSet<String>();
            if (dataSetReader != null) {
                try {
                    dataSetReader.addCellProcessor((CellProcessor)new LowerCaseProcessor(true, false));
                    for (Tuple tuple : dataSetReader) {
                        String identifier = tuple.getString("Identifier".toLowerCase());
                        if (identifier == null) continue;
                        datasetIdentifiers.add(identifier);
                    }
                }
                finally {
                    dataSetReader.close();
                }
            }
            LinkedHashMap<String, Boolean> dataSetValidationMap = new LinkedHashMap<String, Boolean>();
            for (String tableName : tableReader.getTableNames()) {
                if (!tableName.toLowerCase().startsWith(DATASET_PREFIX + "_")) continue;
                String identifier = tableName.substring((DATASET_PREFIX + "_").length());
                boolean canImport = datasetIdentifiers.contains(identifier) || DataSet.findByIdentifier((Database)db, (String)identifier) != null;
                dataSetValidationMap.put(identifier, canImport);
            }
            LinkedHashMap<String, Boolean> linkedHashMap = dataSetValidationMap;
            return linkedHashMap;
        }
        finally {
            tableReader.close();
        }
    }
}

