/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.plugins;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.EntityImportReport;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.server.MolgenisRequest;
import org.molgenis.omx.dataset.DataSetImporter;
import org.molgenis.omx.observ.DataSet;
import org.molgenis.omx.plugins.ImportWizard;
import org.molgenis.omx.plugins.WizardPage;
import org.molgenis.util.ApplicationContextProvider;
import org.molgenis.util.ApplicationUtil;
import org.molgenis.util.DataSetImportedEvent;
import org.springframework.context.ApplicationEvent;

public class ValidationResultWizardPage
extends WizardPage {
    public ValidationResultWizardPage() {
        super("Validation");
    }

    @Override
    public void handleRequest(Database db, MolgenisRequest request) {
        ImportWizard importWizard = this.getWizard();
        String entityImportOption = importWizard.getEntityImportOption();
        if (entityImportOption != null) {
            this.doImport(db, entityImportOption);
        }
    }

    private void doImport(Database db, String entityAction) {
        ImportWizard importWizard = this.getWizard();
        File file = importWizard.getFile();
        try {
            db.beginTx();
            Database.DatabaseAction entityDbAction = this.toDatabaseAction(entityAction);
            if (entityDbAction == null) {
                throw new IOException("unknown database action: " + entityAction);
            }
            EntityImportReport importReport = ApplicationUtil.getEntitiesImporter().importEntities(file, entityDbAction);
            importWizard.setImportResult(importReport);
            if (importWizard.getDataImportable() != null) {
                ArrayList<String> dataSetSheetNames = new ArrayList<String>();
                for (Map.Entry<String, Boolean> entry : importWizard.getDataImportable().entrySet()) {
                    if (!entry.getValue().booleanValue()) continue;
                    dataSetSheetNames.add("dataset_" + entry.getKey());
                }
                new DataSetImporter(db).importDataSet(file, dataSetSheetNames);
            }
            importWizard.setSuccessMessage("File successfully imported.");
            db.commitTx();
        }
        catch (Exception e) {
            try {
                db.rollbackTx();
            }
            catch (DatabaseException e1) {
                this.logger.error((Object)"Exception rolling back transaction", (Throwable)e1);
            }
            this.logger.warn((Object)("Import of file [" + file.getName() + "] failed for action [" + entityAction + "]"), (Throwable)e);
            importWizard.setValidationMessage("<b>Your import failed:</b><br />" + e.getMessage());
        }
        try {
            for (DataSet dataSet : db.find(DataSet.class, new QueryRule[0])) {
                ApplicationContextProvider.getApplicationContext().publishEvent((ApplicationEvent)new DataSetImportedEvent((Object)this, dataSet.getId()));
            }
        }
        catch (DatabaseException e) {
            this.logger.error((Object)("Error publishing " + DataSet.class.getSimpleName() + " imported event(s)"));
        }
    }

    private Database.DatabaseAction toDatabaseAction(String actionStr) {
        Object dbAction = actionStr.equals("add") ? Database.DatabaseAction.ADD : (actionStr.equals("add_ignore") ? Database.DatabaseAction.ADD_IGNORE_EXISTING : (actionStr.equals("add_update") ? Database.DatabaseAction.ADD_UPDATE_EXISTING : (actionStr.equals("update") ? Database.DatabaseAction.UPDATE : (actionStr.equals("update_ignore") ? Database.DatabaseAction.UPDATE_IGNORE_MISSING : null))));
        return dbAction;
    }
}

