/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.importer;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.CrudRepository;
import org.molgenis.data.CrudRepositorySecurityDecorator;
import org.molgenis.data.DataService;
import org.molgenis.data.DatabaseAction;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.Repository;
import org.molgenis.data.RepositoryCollection;
import org.molgenis.data.omx.OmxLookupTableRepository;
import org.molgenis.data.omx.OmxRepository;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.data.support.QueryResolver;
import org.molgenis.data.validation.ConstraintViolation;
import org.molgenis.data.validation.EntityValidator;
import org.molgenis.data.validation.MolgenisValidationException;
import org.molgenis.fieldtypes.FieldType;
import org.molgenis.framework.db.EntitiesImporter;
import org.molgenis.framework.db.EntityImportReport;
import org.molgenis.omx.importer.OmxImporterService;
import org.molgenis.omx.observ.DataSet;
import org.molgenis.omx.observ.ObservableFeature;
import org.molgenis.omx.observ.Protocol;
import org.molgenis.omx.utils.ProtocolUtils;
import org.molgenis.search.SearchService;
import org.molgenis.util.RepositoryUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OmxImporterServiceImpl
implements OmxImporterService {
    private final DataService dataService;
    private final SearchService searchService;
    private final EntitiesImporter entitiesImporter;
    private final EntityValidator entityValidator;
    private final QueryResolver queryResolver;

    @Autowired
    public OmxImporterServiceImpl(DataService dataService, SearchService searchService, EntitiesImporter entitiesImporter, EntityValidator entityValidator, QueryResolver queryResolver) {
        this.dataService = dataService;
        this.searchService = searchService;
        this.entitiesImporter = entitiesImporter;
        this.entityValidator = entityValidator;
        this.queryResolver = queryResolver;
    }

    @Override
    @Transactional(rollbackFor={IOException.class})
    public EntityImportReport doImport(RepositoryCollection repositories, DatabaseAction databaseAction) throws IOException {
        EntityImportReport importReport = this.entitiesImporter.importEntities(repositories, databaseAction);
        this.checkFeatureCanOnlyBelongToOneProtocolForOneDataSet();
        for (String name : repositories.getEntityNames()) {
            Repository repository = repositories.getRepositoryByEntityName(name);
            if (!repository.getName().startsWith("dataset_")) continue;
            String identifier = repository.getName().substring("dataset_".length());
            if (!this.dataService.hasRepository(identifier)) {
                this.dataService.addRepository((Repository)new CrudRepositorySecurityDecorator((CrudRepository)new OmxRepository(this.dataService, this.searchService, identifier, this.entityValidator)));
                DataSet dataSet = (DataSet)this.dataService.findOne("DataSet", new QueryImpl().eq("Identifier", (Object)identifier), DataSet.class);
                List protocols = ProtocolUtils.getProtocolDescendants((Protocol)dataSet.getProtocolUsed());
                ArrayList<ObservableFeature> categoricalFeatures = new ArrayList<ObservableFeature>();
                for (Protocol protocol : protocols) {
                    List observableFeatures = protocol.getFeatures();
                    if (observableFeatures == null) continue;
                    for (ObservableFeature observableFeature : observableFeatures) {
                        String dataType = observableFeature.getDataType();
                        FieldType type = MolgenisFieldTypes.getType((String)dataType);
                        if (type.getEnumType() != MolgenisFieldTypes.FieldTypeEnum.CATEGORICAL) continue;
                        categoricalFeatures.add(observableFeature);
                    }
                }
                for (ObservableFeature categoricalFeature : categoricalFeatures) {
                    if (this.dataService.hasRepository(categoricalFeature.getIdentifier() + "-LUT")) continue;
                    this.dataService.addRepository((Repository)new OmxLookupTableRepository(this.dataService, categoricalFeature.getIdentifier(), this.queryResolver));
                }
            }
            LinkedHashSet violations = Sets.newLinkedHashSet();
            EntityMetaData meta = this.dataService.getEntityMetaData(identifier);
            for (AttributeMetaData attr : repository.getEntityMetaData().getAttributes()) {
                if (meta.getAttribute(attr.getName()) != null) continue;
                String message = String.format("Unknown attributename '%s' for entity '%s'. Sheet: '%s'", attr.getName(), meta.getName(), repository.getName());
                violations.add(new ConstraintViolation(message, (Object)attr.getName(), null, null, meta, 0L));
            }
            if (!violations.isEmpty()) {
                throw new MolgenisValidationException((Set)violations);
            }
            try {
                this.dataService.add(identifier, (Iterable)repository);
            }
            catch (MolgenisValidationException e) {
                for (ConstraintViolation violation : e.getViolations()) {
                    if (violation.getRownr() > 0L) {
                        violation.setImportInfo(String.format("Sheet: '%s', row: %d", repository.getName(), violation.getRownr() + 1L));
                        continue;
                    }
                    violation.setImportInfo(String.format("Sheet: '%s'", repository.getName()));
                }
                throw e;
            }
            int count = (int)RepositoryUtils.count((Repository)repository);
            importReport.addEntityCount(identifier, count);
            importReport.addNrImported(count);
        }
        return importReport;
    }

    private void checkFeatureCanOnlyBelongToOneProtocolForOneDataSet() {
        Iterable dataSets = this.dataService.findAll("DataSet", DataSet.class);
        for (DataSet dataSet : dataSets) {
            List dataSetProtocols = ProtocolUtils.getProtocolDescendants((Protocol)dataSet.getProtocolUsed(), (boolean)true);
            for (Protocol protocol : dataSetProtocols) {
                for (ObservableFeature feature : protocol.getFeatures()) {
                    for (Protocol p : dataSetProtocols) {
                        if (p.equals((Object)protocol) || !p.getFeatures().contains(feature)) continue;
                        String message = String.format("An ObservableFeature can only belong to one Protocol but feature '%s' belongs to both '%s' and '%s'", feature.getIdentifier(), p.getIdentifier(), protocol.getIdentifier());
                        throw new MolgenisValidationException((Set)Sets.newHashSet((Object[])new ConstraintViolation[]{new ConstraintViolation(message, (Object)feature.getIdentifier(), (Entity)feature, null, null, 0L)}));
                    }
                }
            }
        }
    }
}

