/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.importer;

import java.io.File;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.molgenis.data.DataService;
import org.molgenis.data.DatabaseAction;
import org.molgenis.data.FileRepositoryCollectionFactory;
import org.molgenis.data.RepositoryCollection;
import org.molgenis.data.support.FileRepositoryCollection;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.data.validation.ConstraintViolation;
import org.molgenis.data.validation.MolgenisValidationException;
import org.molgenis.framework.db.EntityImportReport;
import org.molgenis.omx.converters.ValueConverterException;
import org.molgenis.omx.importer.ImportWizard;
import org.molgenis.omx.importer.OmxImporterService;
import org.molgenis.omx.observ.DataSet;
import org.molgenis.omx.observ.Protocol;
import org.molgenis.ui.wizard.AbstractWizardPage;
import org.molgenis.ui.wizard.Wizard;
import org.molgenis.util.ApplicationContextProvider;
import org.molgenis.util.EntityImportedEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;

@Component
public class ValidationResultWizardPage
extends AbstractWizardPage {
    private static final Logger logger = Logger.getLogger(ValidationResultWizardPage.class);
    private static final long serialVersionUID = 1L;
    @Autowired
    private OmxImporterService omxImporterService;
    @Autowired
    private DataService dataService;
    @Autowired
    private FileRepositoryCollectionFactory fileRepositoryCollectionFactory;

    public String getTitle() {
        return "Validation";
    }

    public String handleRequest(HttpServletRequest request, BindingResult result, Wizard wizard) {
        if (!(wizard instanceof ImportWizard)) {
            throw new RuntimeException("Wizard must be of type '" + ImportWizard.class.getSimpleName() + "' instead of '" + wizard.getClass().getSimpleName() + "'");
        }
        ImportWizard importWizard = (ImportWizard)wizard;
        String entityImportOption = importWizard.getEntityImportOption();
        if (entityImportOption != null) {
            try {
                DatabaseAction entityDbAction = this.toDatabaseAction(entityImportOption);
                if (entityDbAction == null) {
                    throw new IOException("unknown database action: " + entityImportOption);
                }
                FileRepositoryCollection repositoryCollection = this.fileRepositoryCollectionFactory.createFileRepositoryCollection(importWizard.getFile());
                EntityImportReport importReport = this.omxImporterService.doImport((RepositoryCollection)repositoryCollection, entityDbAction);
                importWizard.setImportResult(importReport);
                Iterable dataSets = this.dataService.findAll("DataSet", DataSet.class);
                for (DataSet dataSet : dataSets) {
                    ApplicationContextProvider.getApplicationContext().publishEvent((ApplicationEvent)new EntityImportedEvent((Object)this, "DataSet", dataSet.getId()));
                }
                Iterable protocols = this.dataService.findAll("Protocol", new QueryImpl().eq("root", (Object)true), Protocol.class);
                for (Protocol protocol : protocols) {
                    ApplicationContextProvider.getApplicationContext().publishEvent((ApplicationEvent)new EntityImportedEvent((Object)this, "Protocol", protocol.getId()));
                }
                return "File successfully imported.";
            }
            catch (MolgenisValidationException e) {
                File file = importWizard.getFile();
                logger.warn((Object)("Import of file [" + file.getName() + "] failed for action [" + entityImportOption + "]"), (Throwable)e);
                StringBuilder sb = new StringBuilder("<b>Your import failed:</b><br /><br />");
                for (ConstraintViolation violation : e.getViolations()) {
                    sb.append(violation.getMessage());
                    if (violation.getImportInfo() != null) {
                        sb.append(" ").append(violation.getImportInfo());
                    }
                    sb.append("<br />");
                }
                result.addError(new ObjectError("wizard", sb.toString()));
            }
            catch (RuntimeException e) {
                File file = importWizard.getFile();
                logger.warn((Object)("Import of file [" + file.getName() + "] failed for action [" + entityImportOption + "]"), (Throwable)e);
                result.addError(new ObjectError("wizard", "<b>Your import failed:</b><br />" + e.getMessage()));
            }
            catch (IOException e) {
                File file = importWizard.getFile();
                logger.warn((Object)("Import of file [" + file.getName() + "] failed for action [" + entityImportOption + "]"), (Throwable)e);
                result.addError(new ObjectError("wizard", "<b>Your import failed:</b><br />" + e.getMessage()));
            }
            catch (ValueConverterException e) {
                File file = importWizard.getFile();
                logger.warn((Object)("Import of file [" + file.getName() + "] failed for action [" + entityImportOption + "]"), (Throwable)e);
                result.addError(new ObjectError("wizard", "<b>Your import failed:</b><br />" + e.getMessage()));
            }
        }
        return null;
    }

    private DatabaseAction toDatabaseAction(String actionStr) {
        Object dbAction = actionStr.equals("add") ? DatabaseAction.ADD : (actionStr.equals("add_ignore") ? DatabaseAction.ADD_IGNORE_EXISTING : (actionStr.equals("add_update") ? DatabaseAction.ADD_UPDATE_EXISTING : (actionStr.equals("update") ? DatabaseAction.UPDATE : (actionStr.equals("update_ignore") ? DatabaseAction.UPDATE_IGNORE_MISSING : null))));
        return dbAction;
    }
}

