/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.importer;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.apache.log4j.Logger;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.FileRepositoryCollectionFactory;
import org.molgenis.data.Repository;
import org.molgenis.data.RepositoryCollection;
import org.molgenis.data.importer.EmxImportServiceImpl;
import org.molgenis.data.support.FileRepositoryCollection;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.framework.db.EntitiesValidationReport;
import org.molgenis.framework.db.EntitiesValidator;
import org.molgenis.omx.importer.ImportWizard;
import org.molgenis.omx.observ.DataSet;
import org.molgenis.ui.wizard.AbstractWizardPage;
import org.molgenis.ui.wizard.Wizard;
import org.molgenis.util.FileUploadUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;

@Component
public class UploadWizardPage
extends AbstractWizardPage {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(UploadWizardPage.class);
    private static final String DATASET_PREFIX = DataSet.class.getSimpleName().toLowerCase();
    private final transient DataService dataService;
    private final transient EntitiesValidator entitiesValidator;
    private final transient FileRepositoryCollectionFactory fileRepositoryCollectionFactory;

    @Autowired
    public UploadWizardPage(DataService dataService, EntitiesValidator entitiesValidator, FileRepositoryCollectionFactory fileRepositoryCollectionFactory) {
        this.dataService = dataService;
        this.entitiesValidator = entitiesValidator;
        this.fileRepositoryCollectionFactory = fileRepositoryCollectionFactory;
        if (dataService == null) {
            throw new IllegalArgumentException("DataService is null");
        }
        if (entitiesValidator == null) {
            throw new IllegalArgumentException("EntitiesValidator is null");
        }
        if (fileRepositoryCollectionFactory == null) {
            throw new IllegalArgumentException("FileRepositoryCollectionFactory is null");
        }
    }

    public String getTitle() {
        return "Upload file";
    }

    public String handleRequest(HttpServletRequest request, BindingResult result, Wizard wizard) {
        if (!(wizard instanceof ImportWizard)) {
            throw new RuntimeException("Wizard must be of type '" + ImportWizard.class.getSimpleName() + "' instead of '" + wizard.getClass().getSimpleName() + "'");
        }
        ImportWizard importWizard = (ImportWizard)wizard;
        String entityImportOption = request.getParameter("entity_option");
        importWizard.setEntityImportOption(entityImportOption);
        try {
            File file = null;
            Part part = request.getPart("upload");
            if (part != null) {
                file = FileUploadUtils.saveToTempFolder((Part)part);
            }
            if (file != null) {
                return this.validateInput(file, importWizard, result);
            }
            result.addError(new ObjectError("wizard", "No file selected"));
        }
        catch (Exception e) {
            result.addError(new ObjectError("wizard", "Error validating import file: " + e.getMessage()));
            logger.error((Object)"Exception validating import file", (Throwable)e);
        }
        return null;
    }

    private String validateInput(File file, ImportWizard wizard, BindingResult result) throws Exception {
        FileRepositoryCollection source = this.fileRepositoryCollectionFactory.createFileRepositoryCollection(file);
        if (source.getRepositoryByEntityName("attributes") != null) {
            EmxImportServiceImpl importer = new EmxImportServiceImpl();
            EntitiesValidationReport validationReport = importer.validateImport((RepositoryCollection)source);
            wizard.setEntitiesImportable(validationReport.getSheetsImportable());
            wizard.setFieldsDetected(validationReport.getFieldsImportable());
            wizard.setFieldsRequired(validationReport.getFieldsRequired());
            wizard.setFieldsAvailable(validationReport.getFieldsAvailable());
            wizard.setFieldsUnknown(validationReport.getFieldsUnknown());
            String msg = null;
            if (validationReport.valid()) {
                wizard.setFile(file);
                msg = "File is validated and can be imported.";
            } else {
                wizard.setValidationMessage("File did not pass validation see results below. Please resolve the errors and try again.");
            }
            return msg;
        }
        EntitiesValidationReport validationReport = this.entitiesValidator.validate(file);
        Map entitiesImportable = validationReport.getSheetsImportable();
        if (entitiesImportable != null) {
            Iterator it = entitiesImportable.entrySet().iterator();
            while (it.hasNext()) {
                if (!((String)it.next().getKey()).toLowerCase().startsWith("dataset_")) continue;
                it.remove();
            }
        }
        Map<String, Boolean> dataSetsImportable = this.validateDataSetInstances(this.fileRepositoryCollectionFactory, file);
        boolean ok = true;
        if (entitiesImportable != null) {
            for (Boolean b : entitiesImportable.values()) {
                ok &= b.booleanValue();
            }
            for (Collection fields : validationReport.getFieldsRequired().values()) {
                ok &= fields == null || fields.isEmpty();
            }
        }
        if (dataSetsImportable != null) {
            for (Boolean b : dataSetsImportable.values()) {
                ok &= b.booleanValue();
            }
        }
        String msg = null;
        if (ok) {
            wizard.setFile(file);
            msg = "File is validated and can be imported.";
        } else {
            wizard.setValidationMessage("File did not pass validation see results below. Please resolve the errors and try again.");
        }
        wizard.setEntitiesImportable(entitiesImportable);
        wizard.setDataImportable(dataSetsImportable);
        wizard.setFieldsDetected(validationReport.getFieldsImportable());
        wizard.setFieldsRequired(validationReport.getFieldsRequired());
        wizard.setFieldsAvailable(validationReport.getFieldsAvailable());
        wizard.setFieldsUnknown(validationReport.getFieldsUnknown());
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Boolean> validateDataSetInstances(FileRepositoryCollectionFactory fileRepositoryCollectionFactory, File file) throws IOException {
        FileRepositoryCollection repositoryCollection = fileRepositoryCollectionFactory.createFileRepositoryCollection(file);
        HashSet<String> datasetIdentifiers = new HashSet<String>();
        try (Repository repo = null;){
            repo = repositoryCollection.getRepositoryByEntityName(DATASET_PREFIX);
            if (repo != null) {
                for (Entity entity : repo) {
                    String identifier = entity.getString("Identifier".toLowerCase());
                    if (identifier == null) continue;
                    datasetIdentifiers.add(identifier);
                }
            }
        }
        LinkedHashMap<String, Boolean> dataSetValidationMap = new LinkedHashMap<String, Boolean>();
        for (String name : repositoryCollection.getEntityNames()) {
            Repository repository = repositoryCollection.getRepositoryByEntityName(name);
            if (!repository.getName().toLowerCase().startsWith(DATASET_PREFIX + "_")) continue;
            String identifier = repository.getName().substring((DATASET_PREFIX + "_").length());
            boolean canImport = datasetIdentifiers.contains(identifier) || this.dataService.findOne("DataSet", new QueryImpl().eq("Identifier", (Object)identifier)) != null;
            dataSetValidationMap.put(identifier, canImport);
        }
        return dataSetValidationMap;
    }
}

