/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.mobile.login;

import org.molgenis.framework.db.Database;
import org.molgenis.framework.security.Login;
import org.molgenis.omx.mobile.login.LoginRequest;
import org.molgenis.omx.mobile.login.LoginResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/mobile"})
public class LoginController {
    private final Database database;

    @Autowired
    public LoginController(Database database) {
        if (database == null) {
            throw new IllegalArgumentException("Database is null");
        }
        this.database = database;
    }

    @RequestMapping(value={"/login"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<LoginResponse> login(@RequestBody LoginRequest request) throws Exception {
        String errorMessage = null;
        boolean success = this.database.getLogin().login(this.database, request.getUsername(), request.getPassword());
        System.out.println("LOGIN:" + success);
        if (!success) {
            errorMessage = "Invalid password or username";
        }
        return new ResponseEntity((Object)new LoginResponse(errorMessage), HttpStatus.OK);
    }

    @RequestMapping(value={"/authenticated"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Boolean> isUserAuthenticated() {
        Login login = this.database.getLogin();
        boolean loggedIn = login != null && login.isAuthenticated();
        return new ResponseEntity((Object)loggedIn, HttpStatus.OK);
    }

    @RequestMapping(value={"/logout"}, method={RequestMethod.GET})
    @ResponseBody
    public void logout() throws Exception {
        this.database.getLogin().logout(this.database);
        this.database.getLogin().reload(this.database);
    }
}

