/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology.matching;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.data.csv.CsvRepository;
import org.molgenis.data.support.AbstractRepository;
import org.molgenis.data.support.DefaultAttributeMetaData;
import org.molgenis.data.support.DefaultEntityMetaData;
import org.molgenis.data.support.MapEntity;

public class AdaptedCsvRepository
extends AbstractRepository {
    private final CsvRepository csvRepository;
    private final String entityName;
    public static final String ALLOWED_IDENTIFIER = "Identifier";

    public AdaptedCsvRepository(String entityName, CsvRepository csvRepository) {
        this.csvRepository = csvRepository;
        this.entityName = entityName;
    }

    public EntityMetaData getEntityMetaData() {
        DefaultEntityMetaData defaultEntityMetaData = new DefaultEntityMetaData(this.entityName);
        for (AttributeMetaData attributeMetaData : this.csvRepository.getEntityMetaData().getAttributes()) {
            if (ALLOWED_IDENTIFIER.equalsIgnoreCase(attributeMetaData.getName())) continue;
            defaultEntityMetaData.addAttributeMetaData(attributeMetaData);
        }
        DefaultAttributeMetaData idAttribute = new DefaultAttributeMetaData(ALLOWED_IDENTIFIER);
        idAttribute.setIdAttribute(true);
        idAttribute.setNillable(false);
        defaultEntityMetaData.addAttributeMetaData((AttributeMetaData)idAttribute);
        return defaultEntityMetaData;
    }

    public Iterator<Entity> iterator() {
        final AtomicInteger count = new AtomicInteger(0);
        final Iterator iterator = this.csvRepository.iterator();
        return new Iterator<Entity>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Entity next() {
                Entity entity = (Entity)iterator.next();
                if (entity.get(AdaptedCsvRepository.ALLOWED_IDENTIFIER) == null) {
                    MapEntity mapEntity = new MapEntity();
                    mapEntity.set(AdaptedCsvRepository.ALLOWED_IDENTIFIER, (Object)count.incrementAndGet());
                    for (String attributeName : entity.getAttributeNames()) {
                        mapEntity.set(attributeName, entity.get(attributeName));
                    }
                    return mapEntity;
                }
                return entity;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void close() throws IOException {
        this.csvRepository.close();
    }

    public String getName() {
        return this.entityName;
    }

    public Set<RepositoryCapability> getCapabilities() {
        return Collections.emptySet();
    }
}

