/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology.beans;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import java.util.HashSet;
import java.util.Set;
import org.molgenis.data.Entity;
import org.molgenis.ontology.beans.Ontology;
import org.molgenis.ontology.beans.OntologyImpl;
import org.molgenis.ontology.beans.OntologyTerm;

public class OntologyTermImpl
implements OntologyTerm {
    private final String iri;
    private final String label;
    private final String description;
    private final String termAccession;
    private final Ontology ontology;
    private final Set<String> synonyms;

    public OntologyTermImpl(String iri, String label, String description, String termAccession, Ontology ontology) {
        this.iri = iri;
        this.label = label;
        this.description = description;
        this.termAccession = termAccession;
        this.ontology = ontology;
        this.synonyms = new HashSet<String>();
    }

    public OntologyTermImpl(Entity ontologyTermEntity) {
        this.iri = ontologyTermEntity.getString("ontologyTermIRI");
        this.label = ontologyTermEntity.getString("ontologyTermName");
        this.ontology = new OntologyImpl(ontologyTermEntity.getEntity("ontology"));
        this.synonyms = FluentIterable.from((Iterable)ontologyTermEntity.getEntities("ontologyTermSynonym")).transform((Function)new Function<Entity, String>(){

            public String apply(Entity entity) {
                return entity.getString("ontologyTermSynonym");
            }
        }).toSet();
        this.termAccession = "";
        this.description = "";
    }

    @Override
    public String getIRI() {
        return this.iri;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Set<String> getSynonyms() {
        return this.synonyms;
    }

    @Override
    public Ontology getOntology() {
        return this.ontology;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getTermAccession() {
        return this.termAccession;
    }

    public String toString() {
        return this.label;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.iri == null ? 0 : this.iri.hashCode());
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OntologyTermImpl other = (OntologyTermImpl)obj;
        if (this.iri == null ? other.iri != null : !this.iri.equals(other.iri)) {
            return false;
        }
        return !(this.label == null ? other.label != null : !this.label.equals(other.label));
    }
}

