/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology.controller;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.MolgenisInvalidFormatException;
import org.molgenis.data.Query;
import org.molgenis.data.Repository;
import org.molgenis.data.Sort;
import org.molgenis.data.csv.CsvRepository;
import org.molgenis.data.csv.CsvWriter;
import org.molgenis.data.processor.LowerCaseProcessor;
import org.molgenis.data.processor.TrimProcessor;
import org.molgenis.data.rest.EntityCollectionResponse;
import org.molgenis.data.rest.EntityPager;
import org.molgenis.data.support.MapEntity;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.file.FileStore;
import org.molgenis.ontology.beans.OntologyServiceResult;
import org.molgenis.ontology.core.meta.OntologyTermMetaData;
import org.molgenis.ontology.matching.AdaptedCsvRepository;
import org.molgenis.ontology.matching.MatchInputTermBatchService;
import org.molgenis.ontology.matching.OntologyService;
import org.molgenis.ontology.matching.OntologyServiceImpl;
import org.molgenis.ontology.matching.UploadProgress;
import org.molgenis.ontology.request.OntologyServiceRequest;
import org.molgenis.ontology.roc.MatchQualityRocService;
import org.molgenis.ontology.utils.OntologyServiceUtil;
import org.molgenis.security.core.MolgenisPermissionService;
import org.molgenis.security.user.UserAccountService;
import org.molgenis.ui.MolgenisPluginController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/plugin/ontologyservice"})
public class OntologyServiceController
extends MolgenisPluginController {
    @Autowired
    private UserAccountService userAccountService;
    @Autowired
    private DataService dataService;
    @Autowired
    private OntologyService ontologyService;
    @Autowired
    private MatchInputTermBatchService matchInputTermBatchService;
    @Autowired
    private UploadProgress uploadProgress;
    @Autowired
    private MatchQualityRocService matchQualityRocService;
    @Autowired
    private FileStore fileStore;
    @Autowired
    private MolgenisPermissionService molgenisPermissionService;
    public static final String ID = "ontologyservice";
    public static final String URI = "/plugin/ontologyservice";
    public static final int INVALID_TOTAL_NUMBER = -1;
    private static final String ILLEGAL_PATTERN = "[^0-9a-zA-Z_]";
    private static final String ILLEGAL_PATTERN_REPLACEMENT = "_";

    public OntologyServiceController() {
        super(URI);
    }

    @RequestMapping(method={RequestMethod.GET})
    public String init(Model model) {
        String username = this.userAccountService.getCurrentUser().getUsername();
        if (this.uploadProgress.isUserExists(username)) {
            return this.matchResult(this.uploadProgress.getCurrentJob(username), model);
        }
        model.addAttribute("existingTasks", OntologyServiceUtil.getEntityAsMap(this.dataService.findAll("MatchingTask", new QueryImpl().eq("Molgenis_user", (Object)username))));
        return "ontology-match-view";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/newtask"})
    public String matchTask(Model model) {
        model.addAttribute("ontologies", OntologyServiceUtil.getEntityAsMap(this.ontologyService.getAllOntologyEntities()));
        return "ontology-match-view";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/calculate/{entityName}"})
    public String calculateRoc(@PathVariable String entityName, Model model) throws IOException, MolgenisInvalidFormatException {
        model.addAllAttributes(this.matchQualityRocService.calculateROC(entityName));
        return this.init(model);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/threshold/{entityName}"})
    public String updateThreshold(@RequestParam(value="threshold", required=true) String threshold, @PathVariable String entityName, Model model) {
        if (!StringUtils.isEmpty((CharSequence)threshold)) {
            Entity entity = this.dataService.findOne("MatchingTask", new QueryImpl().eq("Identifier", (Object)entityName));
            try {
                Double threshold_value = Double.parseDouble(threshold);
                entity.set("Threshold", (Object)threshold_value);
                this.dataService.update("MatchingTask", entity);
                this.dataService.getRepository("MatchingTask").flush();
            }
            catch (Exception e) {
                model.addAttribute("message", (Object)(threshold + " is illegal threshold value!"));
            }
        }
        return this.matchResult(entityName, model);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/result/{entityName}"})
    public String matchResult(@PathVariable(value="entityName") String entityName, Model model) {
        String userName = this.userAccountService.getCurrentUser().getUsername();
        model.addAttribute("isRunning", (Object)this.uploadProgress.isUserExists(userName));
        model.addAttribute("progress", (Object)Float.valueOf(this.uploadProgress.getPercentage(userName)));
        model.addAttribute("isMatched", (Object)this.uploadProgress.getUserClickMode(userName));
        model.addAttribute("entityName", (Object)entityName);
        if (this.dataService.hasRepository(entityName) && !this.uploadProgress.isUserExists(userName)) {
            Entity entity = this.dataService.findOne("MatchingTask", new QueryImpl().eq("Identifier", (Object)entityName));
            model.addAttribute("threshold", entity.get("Threshold"));
            model.addAttribute("ontologyIri", entity.get("Code_system"));
            model.addAttribute("numberOfMatched", (Object)this.dataService.count("MatchingTaskContent", new QueryImpl().eq("Ref_entity", (Object)entityName).and().nest().eq("Validated", (Object)true).or().ge("Score", entity.get("Threshold")).unnest()));
            model.addAttribute("numberOfUnmatched", (Object)this.dataService.count("MatchingTaskContent", new QueryImpl().eq("Ref_entity", (Object)entityName).and().nest().eq("Validated", (Object)false).and().lt("Score", entity.get("Threshold")).unnest()));
        }
        return "ontology-match-view";
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/delete"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteResult(@RequestBody String entityName) {
        String userName = this.userAccountService.getCurrentUser().getUsername();
        if (this.dataService.hasRepository(entityName) && !this.uploadProgress.isUserExists(userName)) {
            Iterable iterableMatchingEntities = this.dataService.findAll("MatchingTaskContent", new QueryImpl().eq("Ref_entity", (Object)entityName));
            this.dataService.delete("MatchingTaskContent", iterableMatchingEntities);
            Entity matchingSummaryEntity = this.dataService.findOne("MatchingTask", new QueryImpl().eq("Identifier", (Object)entityName));
            this.dataService.delete("MatchingTask", matchingSummaryEntity);
            this.dataService.deleteAll(entityName);
            this.dataService.getMeta().deleteEntityMeta(entityName);
            this.dataService.getRepository("MatchingTask").flush();
        }
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/match/retrieve"})
    @ResponseBody
    public EntityCollectionResponse matchResult(@RequestBody OntologyServiceRequest ontologyServiceRequest, HttpServletRequest httpServletRequest) {
        ArrayList entityMaps = new ArrayList();
        String entityName = ontologyServiceRequest.getEntityName();
        String ontologyIri = ontologyServiceRequest.getOntologyIri();
        EntityPager entityPager = ontologyServiceRequest.getEntityPager();
        boolean isMatched = ontologyServiceRequest.isMatched();
        Entity entity = this.dataService.findOne("MatchingTask", new QueryImpl().eq("Identifier", (Object)entityName));
        Query query = new QueryImpl().eq("Ref_entity", (Object)entityName).and().nest().eq("Validated", (Object)isMatched);
        Double threshold = Double.parseDouble(entity.get("Threshold").toString());
        if (isMatched) {
            query.or().ge("Score", (Object)threshold).unnest();
        } else {
            query.and().lt("Score", (Object)threshold).unnest();
        }
        long count = this.dataService.count("MatchingTaskContent", query);
        int start = entityPager.getStart();
        int num = entityPager.getNum();
        for (Entity mappingEntity : this.dataService.findAll("MatchingTaskContent", query.offset(start).pageSize(num).sort(new Sort().on("Validated", Sort.Direction.DESC).on("Score", Sort.Direction.DESC)))) {
            Entity RefEntity = this.dataService.findOne(entityName, new QueryImpl().eq("Identifier", (Object)mappingEntity.getString("Input_term")));
            HashMap<String, Map<String, Object>> outputEntity = new HashMap<String, Map<String, Object>>();
            outputEntity.put("inputTerm", OntologyServiceUtil.getEntityAsMap(RefEntity));
            outputEntity.put("matchedTerm", OntologyServiceUtil.getEntityAsMap(mappingEntity));
            Object matchedTerm = mappingEntity.get("Match_term");
            if (matchedTerm != null) {
                outputEntity.put("ontologyTerm", OntologyServiceUtil.getEntityAsMap(this.ontologyService.getOntologyTermEntity(matchedTerm.toString(), ontologyIri)));
            }
            entityMaps.add(outputEntity);
        }
        this.uploadProgress.setUserClickMode(this.userAccountService.getCurrentUser().getUsername(), isMatched);
        EntityPager pager = new EntityPager(start, num, Long.valueOf(count), null);
        return new EntityCollectionResponse(pager, entityMaps, "/match/retrieve", (EntityMetaData)OntologyTermMetaData.INSTANCE, this.molgenisPermissionService);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/match"})
    public String match(@RequestParam(value="taskName", required=true) String entityName, @RequestParam(value="selectOntologies", required=true) String ontologyIri, @RequestParam(value="inputTerms", required=true) String inputTerms, Model model, HttpServletRequest httpServletRequest) throws Exception {
        if (StringUtils.isEmpty((CharSequence)ontologyIri) || StringUtils.isEmpty((CharSequence)inputTerms)) {
            return this.init(model);
        }
        String sessionId = httpServletRequest.getSession().getId();
        File uploadFile = this.fileStore.store((InputStream)new ByteArrayInputStream(inputTerms.getBytes("UTF8")), sessionId + "_input.txt");
        return this.startMatchJob(entityName, ontologyIri, uploadFile, model);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/match/upload"}, headers={"Content-Type=multipart/form-data"})
    public String upload(@RequestParam(value="taskName", required=true) String entityName, @RequestParam(value="selectOntologies", required=true) String ontologyIri, @RequestParam(value="file", required=true) Part file, Model model, HttpServletRequest httpServletRequest) throws Exception {
        if (StringUtils.isEmpty((CharSequence)ontologyIri) || file == null) {
            return this.init(model);
        }
        String sessionId = httpServletRequest.getSession().getId();
        File uploadFile = this.fileStore.store(file.getInputStream(), sessionId + "_input.csv");
        return this.startMatchJob(entityName, ontologyIri, uploadFile, model);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/match/entity"})
    @ResponseBody
    public OntologyServiceResult matchResult(@RequestBody Map<String, Object> request, HttpServletRequest httpServletRequest) {
        if (request.containsKey("entityName") && !StringUtils.isEmpty((CharSequence)request.get("entityName").toString()) && request.containsKey("Identifier") && !StringUtils.isEmpty((CharSequence)request.get("Identifier").toString())) {
            String entityName = request.get("entityName").toString();
            String inputTermIdentifier = request.get("Identifier").toString();
            Entity matchingTaskEntity = this.dataService.findOne("MatchingTask", new QueryImpl().eq("Identifier", (Object)entityName));
            Entity entity = this.dataService.findOne(entityName, new QueryImpl().eq("Identifier", (Object)inputTermIdentifier));
            if (matchingTaskEntity == null || entity == null) {
                return new OntologyServiceResult("entityName or inputTermIdentifier is invalid!");
            }
            return this.ontologyService.searchEntity(matchingTaskEntity.getString("Code_system"), entity);
        }
        return new OntologyServiceResult("Please check entityName, inputTermIdentifier exist in input!");
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/search"})
    @ResponseBody
    public OntologyServiceResult search(@RequestBody Map<String, Object> request, HttpServletRequest httpServletRequest) {
        if (request.containsKey("queryString") && !StringUtils.isEmpty((CharSequence)request.get("queryString").toString()) && request.containsKey("ontologyIRI") && !StringUtils.isEmpty((CharSequence)request.get("ontologyIRI").toString())) {
            String queryString = request.get("queryString").toString();
            String ontologyIri = request.get("ontologyIRI").toString();
            MapEntity entity = new MapEntity();
            entity.set("Name", (Object)queryString);
            return this.ontologyService.searchEntity(ontologyIri, (Entity)entity);
        }
        return new OntologyServiceResult("Please check entityName, inputTermIdentifier exist in input!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(method={RequestMethod.GET}, value={"/match/download/{entityName}"})
    public void download(@PathVariable String entityName, HttpServletResponse response, Model model) throws IOException {
        CsvWriter csvWriter = null;
        try {
            response.setContentType("text/csv");
            response.addHeader("Content-Disposition", "attachment; filename=" + this.getCsvFileName("match-result"));
            csvWriter = new CsvWriter((OutputStream)response.getOutputStream(), OntologyServiceImpl.DEFAULT_SEPARATOR.charValue());
            ArrayList<String> columnHeaders = new ArrayList<String>();
            for (AttributeMetaData attributeMetaData : this.dataService.getEntityMetaData(entityName).getAttributes()) {
                if (attributeMetaData.getName().equalsIgnoreCase("Identifier")) continue;
                columnHeaders.add(attributeMetaData.getName());
            }
            columnHeaders.addAll(Arrays.asList("ontologyTermName", "ontologyTermIRI", "Score", "Validated"));
            csvWriter.writeAttributeNames(columnHeaders);
            Entity matchingTaskEntity = this.dataService.findOne("MatchingTask", new QueryImpl().eq("Identifier", (Object)entityName));
            for (Entity mappingEntity : this.dataService.findAll("MatchingTaskContent", new QueryImpl().eq("Ref_entity", (Object)entityName))) {
                Entity inputEntity = this.dataService.findOne(entityName, new QueryImpl().eq("Identifier", (Object)mappingEntity.getString("Input_term")));
                Entity ontologyTermEntity = this.ontologyService.getOntologyTermEntity(mappingEntity.getString("Match_term"), matchingTaskEntity.getString("Code_system"));
                MapEntity row = new MapEntity();
                for (String attributeName : inputEntity.getAttributeNames()) {
                    if (attributeName.equals("Identifier")) continue;
                    row.set(attributeName, inputEntity.get(attributeName));
                }
                row.set("ontologyTermName", ontologyTermEntity.get("ontologyTermName"));
                row.set("ontologyTermIRI", ontologyTermEntity.get("ontologyTermIRI"));
                row.set("Validated", mappingEntity.get("Validated"));
                row.set("Score", mappingEntity.get("Score"));
                csvWriter.add((Entity)row);
            }
            if (csvWriter == null) return;
        }
        catch (Throwable throwable) {
            if (csvWriter == null) throw throwable;
            IOUtils.closeQuietly(csvWriter);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)csvWriter);
    }

    private String startMatchJob(String entityName, String ontologyIri, File uploadFile, Model model) throws IOException {
        if (this.dataService.hasRepository(entityName = entityName.replaceAll(ILLEGAL_PATTERN, ILLEGAL_PATTERN_REPLACEMENT).toLowerCase())) {
            Entity matchingTaskEntity = this.dataService.findOne("MatchingTask", new QueryImpl().eq("Identifier", (Object)entityName));
            model.addAttribute("message", (Object)("The task name should be case insensitive, the task name <strong>" + entityName + "</strong> has existed and created by user : " + (matchingTaskEntity != null ? matchingTaskEntity.get("Molgenis_user") : "")));
            return this.init(model);
        }
        AdaptedCsvRepository csvRepository = new AdaptedCsvRepository(entityName, new CsvRepository(uploadFile, Arrays.asList(new LowerCaseProcessor(), new TrimProcessor()), OntologyServiceImpl.DEFAULT_SEPARATOR));
        if (!this.validateFileHeader((Repository)csvRepository)) {
            model.addAttribute("message", (Object)"The Name header is missing!");
            return this.matchTask(model);
        }
        if (!this.validateEmptyFileHeader((Repository)csvRepository)) {
            model.addAttribute("message", (Object)"The empty header is not allowed!");
            return this.matchTask(model);
        }
        if (!this.validateInputFileContent((Repository)csvRepository)) {
            model.addAttribute("message", (Object)"The content of input is empty!");
            return this.matchTask(model);
        }
        this.uploadProgress.registerUser(this.userAccountService.getCurrentUser().getUsername(), entityName);
        this.matchInputTermBatchService.process(SecurityContextHolder.getContext(), this.userAccountService.getCurrentUser(), ontologyIri, (Repository)csvRepository);
        return this.matchResult(entityName, model);
    }

    private String getCsvFileName(String dataSetName) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dataSetName + ILLEGAL_PATTERN_REPLACEMENT + dateFormat.format(new Date()) + ".csv";
    }

    private boolean validateFileHeader(Repository repository) {
        boolean containsName = false;
        for (AttributeMetaData atomicAttributes : repository.getEntityMetaData().getAtomicAttributes()) {
            if (!atomicAttributes.getName().equalsIgnoreCase("Name")) continue;
            containsName = true;
        }
        return containsName;
    }

    private boolean validateEmptyFileHeader(Repository repository) {
        for (AttributeMetaData atomicAttributes : repository.getEntityMetaData().getAtomicAttributes()) {
            if (!StringUtils.isEmpty((CharSequence)atomicAttributes.getName())) continue;
            return false;
        }
        return true;
    }

    private boolean validateInputFileContent(Repository repository) {
        Iterator iterator = repository.iterator();
        return iterator.hasNext();
    }
}

