/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.elasticsearch.admin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.molgenis.data.DataService;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.MolgenisDataAccessException;
import org.molgenis.data.Repository;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.data.elasticsearch.admin.ElasticsearchIndexManagerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Service
public class ElasticsearchIndexManagerServiceImpl
implements ElasticsearchIndexManagerService {
    private final DataService dataService;

    @Autowired
    public ElasticsearchIndexManagerServiceImpl(DataService dataService) {
        this.dataService = Objects.requireNonNull(dataService);
    }

    @Override
    @PreAuthorize(value="hasAnyRole('ROLE_SU, ROLE_PLUGIN_READ_INDEXMANAGER')")
    public List<EntityMetaData> getIndexedEntities() {
        ArrayList<EntityMetaData> indexedEntityMetaDataList = new ArrayList<EntityMetaData>();
        for (String entityName : this.dataService.getEntityNames()) {
            Repository repository = this.dataService.getRepository(entityName);
            if (!repository.getCapabilities().contains(RepositoryCapability.INDEXABLE)) continue;
            indexedEntityMetaDataList.add(repository.getEntityMetaData());
        }
        Collections.sort(indexedEntityMetaDataList, new Comparator<EntityMetaData>(){

            @Override
            public int compare(EntityMetaData e1, EntityMetaData e2) {
                return e1.getLabel().compareTo(e2.getLabel());
            }
        });
        return indexedEntityMetaDataList;
    }

    @Override
    @PreAuthorize(value="hasAnyRole('ROLE_SU')")
    public void rebuildIndex(String entityName) {
        Repository repository = this.dataService.getRepository(entityName);
        if (!repository.getCapabilities().contains(RepositoryCapability.INDEXABLE)) {
            throw new MolgenisDataAccessException("Repository [" + entityName + "] is not an indexed repository");
        }
        repository.rebuildIndex();
    }
}

