/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology.matching;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UploadProgress {
    private final Set<String> currentUsers = new HashSet<String>();
    private final Map<String, String> currentJobs = new HashMap<String, String>();
    private final Map<String, Integer> userTotalNumber;
    private final Map<String, Integer> userFinishedNumber;
    private final Map<String, Integer> userThreshold;
    private final Map<String, Boolean> userClickMode = new HashMap<String, Boolean>();
    private static final Integer ILLEGAL_DENOMINATOR = 0;
    private static final Integer DEFAULT_THRESHOLD = 80;

    public UploadProgress() {
        this.userThreshold = new HashMap<String, Integer>();
        this.userTotalNumber = new HashMap<String, Integer>();
        this.userFinishedNumber = new HashMap<String, Integer>();
    }

    public synchronized float getPercentage(String userName) {
        if (this.userTotalNumber.containsKey(userName) && this.userFinishedNumber.containsKey(userName) && !ILLEGAL_DENOMINATOR.equals(this.userTotalNumber.get(userName))) {
            return this.userFinishedNumber.get(userName).floatValue() / this.userTotalNumber.get(userName).floatValue() * 100.0f;
        }
        return 0.0f;
    }

    public synchronized int getThreshold(String userName) {
        if (this.userThreshold.containsKey(userName)) {
            return this.userThreshold.get(userName);
        }
        return 0;
    }

    public synchronized boolean isUserExists(String userName) {
        return this.currentUsers.contains(userName);
    }

    public synchronized String getCurrentJob(String userName) {
        return this.currentJobs.containsKey(userName) ? this.currentJobs.get(userName) : "";
    }

    public synchronized void incrementProgress(String userName) {
        if (this.userFinishedNumber.containsKey(userName)) {
            this.userFinishedNumber.put(userName, this.userFinishedNumber.get(userName) + 1);
        }
    }

    public synchronized void resetUserThreshold(String userName, Integer threshold) {
        this.userThreshold.put(userName, threshold);
    }

    public synchronized void setUserClickMode(String userName, Boolean mode) {
        this.userClickMode.put(userName, mode);
    }

    public synchronized Boolean getUserClickMode(String userName) {
        return this.userClickMode.containsKey(userName) ? this.userClickMode.get(userName) : Boolean.valueOf(false);
    }

    public synchronized void registerUser(String userName, String currentJob, Integer totalNumber) {
        this.currentUsers.add(userName);
        this.userTotalNumber.put(userName, totalNumber);
        this.currentJobs.put(userName, currentJob);
        this.userClickMode.put(userName, false);
        this.userFinishedNumber.put(userName, ILLEGAL_DENOMINATOR);
        this.userThreshold.put(userName, DEFAULT_THRESHOLD);
    }

    public synchronized void registerUser(String userName, String currentJob) {
        this.registerUser(userName, currentJob, ILLEGAL_DENOMINATOR);
    }

    public synchronized void removeUser(String userName) {
        this.currentUsers.remove(userName);
        this.userTotalNumber.remove(userName);
        this.userFinishedNumber.remove(userName);
        this.userThreshold.remove(userName);
        this.currentJobs.remove(userName);
        this.userClickMode.remove(userName);
    }
}

