/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.elasticsearch.admin;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.molgenis.data.elasticsearch.admin.ElasticsearchIndexManagerService;
import org.molgenis.ui.MolgenisPluginController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/plugin/indexmanager"})
public class ElasticsearchIndexManagerController
extends MolgenisPluginController {
    public static final String ID = "indexmanager";
    public static final String URI = "/plugin/indexmanager";
    @Autowired
    private ElasticsearchIndexManagerService elasticsearchIndexManagerService;

    public ElasticsearchIndexManagerController() {
        super(URI);
    }

    @RequestMapping(method={RequestMethod.GET})
    public String init(Model model) {
        model.addAttribute("entities", this.elasticsearchIndexManagerService.getIndexedEntities());
        return "view-indexmanager";
    }

    @RequestMapping(value={"/reindex"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public void reindexType(@Valid @ModelAttribute ReindexRequest reindexRequest) {
        this.elasticsearchIndexManagerService.rebuildIndex(reindexRequest.getType());
    }

    private static class ReindexRequest {
        @NotNull
        private String type;

        private ReindexRequest() {
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

