/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology.matching;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.molgenis.auth.MolgenisUser;
import org.molgenis.auth.UserAuthority;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.Query;
import org.molgenis.data.Repository;
import org.molgenis.data.support.MapEntity;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.ontology.beans.OntologyServiceResult;
import org.molgenis.ontology.matching.OntologyService;
import org.molgenis.ontology.matching.UploadProgress;
import org.molgenis.security.core.Permission;
import org.molgenis.security.core.runas.RunAsSystem;
import org.springframework.scheduling.annotation.Async;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.transaction.annotation.Transactional;

public class MatchInputTermBatchService {
    private static final int ADD_BATCH_SIZE = 1000;
    private final DataService dataService;
    private final UploadProgress uploadProgress;
    private final OntologyService ontologyService;

    public MatchInputTermBatchService(DataService dataService, UploadProgress uploadProgress, OntologyService ontologyService) {
        this.dataService = dataService;
        this.uploadProgress = uploadProgress;
        this.ontologyService = ontologyService;
    }

    @Async
    @RunAsSystem
    @Transactional
    public void process(SecurityContext securityContext, MolgenisUser molgenisUser, String ontologyIri, Repository repository) {
        String entityName = repository.getName();
        String userName = molgenisUser.getUsername();
        this.uploadProgress.registerUser(userName, entityName);
        this.dataService.getMeta().addEntityMeta(repository.getEntityMetaData());
        this.dataService.getRepository(entityName).add((Iterable)repository);
        this.dataService.getRepository(entityName).flush();
        int threshold = this.uploadProgress.getThreshold(userName);
        MapEntity mapEntity = new MapEntity();
        mapEntity.set("Identifier", (Object)entityName);
        mapEntity.set("Date_created", (Object)new Date());
        mapEntity.set("Code_system", (Object)ontologyIri);
        mapEntity.set("Molgenis_user", (Object)userName);
        mapEntity.set("Threshold", (Object)threshold);
        this.dataService.add("MatchingTask", (Entity)mapEntity);
        this.dataService.getRepository("MatchingTask").flush();
        this.uploadProgress.registerUser(userName, entityName, (int)this.dataService.count(entityName, (Query)new QueryImpl()));
        try {
            ArrayList<MapEntity> entitiesToAdd = new ArrayList<MapEntity>();
            for (Entity entity : this.dataService.findAll(entityName)) {
                MapEntity matchingTaskContentEntity = new MapEntity();
                matchingTaskContentEntity.set("Input_term", entity.getIdValue());
                matchingTaskContentEntity.set("Identifier", (Object)(entityName + "_" + entity.getIdValue()));
                matchingTaskContentEntity.set("Ref_entity", (Object)entityName);
                matchingTaskContentEntity.set("Validated", (Object)false);
                entitiesToAdd.add(matchingTaskContentEntity);
                OntologyServiceResult searchEntity = this.ontologyService.searchEntity(ontologyIri, entity);
                if (searchEntity.getOntologyTerms().size() > 0) {
                    Map<String, Object> firstMatchedOntologyTerm = searchEntity.getOntologyTerms().get(0);
                    matchingTaskContentEntity.set("Match_term", firstMatchedOntologyTerm.get("ontologyTermIRI"));
                    matchingTaskContentEntity.set("Score", firstMatchedOntologyTerm.get("Score"));
                } else {
                    matchingTaskContentEntity.set("Score", (Object)0);
                }
                if (entitiesToAdd.size() >= 1000) {
                    this.dataService.add("MatchingTaskContent", entitiesToAdd);
                    entitiesToAdd.clear();
                }
                this.uploadProgress.incrementProgress(userName);
            }
            if (entitiesToAdd.size() != 0) {
                this.dataService.add("MatchingTaskContent", entitiesToAdd);
                entitiesToAdd.clear();
            }
            this.dataService.getRepository("MatchingTaskContent").flush();
            Authentication auth = securityContext.getAuthentication();
            ArrayList roles = Lists.newArrayList((Iterable)auth.getAuthorities());
            for (Permission permiossion : Permission.values()) {
                UserAuthority userAuthority = new UserAuthority();
                userAuthority.setMolgenisUser(molgenisUser);
                String role = "ROLE_ENTITY_" + permiossion.toString() + "_" + entityName.toUpperCase();
                userAuthority.setRole(role);
                roles.add(new SimpleGrantedAuthority(role));
                this.dataService.add("UserAuthority", (Entity)userAuthority);
                this.dataService.getRepository("UserAuthority").flush();
            }
            auth = new UsernamePasswordAuthenticationToken(auth.getPrincipal(), null, (Collection)roles);
            securityContext.setAuthentication(auth);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        finally {
            this.uploadProgress.removeUser(userName);
        }
    }
}

