/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology.sorta.job;

import org.molgenis.data.DataService;
import org.molgenis.data.IdGenerator;
import org.molgenis.data.jobs.JobExecution;
import org.molgenis.data.jobs.JobExecutionUpdater;
import org.molgenis.data.jobs.Progress;
import org.molgenis.data.jobs.ProgressImpl;
import org.molgenis.ontology.sorta.job.SortaJobExecution;
import org.molgenis.ontology.sorta.job.SortaJobImpl;
import org.molgenis.ontology.sorta.job.SortaJobProcessor;
import org.molgenis.ontology.sorta.service.SortaService;
import org.molgenis.security.core.runas.RunAsSystem;
import org.molgenis.ui.menu.MenuReaderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.MailSender;
import org.springframework.security.access.intercept.RunAsUserToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class SortaJobFactory {
    @Autowired
    private DataService dataService;
    @Autowired
    private SortaService sortaService;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private JobExecutionUpdater jobExecutionUpdater;
    @Autowired
    private IdGenerator idGenerator;
    @Autowired
    private MailSender mailSender;
    @Autowired
    private UserDetailsService userDetailsService;
    @Autowired
    private MenuReaderService menuReaderService;

    @RunAsSystem
    public SortaJobImpl create(SortaJobExecution jobExecution) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        ProgressImpl progress = new ProgressImpl((JobExecution)jobExecution, this.jobExecutionUpdater, this.mailSender);
        String username = jobExecution.getUser().getUsername();
        RunAsUserToken runAsAuthentication = new RunAsUserToken("Job Execution", (Object)username, null, this.userDetailsService.loadUserByUsername(username).getAuthorities(), null);
        SortaJobProcessor matchInputTermBatchService = new SortaJobProcessor(jobExecution.getOntologyIri(), jobExecution.getSourceEntityName(), jobExecution.getResultEntityName(), (Progress)progress, this.dataService, this.sortaService, this.idGenerator, this.menuReaderService);
        return new SortaJobImpl(matchInputTermBatchService, (Authentication)runAsAuthentication, (Progress)progress, transactionTemplate);
    }
}

