/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology.roc;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.Query;
import org.molgenis.data.QueryRule;
import org.molgenis.data.semanticsearch.string.NGramDistanceAlgorithm;
import org.molgenis.data.semanticsearch.string.Stemmer;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.ontology.roc.OntologyWord;
import org.springframework.beans.factory.annotation.Autowired;

public class InformationContentService {
    private static final String NON_WORD_SEPARATOR = "[^a-zA-Z0-9]";
    private static final String SINGLE_WHITESPACE = " ";
    private final LoadingCache<String, Long> CACHED_TOTAL_WORD_COUNT = CacheBuilder.newBuilder().maximumSize(Integer.MAX_VALUE).expireAfterWrite(1L, TimeUnit.DAYS).build((CacheLoader)new CacheLoader<String, Long>(){

        public Long load(String ontologyIri) {
            Entity ontologyEntity = InformationContentService.this.dataService.findOne("Ontology_Ontology", new QueryImpl().eq("ontologyIRI", (Object)ontologyIri));
            if (ontologyEntity != null) {
                return InformationContentService.this.dataService.count("Ontology_OntologyTerm", new QueryImpl().eq("ontology", (Object)ontologyEntity));
            }
            return 0L;
        }
    });
    private final LoadingCache<OntologyWord, Double> CACHED_INVERSE_DOCUMENT_FREQ = CacheBuilder.newBuilder().maximumSize(Integer.MAX_VALUE).expireAfterWrite(1L, TimeUnit.DAYS).build((CacheLoader)new CacheLoader<OntologyWord, Double>(){

        public Double load(OntologyWord key) throws ExecutionException {
            String ontologyIri = key.getOntologyIri();
            Entity ontologyEntity = InformationContentService.this.dataService.findOne("Ontology_Ontology", new QueryImpl().eq("ontologyIRI", (Object)ontologyIri));
            if (ontologyEntity != null) {
                QueryRule queryRule = new QueryRule(Arrays.asList(new QueryRule("ontologyTermSynonym", QueryRule.Operator.FUZZY_MATCH, key.getWord())));
                queryRule.setOperator(QueryRule.Operator.DIS_MAX);
                QueryRule finalQuery = new QueryRule(Arrays.asList(new QueryRule("ontology", QueryRule.Operator.EQUALS, (Object)ontologyEntity), new QueryRule(QueryRule.Operator.AND), queryRule));
                long wordCount = InformationContentService.this.dataService.count("Ontology_OntologyTerm", (Query)new QueryImpl(finalQuery));
                Long total = (Long)InformationContentService.this.CACHED_TOTAL_WORD_COUNT.get((Object)ontologyIri);
                BigDecimal idfValue = new BigDecimal(total == null ? 0.0 : 1.0 + Math.log((double)total.longValue() / (double)(wordCount + 1L)));
                return idfValue.doubleValue();
            }
            return 0.0;
        }
    });
    private final DataService dataService;

    @Autowired
    public InformationContentService(DataService dataService) {
        this.dataService = Objects.requireNonNull(dataService);
    }

    public Map<String, Double> redistributedNGramScore(String queryString, String ontologyIri) {
        Map<String, Double> wordIDFMap = this.createWordIDF(queryString, ontologyIri);
        HashMap<String, Double> wordWeightedSimilarity = new HashMap<String, Double>();
        if (wordIDFMap.size() > 0) {
            double diff;
            double averageIDFValue = wordIDFMap.values().stream().mapToDouble(Double::doubleValue).average().getAsDouble();
            double queryStringLength = StringUtils.join(this.createStemmedWordSet(queryString), (String)SINGLE_WHITESPACE).trim().length();
            double totalContribution = 0.0;
            double totalDenominator = 0.0;
            for (Map.Entry<String, Double> entry : wordIDFMap.entrySet()) {
                diff = entry.getValue() - averageIDFValue;
                if (diff < 0.0) {
                    Double contributedSimilarity = (double)entry.getKey().length() / queryStringLength * 100.0 * (diff / averageIDFValue);
                    totalContribution += Math.abs(contributedSimilarity);
                    wordWeightedSimilarity.put(entry.getKey(), contributedSimilarity);
                    continue;
                }
                totalDenominator += diff;
            }
            for (Map.Entry<String, Double> entry : wordIDFMap.entrySet()) {
                diff = entry.getValue() - averageIDFValue;
                if (!(diff > 0.0)) continue;
                wordWeightedSimilarity.put(entry.getKey(), diff / totalDenominator * totalContribution);
            }
        }
        return wordWeightedSimilarity;
    }

    Map<String, Double> createWordIDF(String queryString, String ontologyIri) {
        HashMap<String, Double> wordFreqMap = new HashMap<String, Double>();
        Set<String> wordsInQueryString = this.createStemmedWordSet(queryString);
        wordsInQueryString.stream().forEach(word -> {
            Double wordIDF = null;
            try {
                wordIDF = (Double)this.CACHED_INVERSE_DOCUMENT_FREQ.get((Object)new OntologyWord(ontologyIri, (String)word));
            }
            catch (ExecutionException e) {
                throw new UncheckedExecutionException((Throwable)e);
            }
            if (wordIDF != null && wordIDF != 0.0) {
                wordFreqMap.put((String)word, wordIDF);
            }
        });
        return wordFreqMap;
    }

    public Set<String> createStemmedWordSet(String queryString) {
        Set uniqueTerms = Sets.newHashSet((Object[])queryString.toLowerCase().trim().split(NON_WORD_SEPARATOR)).stream().filter(term -> !NGramDistanceAlgorithm.STOPWORDSLIST.contains(term)).map(Stemmer::stem).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        return Sets.newHashSet(uniqueTerms);
    }
}

