/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology.controller;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.auth.MolgenisUser;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.Fetch;
import org.molgenis.data.IdGenerator;
import org.molgenis.data.Query;
import org.molgenis.data.QueryRule;
import org.molgenis.data.Repository;
import org.molgenis.data.Sort;
import org.molgenis.data.csv.CsvWriter;
import org.molgenis.data.i18n.LanguageService;
import org.molgenis.data.rest.EntityCollectionResponse;
import org.molgenis.data.rest.EntityPager;
import org.molgenis.data.support.DefaultAttributeMetaData;
import org.molgenis.data.support.DefaultEntityMetaData;
import org.molgenis.data.support.MapEntity;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.file.FileStore;
import org.molgenis.ontology.core.meta.OntologyTermMetaData;
import org.molgenis.ontology.core.service.OntologyService;
import org.molgenis.ontology.sorta.job.SortaJobExecution;
import org.molgenis.ontology.sorta.job.SortaJobFactory;
import org.molgenis.ontology.sorta.job.SortaJobImpl;
import org.molgenis.ontology.sorta.meta.MatchingTaskContentEntityMetaData;
import org.molgenis.ontology.sorta.meta.SortaJobExecutionMetaData;
import org.molgenis.ontology.sorta.repo.SortaCsvRepository;
import org.molgenis.ontology.sorta.request.SortaServiceRequest;
import org.molgenis.ontology.sorta.request.SortaServiceResponse;
import org.molgenis.ontology.sorta.service.SortaService;
import org.molgenis.ontology.sorta.service.impl.SortaServiceImpl;
import org.molgenis.ontology.utils.SortaServiceUtil;
import org.molgenis.security.core.MolgenisPermissionService;
import org.molgenis.security.core.Permission;
import org.molgenis.security.core.runas.RunAsSystemProxy;
import org.molgenis.security.permission.PermissionSystemService;
import org.molgenis.security.user.UserAccountService;
import org.molgenis.ui.MolgenisPluginController;
import org.molgenis.ui.menu.MenuReaderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/plugin/sortaservice"})
public class SortaServiceController
extends MolgenisPluginController {
    private final OntologyService ontologyService;
    private final SortaService sortaService;
    private final DataService dataService;
    private final UserAccountService userAccountService;
    private final SortaJobFactory sortaMatchJobFactory;
    private final ExecutorService taskExecutor;
    private final FileStore fileStore;
    private final MolgenisPermissionService molgenisPermissionService;
    private final LanguageService languageService;
    private final MenuReaderService menuReaderService;
    private final IdGenerator idGenerator;
    private final PermissionSystemService permissionSystemService;
    public static final String MATCH_VIEW_NAME = "sorta-match-view";
    public static final String ID = "sortaservice";
    public static final String URI = "/plugin/sortaservice";
    private static final double DEFAULT_THRESHOLD = 100.0;
    private static final Logger LOG = LoggerFactory.getLogger(SortaServiceController.class);

    @Autowired
    public SortaServiceController(OntologyService ontologyService, SortaService sortaService, SortaJobFactory sortaMatchJobFactory, ExecutorService taskExecutor, UserAccountService userAccountService, FileStore fileStore, MolgenisPermissionService molgenisPermissionService, DataService dataService, LanguageService languageService, MenuReaderService menuReaderService, IdGenerator idGenerator, PermissionSystemService permissionSystemService) {
        super(URI);
        this.ontologyService = Objects.requireNonNull(ontologyService);
        this.sortaService = Objects.requireNonNull(sortaService);
        this.sortaMatchJobFactory = Objects.requireNonNull(sortaMatchJobFactory);
        this.taskExecutor = Objects.requireNonNull(taskExecutor);
        this.userAccountService = Objects.requireNonNull(userAccountService);
        this.fileStore = Objects.requireNonNull(fileStore);
        this.molgenisPermissionService = Objects.requireNonNull(molgenisPermissionService);
        this.dataService = Objects.requireNonNull(dataService);
        this.languageService = Objects.requireNonNull(languageService);
        this.menuReaderService = Objects.requireNonNull(menuReaderService);
        this.idGenerator = Objects.requireNonNull(idGenerator);
        this.permissionSystemService = Objects.requireNonNull(permissionSystemService);
    }

    @RequestMapping(method={RequestMethod.GET})
    public String init(Model model) {
        model.addAttribute("existingTasks", this.getJobsForCurrentUser());
        return MATCH_VIEW_NAME;
    }

    private SortaJobExecution findSortaJobExecution(String sortaJobExecutionId) {
        Fetch fetch = new Fetch();
        SortaJobExecutionMetaData.INSTANCE.getAtomicAttributes().forEach(attr -> fetch.field(attr.getName()));
        SortaJobExecution result = (SortaJobExecution)((Object)RunAsSystemProxy.runAsSystem(() -> (SortaJobExecution)this.dataService.findOne("SortaJobExecution", (Object)sortaJobExecutionId, fetch, SortaJobExecution.class)));
        return result;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/jobs"})
    @ResponseBody
    public List<Entity> getJobs(Model model) {
        return this.getJobsForCurrentUser();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/newtask"})
    public String matchTask(Model model) {
        model.addAttribute("ontologies", (Object)this.ontologyService.getOntologies());
        return MATCH_VIEW_NAME;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/threshold/{sortaJobExecutionId}"})
    public String updateThreshold(@RequestParam(value="threshold", required=true) String threshold, @PathVariable String sortaJobExecutionId, Model model) {
        if (!StringUtils.isEmpty((CharSequence)threshold)) {
            SortaJobExecution sortaJobExecution = this.findSortaJobExecution(sortaJobExecutionId);
            try {
                MolgenisUser currentUser = this.userAccountService.getCurrentUser();
                if (currentUser.isSuperuser().booleanValue() || sortaJobExecution.getUser().equals(currentUser.getUsername())) {
                    RunAsSystemProxy.runAsSystem(() -> {
                        Double thresholdValue = Double.parseDouble(threshold);
                        sortaJobExecution.setThreshold(thresholdValue);
                        this.dataService.update("SortaJobExecution", (Entity)sortaJobExecution);
                    });
                }
            }
            catch (NumberFormatException e) {
                model.addAttribute("message", (Object)(threshold + " is illegal threshold value!"));
            }
            catch (Exception other) {
                model.addAttribute("message", (Object)("Error updating threshold: " + other.getMessage()));
            }
        }
        return this.matchResult(sortaJobExecutionId, model);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/result/{sortaJobExecutionId}"})
    public String matchResult(@PathVariable(value="sortaJobExecutionId") String sortaJobExecutionId, Model model) {
        SortaJobExecution sortaJobExecution = this.findSortaJobExecution(sortaJobExecutionId);
        if (sortaJobExecution != null) {
            model.addAttribute("sortaJobExecutionId", (Object)sortaJobExecution.getIdentifier());
            model.addAttribute("threshold", (Object)sortaJobExecution.getThreshold());
            model.addAttribute("ontologyIri", (Object)sortaJobExecution.getOntologyIri());
            model.addAttribute("numberOfMatched", (Object)this.countMatchedEntities(sortaJobExecution, true));
            model.addAttribute("numberOfUnmatched", (Object)this.countMatchedEntities(sortaJobExecution, false));
            return MATCH_VIEW_NAME;
        }
        LOG.info("Job execution with id " + sortaJobExecutionId + " not found.");
        model.addAttribute("message", (Object)"Job execution not found.");
        return this.init(model);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/count/{sortaJobExecutionId}"})
    @ResponseBody
    public Map<String, Object> countMatchResult(@PathVariable(value="sortaJobExecutionId") String sortaJobExecutionId) {
        SortaJobExecution sortaJobExecution = this.findSortaJobExecution(sortaJobExecutionId);
        return ImmutableMap.of((Object)"numberOfMatched", (Object)this.countMatchedEntities(sortaJobExecution, true), (Object)"numberOfUnmatched", (Object)this.countMatchedEntities(sortaJobExecution, false));
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/delete/{sortaJobExecutionId}"})
    @ResponseStatus(value=HttpStatus.OK)
    public String deleteResult(@PathVariable(value="sortaJobExecutionId") String sortaJobExecutionId, Model model) {
        MolgenisUser currentUser;
        SortaJobExecution sortaJobExecution = this.findSortaJobExecution(sortaJobExecutionId);
        if (sortaJobExecution != null && ((currentUser = this.userAccountService.getCurrentUser()).isSuperuser().booleanValue() || sortaJobExecution.getUser().equals(currentUser.getUsername()))) {
            RunAsSystemProxy.runAsSystem(() -> this.dataService.delete("SortaJobExecution", (Object)sortaJobExecution.getIdentifier()));
            this.tryDeleteRepository(sortaJobExecution.getResultEntityName());
            this.tryDeleteRepository(sortaJobExecution.getSourceEntityName());
        }
        return this.init(model);
    }

    private void tryDeleteRepository(String entityName) {
        if (this.dataService.hasRepository(entityName) && this.molgenisPermissionService.hasPermissionOnEntity(entityName, Permission.WRITEMETA)) {
            RunAsSystemProxy.runAsSystem(() -> this.deleteRepository(entityName));
        } else {
            LOG.info("Unable to delete repository {}", (Object)entityName);
        }
    }

    private void deleteRepository(String entityName) {
        try {
            this.dataService.getMeta().deleteEntityMeta(entityName);
            LOG.info("Deleted repository {}", (Object)entityName);
        }
        catch (Exception ex) {
            LOG.error("Failed to delete existing writable repository {}", (Object)entityName);
        }
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/match/retrieve"})
    @ResponseBody
    public EntityCollectionResponse retrieveSortaJobResults(@RequestBody SortaServiceRequest sortaServiceRequest, HttpServletRequest httpServletRequest) {
        ArrayList entityMaps = new ArrayList();
        String sortaJobExecutionId = sortaServiceRequest.getSortaJobExecutionId();
        String filterQuery = sortaServiceRequest.getFilterQuery();
        String ontologyIri = sortaServiceRequest.getOntologyIri();
        EntityPager entityPager = sortaServiceRequest.getEntityPager();
        SortaJobExecution sortaJobExecution = this.findSortaJobExecution(sortaJobExecutionId);
        String resultEntityName = sortaJobExecution.getResultEntityName();
        double threshold = sortaJobExecution.getThreshold();
        boolean isMatched = sortaServiceRequest.isMatched();
        QueryRule queryRuleInputEntities = new QueryRule(Arrays.asList(new QueryRule("validated", QueryRule.Operator.EQUALS, (Object)isMatched), new QueryRule(isMatched ? QueryRule.Operator.OR : QueryRule.Operator.AND), new QueryRule("score", isMatched ? QueryRule.Operator.GREATER_EQUAL : QueryRule.Operator.LESS, (Object)threshold)));
        List<QueryRule> queryRuleInputEntitiesInOneMatchingTask = Arrays.asList(queryRuleInputEntities);
        if (StringUtils.isNotEmpty((CharSequence)filterQuery)) {
            Iterable filteredInputTermIds = this.dataService.findAll(sortaJobExecution.getSourceEntityName(), new QueryImpl().search(filterQuery)).map(inputEntity -> inputEntity.getString("Identifier")).collect(Collectors.toList());
            QueryRule previousQueryRule = new QueryRule(queryRuleInputEntitiesInOneMatchingTask);
            QueryRule queryRuleFilterInput = new QueryRule("inputTerm", QueryRule.Operator.IN, (Object)filteredInputTermIds);
            queryRuleInputEntitiesInOneMatchingTask = Arrays.asList(previousQueryRule, new QueryRule(QueryRule.Operator.AND), queryRuleFilterInput);
        }
        QueryImpl query = new QueryImpl(queryRuleInputEntitiesInOneMatchingTask);
        long count = this.dataService.count(resultEntityName, (Query)query);
        int start = entityPager.getStart();
        int num = entityPager.getNum();
        Stream findAll = this.dataService.findAll(sortaJobExecution.getResultEntityName(), query.offset(start).pageSize(num).sort(new Sort().on("validated", Sort.Direction.DESC).on("score", Sort.Direction.DESC)));
        findAll.forEach(mappingEntity -> {
            HashMap<String, Map<String, Object>> outputEntity = new HashMap<String, Map<String, Object>>();
            outputEntity.put("inputTerm", SortaServiceUtil.getEntityAsMap(mappingEntity.getEntity("inputTerm")));
            outputEntity.put("matchedTerm", SortaServiceUtil.getEntityAsMap(mappingEntity));
            Object matchedTerm = mappingEntity.get("matchTerm");
            if (matchedTerm != null) {
                outputEntity.put("ontologyTerm", SortaServiceUtil.getEntityAsMap(this.sortaService.getOntologyTermEntity(matchedTerm.toString(), ontologyIri)));
            }
            entityMaps.add(outputEntity);
        });
        EntityPager pager = new EntityPager(start, num, Long.valueOf(count), null);
        return new EntityCollectionResponse(pager, entityMaps, "/match/retrieve", (EntityMetaData)OntologyTermMetaData.INSTANCE, this.molgenisPermissionService, this.dataService, this.languageService);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/match"})
    public String match(@RequestParam(value="taskName", required=true) String jobName, @RequestParam(value="selectOntologies", required=true) String ontologyIri, @RequestParam(value="inputTerms", required=true) String inputTerms, Model model, HttpServletRequest httpServletRequest) throws Exception {
        if (StringUtils.isEmpty((CharSequence)ontologyIri) || StringUtils.isEmpty((CharSequence)inputTerms)) {
            return this.init(model);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(inputTerms.getBytes("UTF8"));
        return this.startMatchJob(jobName, ontologyIri, model, httpServletRequest, inputStream);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/match/upload"}, headers={"Content-Type=multipart/form-data"})
    public String upload(@RequestParam(value="taskName", required=true) String jobName, @RequestParam(value="selectOntologies", required=true) String ontologyIri, @RequestParam(value="file", required=true) Part file, Model model, HttpServletRequest httpServletRequest) throws Exception {
        if (StringUtils.isEmpty((CharSequence)ontologyIri) || file == null) {
            return this.init(model);
        }
        InputStream inputStream = file.getInputStream();
        return this.startMatchJob(jobName, ontologyIri, model, httpServletRequest, inputStream);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/match/entity"})
    @ResponseBody
    public SortaServiceResponse findMatchingOntologyTerms(@RequestBody Map<String, Object> request, HttpServletRequest httpServletRequest) {
        if (request.containsKey("sortaJobExecutionId") && !StringUtils.isEmpty((CharSequence)request.get("sortaJobExecutionId").toString()) && request.containsKey("identifier") && !StringUtils.isEmpty((CharSequence)request.get("identifier").toString())) {
            String sortaJobExecutionId = request.get("sortaJobExecutionId").toString();
            SortaJobExecution sortaJobExecution = this.findSortaJobExecution(sortaJobExecutionId);
            if (sortaJobExecution == null) {
                return new SortaServiceResponse("sortaJobExecutionId is invalid!");
            }
            String inputTermIdentifier = request.get("identifier").toString();
            Entity inputEntity = this.dataService.findOne(sortaJobExecution.getSourceEntityName(), (Object)inputTermIdentifier);
            if (inputEntity == null) {
                return new SortaServiceResponse("inputTerm identifier is invalid!");
            }
            return new SortaServiceResponse(inputEntity, this.sortaService.findOntologyTermEntities(sortaJobExecution.getOntologyIri(), inputEntity));
        }
        return new SortaServiceResponse("Please check that sortaJobExecutionId and identifier keys exist in input and have nonempty value!");
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/search"})
    @ResponseBody
    public SortaServiceResponse search(@RequestBody Map<String, Object> request, HttpServletRequest httpServletRequest) {
        if (request.containsKey("queryString") && !StringUtils.isEmpty((CharSequence)request.get("queryString").toString()) && request.containsKey("ontologyIRI") && !StringUtils.isEmpty((CharSequence)request.get("ontologyIRI").toString())) {
            String queryString = request.get("queryString").toString();
            String ontologyIri = request.get("ontologyIRI").toString();
            MapEntity inputEntity = new MapEntity(Collections.singletonMap("Name", queryString));
            return new SortaServiceResponse((Entity)inputEntity, this.sortaService.findOntologyTermEntities(ontologyIri, (Entity)inputEntity));
        }
        return new SortaServiceResponse("Please check that queryString and ontologyIRI keys exist in input and have nonempty value!");
    }

    private MapEntity toDownloadRow(SortaJobExecution sortaJobExecution, Entity resultEntity) {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(2);
        Entity inputEntity = resultEntity.getEntity("inputTerm");
        Entity ontologyTermEntity = this.sortaService.getOntologyTermEntity(resultEntity.getString("matchTerm"), sortaJobExecution.getOntologyIri());
        MapEntity row = new MapEntity(inputEntity);
        row.set("ontologyTermName", (Object)ontologyTermEntity.getString("ontologyTermName"));
        row.set("ontologyTermIRI", (Object)ontologyTermEntity.getString("ontologyTermIRI"));
        row.set("validated", (Object)resultEntity.getBoolean("validated"));
        Double score = resultEntity.getDouble("score");
        if (score != null) {
            row.set("score", (Object)format.format(score));
        }
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.GET}, value={"/match/download/{sortaJobExecutionId}"})
    public void download(@PathVariable String sortaJobExecutionId, HttpServletResponse response, Model model) throws IOException {
        CsvWriter csvWriter = new CsvWriter((OutputStream)response.getOutputStream(), SortaServiceImpl.DEFAULT_SEPARATOR.charValue());
        try {
            SortaJobExecution sortaJobExecution = this.findSortaJobExecution(sortaJobExecutionId);
            response.setContentType("text/csv");
            response.addHeader("Content-Disposition", "attachment; filename=" + this.generateCsvFileName("match-result"));
            ArrayList<String> columnHeaders = new ArrayList<String>();
            EntityMetaData sourceMetaData = this.dataService.getEntityMetaData(sortaJobExecution.getSourceEntityName());
            for (AttributeMetaData attributeMetaData : sourceMetaData.getAttributes()) {
                if (attributeMetaData.getName().equalsIgnoreCase("Identifier")) continue;
                columnHeaders.add(attributeMetaData.getName());
            }
            columnHeaders.addAll(Arrays.asList("ontologyTermName", "ontologyTermIRI", "score", "validated"));
            csvWriter.writeAttributeNames(columnHeaders);
            this.dataService.findAll(sortaJobExecution.getResultEntityName(), (Query)new QueryImpl()).forEach(resultEntity -> csvWriter.add((Entity)this.toDownloadRow(sortaJobExecution, (Entity)resultEntity)));
        }
        finally {
            if (csvWriter != null) {
                IOUtils.closeQuietly((Closeable)csvWriter);
            }
        }
    }

    private String startMatchJob(String jobName, String ontologyIri, Model model, HttpServletRequest httpServletRequest, InputStream inputStream) throws IOException {
        String sessionId = httpServletRequest.getSession().getId();
        File uploadFile = this.fileStore.store(inputStream, sessionId + "_input.csv");
        String inputRepositoryName = this.idGenerator.generateId();
        SortaCsvRepository inputRepository = new SortaCsvRepository(inputRepositoryName, jobName + " input", uploadFile);
        if (!this.validateFileHeader((Repository)inputRepository)) {
            model.addAttribute("message", (Object)"The Name header is missing!");
            return this.matchTask(model);
        }
        if (!this.validateEmptyFileHeader((Repository)inputRepository)) {
            model.addAttribute("message", (Object)"The empty header is not allowed!");
            return this.matchTask(model);
        }
        if (!this.validateInputFileContent((Repository)inputRepository)) {
            model.addAttribute("message", (Object)"The content of input is empty!");
            return this.matchTask(model);
        }
        SortaJobExecution jobExecution = this.createJobExecution((Repository)inputRepository, jobName, ontologyIri, SecurityContextHolder.getContext());
        SortaJobImpl sortaMatchJob = this.sortaMatchJobFactory.create(jobExecution);
        this.taskExecutor.submit(sortaMatchJob);
        return "redirect:" + this.getSortaServiceMenuUrl();
    }

    private List<Entity> getJobsForCurrentUser() {
        ArrayList<Entity> jobs = new ArrayList<Entity>();
        MolgenisUser currentUser = this.userAccountService.getCurrentUser();
        Query query = QueryImpl.EQ((String)"user", (Object)currentUser);
        query.sort().on("startDate", Sort.Direction.DESC);
        RunAsSystemProxy.runAsSystem(() -> this.dataService.findAll("SortaJobExecution", query).forEach(job -> {
            job.set("user", (Object)currentUser);
            jobs.add((Entity)job);
        }));
        return jobs;
    }

    private SortaJobExecution createJobExecution(Repository inputData, String jobName, String ontologyIri, SecurityContext securityContext) {
        String resultEntityName = this.idGenerator.generateId();
        SortaJobExecution sortaJobExecution = new SortaJobExecution(this.dataService);
        sortaJobExecution.setIdentifier(resultEntityName);
        sortaJobExecution.setName(jobName);
        sortaJobExecution.setUser(this.userAccountService.getCurrentUser());
        sortaJobExecution.setSourceEntityName(inputData.getName());
        sortaJobExecution.setDeleteUrl(this.getSortaServiceMenuUrl() + "/delete/" + resultEntityName);
        sortaJobExecution.setResultEntityName(resultEntityName);
        sortaJobExecution.setThreshold(100.0);
        sortaJobExecution.setOntologyIri(ontologyIri);
        RunAsSystemProxy.runAsSystem(() -> {
            this.createInputRepository(inputData);
            this.createEmptyResultRepository(jobName, resultEntityName, inputData.getEntityMetaData());
            this.dataService.add("SortaJobExecution", (Entity)sortaJobExecution);
        });
        this.permissionSystemService.giveUserEntityPermissions(SecurityContextHolder.getContext(), Arrays.asList(inputData.getName(), resultEntityName));
        return sortaJobExecution;
    }

    private void createEmptyResultRepository(String jobName, String resultEntityName, EntityMetaData sourceMetaData) {
        DefaultEntityMetaData resultEntityMetaData = new DefaultEntityMetaData(resultEntityName, (EntityMetaData)MatchingTaskContentEntityMetaData.INSTANCE);
        resultEntityMetaData.setAbstract(false);
        resultEntityMetaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData("inputTerm", MolgenisFieldTypes.FieldTypeEnum.XREF).setRefEntity(sourceMetaData).setDescription("Reference to the input term").setNillable(false), new EntityMetaData.AttributeRole[0]);
        resultEntityMetaData.setLabel(jobName + " output");
        this.dataService.getMeta().addEntityMeta((EntityMetaData)resultEntityMetaData);
    }

    private void createInputRepository(Repository inputRepository) {
        this.dataService.getMeta().addEntityMeta(inputRepository.getEntityMetaData());
        this.dataService.getRepository(inputRepository.getName()).add(inputRepository.stream());
    }

    private long countMatchedEntities(SortaJobExecution sortaJobExecution, boolean isMatched) {
        double threshold = sortaJobExecution.getThreshold();
        QueryRule validatedRule = new QueryRule("validated", QueryRule.Operator.EQUALS, (Object)isMatched);
        QueryRule thresholdRule = new QueryRule("score", isMatched ? QueryRule.Operator.GREATER_EQUAL : QueryRule.Operator.LESS, (Object)threshold);
        QueryRule combinedRule = new QueryRule(Arrays.asList(validatedRule, new QueryRule(isMatched ? QueryRule.Operator.OR : QueryRule.Operator.AND), thresholdRule));
        return this.dataService.count(sortaJobExecution.getResultEntityName(), (Query)new QueryImpl(combinedRule));
    }

    private String generateCsvFileName(String dataSetName) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dataSetName + "_" + dateFormat.format(new Date()) + ".csv";
    }

    private boolean validateFileHeader(Repository repository) {
        boolean containsName = StreamSupport.stream(repository.getEntityMetaData().getAttributes().spliterator(), false).map(AttributeMetaData::getName).anyMatch(name -> name.equalsIgnoreCase("Name"));
        return containsName;
    }

    private boolean validateEmptyFileHeader(Repository repository) {
        boolean evaluation = StreamSupport.stream(repository.getEntityMetaData().getAttributes().spliterator(), false).map(AttributeMetaData::getName).anyMatch(StringUtils::isNotBlank);
        return evaluation;
    }

    private boolean validateInputFileContent(Repository repository) {
        return repository.iterator().hasNext();
    }

    private String getSortaServiceMenuUrl() {
        return this.menuReaderService.getMenu().findMenuItemPath(ID);
    }
}

