/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology.initializer;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Map;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.UnknownEntityException;
import org.molgenis.data.support.MapEntity;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.ontology.initializer.OntologyScriptInitializer;
import org.molgenis.security.core.runas.RunAsSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.util.FileCopyUtils;

@Service
public class OntologyScriptInitializerImpl
implements OntologyScriptInitializer {
    private final DataService dataService;
    private static final String ROC_CURVE_SCRIPT_NAME = "roc";
    private static final String ROC_CURVE_SCRIPT_PARAMETER = "filePath";
    private static final Logger LOG = LoggerFactory.getLogger(OntologyScriptInitializerImpl.class);

    @Autowired
    public OntologyScriptInitializerImpl(DataService dataService) {
        if (dataService == null) {
            throw new IllegalArgumentException("DataService cannot be null");
        }
        this.dataService = dataService;
    }

    @Override
    @RunAsSystem
    public void initialize() {
        ClassPathResource resource = new ClassPathResource("roc-curve.R");
        if (resource.exists()) {
            long count = this.dataService.count("Script", new QueryImpl().eq("name", (Object)ROC_CURVE_SCRIPT_NAME));
            if (count == 0L) {
                String scriptContent;
                Entity scriptType = this.dataService.findOne("ScriptType", new QueryImpl().eq("name", (Object)"R"));
                if (scriptType == null) {
                    throw new UnknownEntityException("ScriptType R does not exist!");
                }
                try {
                    scriptContent = FileCopyUtils.copyToString((Reader)new InputStreamReader(resource.getInputStream(), "UTF-8"));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                if (this.dataService.count("ScriptParameter", new QueryImpl().eq("name", (Object)ROC_CURVE_SCRIPT_PARAMETER)) == 0L) {
                    this.dataService.add("ScriptParameter", (Entity)new MapEntity((Map)ImmutableMap.of((Object)"name", (Object)ROC_CURVE_SCRIPT_PARAMETER)));
                }
                Entity scriptParameterEntity = this.dataService.findOne("ScriptParameter", new QueryImpl().eq("name", (Object)ROC_CURVE_SCRIPT_PARAMETER));
                MapEntity scriptEntity = new MapEntity();
                scriptEntity.set("name", (Object)ROC_CURVE_SCRIPT_NAME);
                scriptEntity.set("generateToken", (Object)true);
                scriptEntity.set("type", (Object)scriptType);
                scriptEntity.set("resultFileExtension", (Object)"png");
                scriptEntity.set("content", (Object)scriptContent);
                scriptEntity.set("parameters", Arrays.asList(scriptParameterEntity));
                this.dataService.add("Script", (Entity)scriptEntity);
                LOG.info("Script entity \"roc\" has been added to the database!");
            } else {
                LOG.info("Script entity \"roc\" already exists in the database!");
            }
        } else {
            LOG.info("R script \"roc-curve.R\" does not exist on classpath!");
        }
    }
}

