/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology.sorta.repo;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.data.csv.CsvRepository;
import org.molgenis.data.processor.CellProcessor;
import org.molgenis.data.processor.LowerCaseProcessor;
import org.molgenis.data.processor.TrimProcessor;
import org.molgenis.data.support.AbstractRepository;
import org.molgenis.data.support.DefaultAttributeMetaData;
import org.molgenis.data.support.DefaultEntityMetaData;
import org.molgenis.data.support.MapEntity;
import org.molgenis.ontology.sorta.service.impl.SortaServiceImpl;

public class SortaCsvRepository
extends AbstractRepository {
    private DefaultEntityMetaData entityMetaData = null;
    private final CsvRepository csvRepository;
    private final String entityName;
    private final String entityLabel;
    public static final String ALLOWED_IDENTIFIER = "Identifier";
    private static final List<CellProcessor> LOWERCASE_AND_TRIM = Arrays.asList(new LowerCaseProcessor(), new TrimProcessor());

    public SortaCsvRepository(File file) {
        this.csvRepository = new CsvRepository(file, LOWERCASE_AND_TRIM, SortaServiceImpl.DEFAULT_SEPARATOR);
        this.entityName = file.getName();
        this.entityLabel = file.getName();
    }

    public SortaCsvRepository(String entityName, String entityLabel, File uploadedFile) {
        this.csvRepository = new CsvRepository(uploadedFile, LOWERCASE_AND_TRIM, SortaServiceImpl.DEFAULT_SEPARATOR);
        this.entityName = entityName;
        this.entityLabel = entityLabel;
    }

    public EntityMetaData getEntityMetaData() {
        if (this.entityMetaData == null) {
            this.entityMetaData = new DefaultEntityMetaData(this.entityName, this.csvRepository.getEntityMetaData());
            this.entityMetaData.setLabel(this.entityLabel);
            this.entityMetaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(ALLOWED_IDENTIFIER).setNillable(false), new EntityMetaData.AttributeRole[]{EntityMetaData.AttributeRole.ROLE_ID});
            AttributeMetaData nameAttribute = this.entityMetaData.getAttribute("Name");
            if (nameAttribute != null) {
                this.entityMetaData.setLabelAttribute(nameAttribute);
            }
        }
        return this.entityMetaData;
    }

    public Iterator<Entity> iterator() {
        final AtomicInteger count = new AtomicInteger(0);
        final Iterator iterator = this.csvRepository.iterator();
        return new Iterator<Entity>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Entity next() {
                Entity entity = (Entity)iterator.next();
                if (StringUtils.isEmpty((CharSequence)entity.getString(SortaCsvRepository.ALLOWED_IDENTIFIER))) {
                    entity = new MapEntity(entity);
                    entity.set(SortaCsvRepository.ALLOWED_IDENTIFIER, (Object)count.incrementAndGet());
                }
                return entity;
            }
        };
    }

    public Set<RepositoryCapability> getCapabilities() {
        return Collections.emptySet();
    }

    public long count() {
        return this.csvRepository.count();
    }
}

