/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology.utils;

import com.google.common.collect.FluentIterable;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisInvalidFormatException;
import org.molgenis.data.excel.ExcelRepository;
import org.molgenis.data.excel.ExcelRepositoryCollection;
import org.molgenis.data.excel.ExcelSheetWriter;
import org.molgenis.data.excel.ExcelWriter;
import org.molgenis.data.support.MapEntity;
import org.molgenis.data.support.UuidGenerator;
import org.molgenis.ontology.core.meta.OntologyMetaData;
import org.molgenis.ontology.core.meta.OntologyTermMetaData;
import org.molgenis.ontology.core.meta.OntologyTermNodePathMetaData;
import org.molgenis.ontology.core.meta.OntologyTermSynonymMetaData;

public class LifeLinesCodeToEmxConvertor {
    private static final String CODE_SYSTEM = "codesystem";
    private static final String NAME = "name";
    private static final String CODE = "code";
    private static final String TOP_NODE_PATH = "0[0]";
    private static final String TOP_NODE_NAME = "top";

    public static void main(String[] args) throws InvalidFormatException, IOException, MolgenisInvalidFormatException {
        if (args.length != 0) {
            File lifeLinesCodeFile = new File(args[0]);
            if (lifeLinesCodeFile.exists()) {
                LifeLinesCodeToEmxConvertor.convert(lifeLinesCodeFile);
            }
        } else {
            System.out.println("Please provide the file path for the lifelines codes!");
        }
    }

    public static void convert(File lifeLinesCodeFile) throws InvalidFormatException, IOException, MolgenisInvalidFormatException {
        UuidGenerator uuidGenerator = new UuidGenerator();
        File lifeLinesCodeEmxFile = new File(lifeLinesCodeFile.getParent() + "/" + LifeLinesCodeToEmxConvertor.createLifelinesCodeEmxFileName(lifeLinesCodeFile));
        ExcelWriter excelWriter = new ExcelWriter(lifeLinesCodeEmxFile);
        ExcelSheetWriter ontologyExcelSheet = excelWriter.createWritable("Ontology_Ontology", (List)FluentIterable.from((Iterable)OntologyMetaData.INSTANCE.getAtomicAttributes()).transform(attr -> attr.getName()).toList());
        ExcelSheetWriter ontologyTermExcelSheet = excelWriter.createWritable("Ontology_OntologyTerm", (List)FluentIterable.from((Iterable)OntologyTermMetaData.INSTANCE.getAtomicAttributes()).transform(attr -> attr.getName()).toList());
        ExcelSheetWriter ontologyTermSynonymExcelSheet = excelWriter.createWritable("Ontology_OntologyTermSynonym", (List)FluentIterable.from((Iterable)OntologyTermSynonymMetaData.INSTANCE.getAtomicAttributes()).transform(attr -> attr.getName()).toList());
        ExcelSheetWriter ontologyTermNodePathExcelSheet = excelWriter.createWritable("Ontology_OntologyTermNodePath", (List)FluentIterable.from((Iterable)OntologyTermNodePathMetaData.INSTANCE.getAtomicAttributes()).transform(attr -> attr.getName()).toList());
        ExcelRepositoryCollection excelRepositoryCollection = new ExcelRepositoryCollection(lifeLinesCodeFile);
        if (excelRepositoryCollection.getNumberOfSheets() > 0) {
            String identifier;
            String codeName;
            String code;
            String codeSystem;
            ExcelRepository excelRepository = excelRepositoryCollection.getSheet(0);
            HashMap<String, String> ontologyToIdMap = new HashMap<String, String>();
            for (Object entity : excelRepository) {
                String codeSystem2 = entity.getString(CODE_SYSTEM);
                if (ontologyToIdMap.containsKey(codeSystem2)) continue;
                String generateId = uuidGenerator.generateId();
                ontologyToIdMap.put(codeSystem2, generateId);
                ontologyExcelSheet.add(LifeLinesCodeToEmxConvertor.createOntologyEntity(codeSystem2, generateId));
            }
            HashMap<String, String> ontologyTermSynonymMap = new HashMap<String, String>();
            for (Entity entity : excelRepository) {
                String codeSystem3 = entity.getString(CODE_SYSTEM);
                String code2 = entity.getString(CODE);
                String codeName2 = entity.getString(NAME);
                String generateId = uuidGenerator.generateId();
                ontologyTermSynonymExcelSheet.add(LifeLinesCodeToEmxConvertor.createOntologyTermSynonymEntity(codeName2, generateId));
                String identifier2 = codeSystem3 + code2 + codeName2;
                ontologyTermSynonymMap.put(identifier2, generateId);
            }
            int count = 0;
            HashMap<String, String> ontologyTermNodePathMap = new HashMap<String, String>();
            for (Entity entity : excelRepository) {
                codeSystem = entity.getString(CODE_SYSTEM);
                code = entity.getString(CODE);
                codeName = entity.getString(NAME);
                identifier = codeSystem + code + codeName;
                String nodePath = codeName.equals(TOP_NODE_NAME) ? TOP_NODE_PATH : "0[0]." + count + "[1]";
                String generatedId = uuidGenerator.generateId();
                ontologyTermNodePathExcelSheet.add(LifeLinesCodeToEmxConvertor.createOntologyNodePathEntity(nodePath, StringUtils.equalsIgnoreCase((CharSequence)TOP_NODE_NAME, (CharSequence)codeName), generatedId));
                ++count;
                ontologyTermNodePathMap.put(identifier, generatedId);
            }
            for (Entity entity : excelRepository) {
                codeSystem = entity.getString(CODE_SYSTEM);
                code = entity.getString(CODE);
                codeName = entity.getString(NAME);
                identifier = codeSystem + code + codeName;
                String ontologyReferenceId = (String)ontologyToIdMap.get(codeSystem);
                String synonymReferenceId = (String)ontologyTermSynonymMap.get(identifier);
                String nodePathReferenceId = (String)ontologyTermNodePathMap.get(identifier);
                ontologyTermExcelSheet.add(LifeLinesCodeToEmxConvertor.createOntologyTermEntity(codeName, code, ontologyReferenceId, synonymReferenceId, nodePathReferenceId, uuidGenerator.generateId()));
            }
        }
        ontologyExcelSheet.close();
        ontologyTermExcelSheet.close();
        ontologyTermSynonymExcelSheet.close();
        ontologyTermNodePathExcelSheet.close();
        excelWriter.close();
    }

    private static Entity createOntologyTermEntity(String ontologyTernMane, String ontologyTermIri, String ontology, String synonym, String nodePath, String generatedId) {
        MapEntity mapEntity = new MapEntity();
        mapEntity.set("id", (Object)generatedId);
        mapEntity.set("ontologyTermName", (Object)ontologyTernMane);
        mapEntity.set("ontologyTermIRI", (Object)ontologyTermIri);
        mapEntity.set("ontology", (Object)ontology);
        mapEntity.set("ontologyTermSynonym", (Object)synonym);
        mapEntity.set("nodePath", (Object)nodePath);
        return mapEntity;
    }

    private static Entity createOntologyEntity(String codeSystem, String generatedId) {
        MapEntity mapEntity = new MapEntity();
        mapEntity.set("ontologyIRI", (Object)codeSystem);
        mapEntity.set("ontologyName", (Object)codeSystem);
        mapEntity.set("id", (Object)generatedId);
        return mapEntity;
    }

    private static Entity createOntologyNodePathEntity(String nodePath, boolean isTop, String generatedId) {
        MapEntity mapEntity = new MapEntity();
        mapEntity.set("nodePath", (Object)nodePath);
        mapEntity.set("root", (Object)isTop);
        mapEntity.set("id", (Object)generatedId);
        return mapEntity;
    }

    private static Entity createOntologyTermSynonymEntity(String synonym, String generatedId) {
        MapEntity mapEntity = new MapEntity();
        mapEntity.set("ontologyTermSynonym", (Object)synonym);
        mapEntity.set("id", (Object)generatedId);
        return mapEntity;
    }

    private static String createLifelinesCodeEmxFileName(File lifeLinesCodeFile) {
        String lifelinesCodeFileName = lifeLinesCodeFile.getName();
        StringBuilder lifeLinesCodeEmxFileName = new StringBuilder();
        if (lifelinesCodeFileName.toLowerCase().endsWith(ExcelWriter.FileFormat.XLS.toString().toLowerCase())) {
            lifeLinesCodeEmxFileName.append(lifelinesCodeFileName.toLowerCase().replaceAll(ExcelWriter.FileFormat.XLS.toString().toLowerCase(), ""));
        } else if (lifelinesCodeFileName.toLowerCase().endsWith(ExcelWriter.FileFormat.XLSX.toString().toLowerCase())) {
            lifeLinesCodeEmxFileName.append(lifelinesCodeFileName.toLowerCase().replaceAll(ExcelWriter.FileFormat.XLSX.toString().toLowerCase(), ""));
        }
        lifeLinesCodeEmxFileName.append("EMX.").append(ExcelWriter.FileFormat.XLS.toString().toLowerCase());
        return lifeLinesCodeEmxFileName.toString();
    }
}

