/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology.importer;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.molgenis.data.DataService;
import org.molgenis.data.DatabaseAction;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.FileRepositoryCollectionFactory;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.Repository;
import org.molgenis.data.RepositoryCollection;
import org.molgenis.data.elasticsearch.SearchService;
import org.molgenis.data.importer.EntitiesValidationReportImpl;
import org.molgenis.data.importer.ImportService;
import org.molgenis.data.support.GenericImporterExtensions;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.framework.db.EntitiesValidationReport;
import org.molgenis.framework.db.EntityImportReport;
import org.molgenis.security.permission.PermissionSystemService;
import org.molgenis.util.FileStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OntologyImportService
implements ImportService {
    private final DataService dataService;
    private final SearchService searchService;
    private final PermissionSystemService permissionSystemService;
    @Autowired
    private FileStore fileStore;

    @Autowired
    public OntologyImportService(FileRepositoryCollectionFactory fileRepositoryCollectionFactory, DataService dataService, SearchService searchService, PermissionSystemService permissionSystemService) {
        if (fileRepositoryCollectionFactory == null) {
            throw new IllegalArgumentException("fileRepositoryCollectionFactory is null");
        }
        if (dataService == null) {
            throw new IllegalArgumentException("dataservice is null");
        }
        if (searchService == null) {
            throw new IllegalArgumentException("seachservice is null");
        }
        if (permissionSystemService == null) {
            throw new IllegalArgumentException("permissionSystemService is null");
        }
        this.dataService = dataService;
        this.searchService = searchService;
        this.permissionSystemService = permissionSystemService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public EntityImportReport doImport(RepositoryCollection source, DatabaseAction databaseAction, String defaultPackage) {
        if (databaseAction != DatabaseAction.ADD) {
            throw new IllegalArgumentException("Only ADD is supported");
        }
        ArrayList addedEntities = Lists.newArrayList();
        EntityImportReport report = new EntityImportReport();
        try {
            for (String entityNameToImport : source.getEntityNames()) {
                Repository repo = source.getRepository(entityNameToImport);
                try {
                    report = new EntityImportReport();
                    Repository crudRepository = this.dataService.getRepository(entityNameToImport);
                    crudRepository.add((Iterable)repo);
                    List entityNames = addedEntities.stream().map(emd -> emd.getName()).collect(Collectors.toList());
                    this.permissionSystemService.giveUserEntityAndMenuPermissions(SecurityContextHolder.getContext(), entityNames);
                    int count = 1;
                    for (String entityName : entityNames) {
                        report.addEntityCount(entityName, count++);
                    }
                }
                finally {
                    IOUtils.closeQuietly((Closeable)repo);
                }
            }
        }
        catch (Exception e) {
            for (EntityMetaData emd2 : addedEntities) {
                if (this.dataService.hasRepository(emd2.getName())) {
                    this.dataService.deleteAll(emd2.getName());
                }
                if (!this.searchService.hasMapping(emd2)) continue;
                this.searchService.delete(emd2.getName());
            }
            throw new MolgenisDataException((Throwable)e);
        }
        return report;
    }

    public EntitiesValidationReport validateImport(File file, RepositoryCollection source) {
        EntitiesValidationReportImpl report = new EntitiesValidationReportImpl();
        if (source.getRepository("Ontology_Ontology") == null) {
            throw new MolgenisDataException("Exception Repository [Ontology_Ontology] is missing");
        }
        boolean ontologyExists = false;
        for (Entity ontologyEntity : source.getRepository("Ontology_Ontology")) {
            String ontologyIRI = ontologyEntity.getString("ontologyIRI");
            String ontologyName = ontologyEntity.getString("ontologyName");
            Entity ontologyQueryEntity = this.dataService.findOne("Ontology_Ontology", new QueryImpl().eq("ontologyIRI", (Object)ontologyIRI).or().eq("ontologyName", (Object)ontologyName));
            ontologyExists = ontologyQueryEntity != null;
        }
        for (String entityName : source.getEntityNames()) {
            report.getSheetsImportable().put(entityName, !ontologyExists);
        }
        return report;
    }

    public boolean canImport(File file, RepositoryCollection source) {
        for (String extension : GenericImporterExtensions.getOntology()) {
            if (!file.getName().toLowerCase().endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    public int getOrder() {
        return 10;
    }

    public List<DatabaseAction> getSupportedDatabaseActions() {
        return Lists.newArrayList((Object[])new DatabaseAction[]{DatabaseAction.ADD});
    }

    public boolean getMustChangeEntityName() {
        return false;
    }

    public Set<String> getSupportedFileExtensions() {
        return GenericImporterExtensions.getOntology();
    }
}

