/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology;

import org.molgenis.data.DataService;
import org.molgenis.data.elasticsearch.SearchService;
import org.molgenis.ontology.core.meta.OntologyMetaData;
import org.molgenis.ontology.core.meta.OntologyTermDynamicAnnotationMetaData;
import org.molgenis.ontology.core.meta.OntologyTermMetaData;
import org.molgenis.ontology.core.meta.OntologyTermNodePathMetaData;
import org.molgenis.ontology.core.meta.OntologyTermSynonymMetaData;
import org.molgenis.ontology.matching.MatchInputTermBatchService;
import org.molgenis.ontology.matching.MatchingTaskContentEntityMetaData;
import org.molgenis.ontology.matching.MatchingTaskEntityMetaData;
import org.molgenis.ontology.matching.OntologyService;
import org.molgenis.ontology.matching.OntologyServiceImpl;
import org.molgenis.ontology.matching.UploadProgress;
import org.molgenis.ontology.roc.InformationContentService;
import org.molgenis.ontology.roc.MatchQualityRocService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OntologyConfiguration {
    @Autowired
    private SearchService searchService;
    @Autowired
    private DataService dataService;

    @Bean
    public OntologyMetaData ontologyMetaData() {
        return OntologyMetaData.INSTANCE;
    }

    @Bean
    public OntologyTermSynonymMetaData ontologyTermSynonymMetaData() {
        return OntologyTermSynonymMetaData.INSTANCE;
    }

    @Bean
    public OntologyTermDynamicAnnotationMetaData ontologyTermDynamicAnnotationMetaData() {
        return OntologyTermDynamicAnnotationMetaData.INSTANCE;
    }

    @Bean
    public OntologyTermNodePathMetaData ontologyTermNodePathMetaData() {
        return OntologyTermNodePathMetaData.INSTANCE;
    }

    @Bean
    public OntologyTermMetaData ontologyTermMetaData() {
        return OntologyTermMetaData.INSTANCE;
    }

    @Bean
    public MatchingTaskEntityMetaData matchingTaskEntityMetaData() {
        return MatchingTaskEntityMetaData.INSTANCE;
    }

    @Bean
    public MatchingTaskContentEntityMetaData matchingTaskContentEntityMetaData() {
        return MatchingTaskContentEntityMetaData.INSTANCE;
    }

    @Bean
    public OntologyService ontologyMatchingService() {
        return new OntologyServiceImpl(this.dataService, this.searchService, this.informationContentService());
    }

    @Bean
    public MatchInputTermBatchService processInputTermService() {
        return new MatchInputTermBatchService(this.dataService, this.uploadProgress(), this.ontologyMatchingService());
    }

    @Bean
    public UploadProgress uploadProgress() {
        return new UploadProgress();
    }

    @Bean
    public MatchQualityRocService matchQualityRocService() {
        return new MatchQualityRocService(this.dataService, this.ontologyMatchingService());
    }

    @Bean
    public InformationContentService informationContentService() {
        return new InformationContentService(this.dataService);
    }

    public OntologyConfiguration() {
        System.setProperty("jdk.xml.entityExpansionLimit", "1280000");
    }
}

