/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology.importer.repository;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeTraverser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.formula.eval.NotImplementedException;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.IdGenerator;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.Repository;
import org.molgenis.data.mem.InMemoryRepository;
import org.molgenis.data.processor.CellProcessor;
import org.molgenis.data.support.FileRepositoryCollection;
import org.molgenis.data.support.GenericImporterExtensions;
import org.molgenis.data.support.MapEntity;
import org.molgenis.data.support.UuidGenerator;
import org.molgenis.ontology.core.meta.OntologyMetaData;
import org.molgenis.ontology.core.meta.OntologyTermDynamicAnnotationMetaData;
import org.molgenis.ontology.core.meta.OntologyTermMetaData;
import org.molgenis.ontology.core.meta.OntologyTermNodePathMetaData;
import org.molgenis.ontology.core.meta.OntologyTermSynonymMetaData;
import org.molgenis.ontology.utils.OWLClassContainer;
import org.molgenis.ontology.utils.OntologyLoader;
import org.molgenis.ontology.utils.ZipFileUtil;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;

public class OntologyRepositoryCollection
extends FileRepositoryCollection {
    private static final String PSEUDO_ROOT_CLASS_NODEPATH = "0[0]";
    private static final String PSEUDO_ROOT_CLASS_LABEL = "top";
    private final IdGenerator idGenerator = new UuidGenerator();
    private final Repository ontologyRepository = new InMemoryRepository((EntityMetaData)OntologyMetaData.INSTANCE);
    private final Repository nodePathRepository = new InMemoryRepository((EntityMetaData)OntologyTermNodePathMetaData.INSTANCE);
    private final Repository ontologyTermRepository = new InMemoryRepository((EntityMetaData)OntologyTermMetaData.INSTANCE);
    private final Repository annotationRepository = new InMemoryRepository((EntityMetaData)OntologyTermDynamicAnnotationMetaData.INSTANCE);
    private final Repository synonymRepository = new InMemoryRepository((EntityMetaData)OntologyTermSynonymMetaData.INSTANCE);
    private Map<String, Repository> repositories = ImmutableMap.of((Object)"Ontology_OntologyTermDynamicAnnotation", (Object)this.annotationRepository, (Object)"Ontology_OntologyTermSynonym", (Object)this.synonymRepository, (Object)"Ontology_OntologyTermNodePath", (Object)this.nodePathRepository, (Object)"Ontology_Ontology", (Object)this.ontologyRepository, (Object)"Ontology_OntologyTerm", (Object)this.ontologyTermRepository);
    private final OntologyLoader loader;
    private final Multimap<String, Entity> nodePathsPerOntologyTerm = ArrayListMultimap.create();
    private Entity ontologyEntity;

    public OntologyRepositoryCollection(File file) throws OWLOntologyCreationException, FileNotFoundException, IOException {
        super(GenericImporterExtensions.getOntology(), new CellProcessor[0]);
        if (file == null) {
            throw new IllegalArgumentException("file is null");
        }
        String name = file.getName();
        if (name.endsWith(GenericImporterExtensions.OBO_ZIP.toString())) {
            name = name.substring(0, name.lastIndexOf('.' + GenericImporterExtensions.OBO_ZIP.toString())).replace('.', '_');
        } else if (name.endsWith(GenericImporterExtensions.OWL_ZIP.toString())) {
            name = name.substring(0, name.lastIndexOf('.' + GenericImporterExtensions.OWL_ZIP.toString())).replace('.', '_');
        } else {
            throw new IllegalArgumentException("Not a obo.zip or owl.zip file [" + file.getName() + "]");
        }
        List<File> uploadedFiles = ZipFileUtil.unzip(file);
        this.loader = new OntologyLoader(name, uploadedFiles.get(0));
        this.createOntology();
        this.createNodePaths();
        this.createOntologyTerms();
    }

    private void createOntology() {
        this.ontologyEntity = new MapEntity((EntityMetaData)OntologyMetaData.INSTANCE);
        this.ontologyEntity.set("id", (Object)this.idGenerator.generateId());
        this.ontologyEntity.set("ontologyIRI", (Object)this.loader.getOntologyIRI());
        this.ontologyEntity.set("ontologyName", (Object)this.loader.getOntologyName());
        this.ontologyRepository.add(this.ontologyEntity);
    }

    private void createNodePaths() {
        TreeTraverser<OWLClassContainer> traverser = new TreeTraverser<OWLClassContainer>(){

            public Iterable<OWLClassContainer> children(OWLClassContainer container) {
                int count = 0;
                ArrayList<OWLClassContainer> containers = new ArrayList<OWLClassContainer>();
                for (OWLClass childClass : OntologyRepositoryCollection.this.loader.getChildClass(container.getOwlClass())) {
                    containers.add(new OWLClassContainer(childClass, OntologyRepositoryCollection.this.constructNodePath(container.getNodePath(), count), false));
                    ++count;
                }
                return containers;
            }
        };
        OWLClass pseudoRootClass = this.loader.createClass(PSEUDO_ROOT_CLASS_LABEL, this.loader.getRootClasses());
        for (OWLClassContainer container : traverser.preOrderTraversal((Object)new OWLClassContainer(pseudoRootClass, PSEUDO_ROOT_CLASS_NODEPATH, true))) {
            OWLClass ontologyTerm = container.getOwlClass();
            String ontologyTermNodePath = container.getNodePath();
            String ontologyTermIRI = ontologyTerm.getIRI().toString();
            Entity nodePathEntity = this.createNodePathEntity(container, ontologyTermNodePath);
            this.nodePathsPerOntologyTerm.put((Object)ontologyTermIRI, (Object)nodePathEntity);
        }
    }

    private void createOntologyTerms() {
        this.loader.getAllclasses().forEach(this::createOntologyTerm);
    }

    private Entity createOntologyTerm(OWLClass ontologyTerm) {
        String ontologyTermIRI = ontologyTerm.getIRI().toString();
        String ontologyTermName = this.loader.getLabel((OWLEntity)ontologyTerm);
        MapEntity entity = new MapEntity((EntityMetaData)OntologyTermMetaData.INSTANCE);
        entity.set("id", (Object)this.idGenerator.generateId());
        entity.set("ontologyTermIRI", (Object)ontologyTermIRI);
        entity.set("ontologyTermName", (Object)ontologyTermName);
        entity.set("ontologyTermSynonym", this.createSynonyms(ontologyTerm));
        entity.set("ontologyTermDynamicAnnotation", this.createDynamicAnnotations(ontologyTerm));
        entity.set("nodePath", (Object)this.nodePathsPerOntologyTerm.get((Object)ontologyTermIRI));
        entity.set("ontology", (Object)this.ontologyEntity);
        this.ontologyTermRepository.add((Entity)entity);
        return entity;
    }

    private List<Entity> createSynonyms(OWLClass ontologyTerm) {
        return this.loader.getSynonyms(ontologyTerm).stream().map(this::createSynonym).collect(Collectors.toList());
    }

    private Entity createSynonym(String synonym) {
        MapEntity entity = new MapEntity((EntityMetaData)OntologyTermSynonymMetaData.INSTANCE);
        entity.set("id", (Object)this.idGenerator.generateId());
        entity.set("ontologyTermSynonym", (Object)synonym);
        this.synonymRepository.add((Entity)entity);
        return entity;
    }

    private List<Entity> createDynamicAnnotations(OWLClass term) {
        return this.loader.getDatabaseIds(term).stream().map(this::createDynamicAnnotation).collect(Collectors.toList());
    }

    private Entity createDynamicAnnotation(String label) {
        MapEntity entity = new MapEntity((EntityMetaData)OntologyTermDynamicAnnotationMetaData.INSTANCE);
        entity.set("id", (Object)this.idGenerator.generateId());
        String[] fragments = label.split(":");
        entity.set("name", (Object)fragments[0]);
        entity.set("value", (Object)fragments[1]);
        entity.set("label", (Object)label);
        this.annotationRepository.add((Entity)entity);
        return entity;
    }

    private String constructNodePath(String parentNodePath, int currentPosition) {
        StringBuilder nodePathStringBuilder = new StringBuilder();
        if (!StringUtils.isEmpty((CharSequence)parentNodePath)) {
            nodePathStringBuilder.append(parentNodePath).append('.');
        }
        nodePathStringBuilder.append(currentPosition).append('[').append(nodePathStringBuilder.toString().split("\\.").length - 1).append(']');
        return nodePathStringBuilder.toString();
    }

    private Entity createNodePathEntity(OWLClassContainer container, String ontologyTermNodePath) {
        MapEntity entity = new MapEntity((EntityMetaData)OntologyTermNodePathMetaData.INSTANCE);
        entity.set("id", (Object)this.idGenerator.generateId());
        entity.set("nodePath", (Object)ontologyTermNodePath);
        entity.set("root", (Object)container.isRoot());
        this.nodePathRepository.add((Entity)entity);
        return entity;
    }

    public Iterable<String> getEntityNames() {
        return this.repositories.keySet();
    }

    public String getName() {
        throw new NotImplementedException("Not implemented");
    }

    public Repository addEntityMeta(EntityMetaData entityMeta) {
        throw new NotImplementedException("Not implemented");
    }

    public Iterator<Repository> iterator() {
        throw new NotImplementedException("Not implemented");
    }

    public Repository getRepository(String name) {
        if (!this.repositories.containsKey(name)) {
            throw new MolgenisDataException("Unknown entity name [" + name + "]");
        }
        return this.repositories.get(name);
    }

    public boolean hasRepository(String name) {
        if (null == name) {
            return false;
        }
        Iterator<String> entityNames = this.getEntityNames().iterator();
        while (entityNames.hasNext()) {
            if (!entityNames.next().equals(name)) continue;
            return true;
        }
        return false;
    }
}

