/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology.roc;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.elasticsearch.common.collect.Iterables;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.excel.ExcelRepositoryCollection;
import org.molgenis.data.excel.ExcelSheetWriter;
import org.molgenis.data.excel.ExcelWriter;
import org.molgenis.data.support.MapEntity;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.ontology.beans.OntologyServiceResult;
import org.molgenis.ontology.matching.OntologyService;
import org.molgenis.ontology.utils.OntologyServiceUtil;
import org.molgenis.security.user.UserAccountService;
import org.molgenis.util.FileStore;
import org.springframework.beans.factory.annotation.Autowired;

public class MatchQualityRocService {
    @Autowired
    private FileStore fileStore;
    @Autowired
    private UserAccountService userAccountService;
    private final DataService dataService;
    private final OntologyService ontologyService;

    @Autowired
    public MatchQualityRocService(DataService dataService, OntologyService ontologyService) {
        if (dataService == null) {
            throw new IllegalArgumentException("DataService cannot be null!");
        }
        if (ontologyService == null) {
            throw new IllegalArgumentException("OntologyMatchingService cannot be null!");
        }
        this.dataService = dataService;
        this.ontologyService = ontologyService;
    }

    public Map<String, Object> calculateROC(String matchingTaskIdentifier) throws IOException, InvalidFormatException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((CharSequence)matchingTaskIdentifier)) {
            File file = this.fileStore.getFile(this.createFileName());
            Entity matchingTask = this.dataService.findOne("MatchingTask", new QueryImpl().eq("Identifier", (Object)matchingTaskIdentifier));
            if (matchingTask != null) {
                String entityName = matchingTask.getString("Identifier");
                String codeSystem = matchingTask.getString("Code_system");
                double threshold = matchingTask.getDouble("Threshold");
                long totalNumberOfTerms = this.dataService.count("MatchingTaskContent", new QueryImpl().eq("Ref_entity", (Object)matchingTaskIdentifier));
                Iterable validatedMatchEntities = this.dataService.findAll("MatchingTaskContent", new QueryImpl().eq("Ref_entity", (Object)entityName).and().nest().eq("Validated", (Object)true).or().ge("Score", (Object)threshold).unnest());
                ArrayList<Entity> resultEntities = new ArrayList<Entity>();
                for (Entity validatedMatchEntity : validatedMatchEntities) {
                    String matchedCodeIdentifier = validatedMatchEntity.getString("Match_term");
                    boolean manualMatchExists = matchedCodeIdentifier != null && !matchedCodeIdentifier.equals("NULL");
                    OntologyServiceResult searchResult = this.ontologyService.search(codeSystem, this.getInputTerm(validatedMatchEntity, entityName));
                    long totalNumber = searchResult.getTotalHitCount();
                    int rank = 0;
                    if (manualMatchExists) {
                        for (Map<String, Object> candidateMatch : searchResult.getOntologyTerms()) {
                            ++rank;
                            String candidateMatchIdentifier = candidateMatch.get("ontologyTermIRI").toString();
                            if (!candidateMatchIdentifier.equals(matchedCodeIdentifier)) continue;
                            break;
                        }
                    }
                    MapEntity entity = new MapEntity();
                    entity.set("Total", (Object)totalNumber);
                    entity.set("Rank", (Object)rank);
                    entity.set("Match", (Object)manualMatchExists);
                    resultEntities.add((Entity)entity);
                }
                ExcelWriter excelWriter = new ExcelWriter(file, ExcelWriter.FileFormat.XLS);
                this.createRocExcelSheet(resultEntities, entityName, excelWriter);
                excelWriter.close();
                ExcelRepositoryCollection excelRepositoryCollection = new ExcelRepositoryCollection(file);
                data.put("entityName", matchingTaskIdentifier);
                data.put("rocfilePath", file.getAbsolutePath());
                data.put("totalNumber", totalNumberOfTerms);
                data.put("validatedNumber", Iterables.size((Iterable)validatedMatchEntities));
                data.put("rocEntities", OntologyServiceUtil.getEntityAsMap((Iterable<? extends Entity>)excelRepositoryCollection.getSheet(0)));
            }
        }
        return data;
    }

    private void createRocExcelSheet(Iterable<Entity> resultEntities, String entityName, ExcelWriter excelWriter) throws IOException {
        ExcelSheetWriter createWritable = excelWriter.createWritable(entityName, Arrays.asList("Cutoff", "TPR", "FPR"));
        DecimalFormat df = new DecimalFormat("##.###", new DecimalFormatSymbols(Locale.ENGLISH));
        for (int cutOff = 1; cutOff <= 500; ++cutOff) {
            int totalPositives = 0;
            int totalNegatives = 0;
            int retrievedPositives = 0;
            int falsePositives = 0;
            int totalRetrieved = 0;
            for (Entity entity : resultEntities) {
                Integer rank = entity.getInt("Rank");
                Integer total = entity.getInt("Total");
                boolean manualMatchExists = entity.getBoolean("Match");
                if (manualMatchExists) {
                    ++totalPositives;
                    totalNegatives += total - 1;
                } else {
                    totalNegatives += total.intValue();
                }
                int n = totalRetrieved = cutOff <= total ? cutOff : total;
                if (!manualMatchExists) {
                    falsePositives += totalRetrieved;
                    continue;
                }
                if (rank <= cutOff) {
                    ++retrievedPositives;
                    falsePositives += totalRetrieved - 1;
                    continue;
                }
                falsePositives += totalRetrieved;
            }
            if (totalPositives == 0 || totalNegatives == 0 || totalRetrieved == 0) continue;
            String truePositiveRate = df.format((double)retrievedPositives / (double)totalPositives);
            String falsePositiveRate = df.format((double)falsePositives / (double)totalNegatives);
            String precision = df.format((double)retrievedPositives / (double)totalRetrieved);
            MapEntity entity = new MapEntity();
            entity.set("Cutoff", (Object)cutOff);
            entity.set("TPR", (Object)truePositiveRate);
            entity.set("FPR", (Object)falsePositiveRate);
            entity.set("Precision", (Object)precision);
            createWritable.add((Entity)entity);
        }
        createWritable.close();
    }

    private String getInputTerm(Entity validatedMatchEntity, String entityName) {
        String termIdentifier = validatedMatchEntity.getString("Input_term");
        Entity termEntity = this.dataService.findOne(entityName, new QueryImpl().eq("Identifier", (Object)termIdentifier));
        return termEntity.getString("Name");
    }

    private String createFileName() {
        Date date = new Date();
        return this.userAccountService.getCurrentUser().getUsername() + "_" + date.getTime() + ".xls";
    }
}

