/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology.matching;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.common.collect.Iterables;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.QueryRule;
import org.molgenis.data.elasticsearch.SearchService;
import org.molgenis.data.semanticsearch.string.NGramDistanceAlgorithm;
import org.molgenis.data.support.MapEntity;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.ontology.beans.Ontology;
import org.molgenis.ontology.beans.OntologyImpl;
import org.molgenis.ontology.beans.OntologyServiceResult;
import org.molgenis.ontology.beans.OntologyTerm;
import org.molgenis.ontology.beans.OntologyTermImpl;
import org.molgenis.ontology.matching.OntologyService;
import org.molgenis.ontology.roc.InformationContentService;
import org.molgenis.ontology.utils.OntologyServiceUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.tartarus.snowball.ext.PorterStemmer;

public class OntologyServiceImpl
implements OntologyService {
    private static final List<String> ELASTICSEARCH_RESERVED_WORDS = Arrays.asList("or", "and", "if");
    private static final String NON_WORD_SEPARATOR = "[^a-zA-Z0-9]";
    private static final String ILLEGAL_CHARACTERS_PATTERN = "[^a-zA-Z0-9 ]";
    private static final String FUZZY_MATCH_SIMILARITY = "~0.8";
    private static final String SINGLE_WHITESPACE = " ";
    private static final int MAX_NUMBER_MATCHES = 500;
    public static final String SIGNIFICANT_VALUE = "Significant";
    public static final Character DEFAULT_SEPARATOR = Character.valueOf(';');
    public static final String DEFAULT_MATCHING_NAME_FIELD = "Name";
    public static final String DEFAULT_MATCHING_SYNONYM_FIELD = "Synonym";
    public static final String DEFAULT_MATCHING_IDENTIFIER = "Identifier";
    public static final String SCORE = "Score";
    public static final String COMBINED_SCORE = "Combined_Score";
    private final PorterStemmer stemmer = new PorterStemmer();
    private final DataService dataService;
    private final SearchService searchService;
    private final InformationContentService informationContentService;

    @Autowired
    public OntologyServiceImpl(DataService dataService, SearchService searchService, InformationContentService informationContentService) {
        if (dataService == null) {
            throw new IllegalArgumentException("DataService is null");
        }
        if (searchService == null) {
            throw new IllegalArgumentException("SearchService is null");
        }
        if (informationContentService == null) {
            throw new IllegalArgumentException("InformationContentService is null");
        }
        this.dataService = dataService;
        this.searchService = searchService;
        this.informationContentService = informationContentService;
    }

    @Override
    public Iterable<Ontology> getAllOntologies() {
        return null;
    }

    @Override
    public Iterable<Entity> getAllOntologyEntities() {
        return this.dataService.findAll("Ontology_Ontology");
    }

    @Override
    public Ontology getOntology(String ontologyIri) {
        Entity ontologyEntity = this.getOntologyEntity(ontologyIri);
        return ontologyEntity == null ? null : new OntologyImpl(ontologyEntity);
    }

    @Override
    public Entity getOntologyEntity(String ontologyIri) {
        return this.dataService.findOne("Ontology_Ontology", new QueryImpl().eq("ontologyIRI", (Object)ontologyIri));
    }

    @Override
    public Iterable<OntologyTerm> findOntologyTerms(String queryTerm, String ontologyIri) {
        return null;
    }

    @Override
    public OntologyTerm getOntologyTerm(String ontologyTermIri, String ontologyIri) {
        Entity ontologyTermEntity = this.getOntologyTermEntity(ontologyTermIri, ontologyIri);
        return ontologyTermEntity == null ? null : new OntologyTermImpl(ontologyTermEntity);
    }

    @Override
    public Entity getOntologyTermEntity(String ontologyTermIri, String ontologyIri) {
        Entity ontologyEntity = this.getOntologyEntity(ontologyIri);
        if (ontologyEntity != null) {
            return this.dataService.findOne("Ontology_OntologyTerm", new QueryImpl().eq("ontologyTermIRI", (Object)ontologyTermIri).and().eq("ontology", (Object)ontologyEntity));
        }
        return null;
    }

    @Override
    public List<String> getOntologyTermSynonyms(String ontologyTermIri, String ontologyIri) {
        return null;
    }

    @Override
    public Iterable<OntologyTerm> getAllOntologyTerms(String ontologyIri) {
        return null;
    }

    @Override
    public Iterable<Entity> getAllOntologyTermEntities(String ontologyIri) {
        return null;
    }

    @Override
    public Iterable<OntologyTerm> getRootOntologyTerms(String ontologyIri) {
        return null;
    }

    @Override
    public Iterable<Entity> getRootOntologyTermEntities(String ontologyIri) {
        return null;
    }

    @Override
    public Iterable<OntologyTerm> getChildOntologyTerms(String ontologyIri, String ontologyTermIri) {
        return null;
    }

    @Override
    public Iterable<Entity> getChildOntologyTermEntities(String ontologyIri, String ontologyTermIri) {
        return null;
    }

    @Override
    public OntologyServiceResult searchEntity(String ontologyIri, Entity inputEntity) {
        Entity ontologyEntity = this.getOntologyEntity(ontologyIri);
        if (ontologyEntity == null) {
            throw new IllegalArgumentException("Ontology IRI " + ontologyIri + " does not exist in the database!");
        }
        ArrayList<MapEntity> relevantEntities = new ArrayList<MapEntity>();
        ArrayList<QueryRule> rulesForOntologyTermFields = new ArrayList<QueryRule>();
        ArrayList<QueryRule> rulesForOtherFields = new ArrayList<QueryRule>();
        for (String attributeName : inputEntity.getAttributeNames()) {
            if (!StringUtils.isNotEmpty((CharSequence)inputEntity.getString(attributeName)) || attributeName.equalsIgnoreCase(DEFAULT_MATCHING_IDENTIFIER)) continue;
            if (DEFAULT_MATCHING_NAME_FIELD.equalsIgnoreCase(attributeName) || attributeName.toLowerCase().startsWith(DEFAULT_MATCHING_SYNONYM_FIELD.toLowerCase())) {
                String medicalStemProxy = this.fuzzyMatchQuerySyntax(inputEntity.getString(attributeName));
                if (!StringUtils.isNotEmpty((CharSequence)medicalStemProxy)) continue;
                rulesForOntologyTermFields.add(new QueryRule("ontologyTermSynonym", QueryRule.Operator.FUZZY_MATCH, medicalStemProxy));
                continue;
            }
            if (!StringUtils.isNotEmpty((CharSequence)inputEntity.getString(attributeName))) continue;
            rulesForOtherFields.add(new QueryRule(attributeName, QueryRule.Operator.EQUALS, inputEntity.getString(attributeName)));
        }
        ArrayList<QueryRule> combinedRules = new ArrayList<QueryRule>();
        if (rulesForOntologyTermFields.size() > 0) {
            QueryRule disMaxQuery_1 = new QueryRule(rulesForOntologyTermFields);
            disMaxQuery_1.setOperator(QueryRule.Operator.DIS_MAX);
            combinedRules.add(disMaxQuery_1);
        }
        if (rulesForOtherFields.size() > 0) {
            QueryRule disMaxQuery_2 = new QueryRule(rulesForOtherFields);
            disMaxQuery_2.setOperator(QueryRule.Operator.DIS_MAX);
            combinedRules.add(disMaxQuery_2);
        }
        if (combinedRules.size() > 0) {
            QueryRule queryRule = new QueryRule(combinedRules);
            queryRule.setOperator(QueryRule.Operator.DIS_MAX);
            List<QueryRule> finalQueryRules = Arrays.asList(new QueryRule("ontology", QueryRule.Operator.EQUALS, (Object)ontologyEntity), new QueryRule(QueryRule.Operator.AND), queryRule);
            EntityMetaData entityMetaData = this.dataService.getEntityMetaData("Ontology_OntologyTerm");
            for (Entity entity : this.searchService.search(new QueryImpl(finalQueryRules).pageSize(500), entityMetaData)) {
                double maxNgramScore = 0.0;
                double maxNgramIDFScore = 0.0;
                for (String inputAttrName : inputEntity.getAttributeNames()) {
                    String queryString = inputEntity.getString(inputAttrName);
                    if (!StringUtils.isNotEmpty((CharSequence)queryString) || !DEFAULT_MATCHING_NAME_FIELD.equalsIgnoreCase(inputAttrName) && !inputAttrName.toLowerCase().startsWith(DEFAULT_MATCHING_SYNONYM_FIELD.toLowerCase())) continue;
                    Entity topMatchedSynonymEntity = this.calculateNGramOTSynonyms(ontologyIri, queryString, entity);
                    if (maxNgramScore < topMatchedSynonymEntity.getDouble(SCORE)) {
                        maxNgramScore = topMatchedSynonymEntity.getDouble(SCORE);
                    }
                    if (!(maxNgramIDFScore < topMatchedSynonymEntity.getDouble(COMBINED_SCORE))) continue;
                    maxNgramIDFScore = topMatchedSynonymEntity.getDouble(COMBINED_SCORE);
                }
                MapEntity mapEntity = new MapEntity();
                for (String attributeName : entity.getAttributeNames()) {
                    mapEntity.set(attributeName, entity.get(attributeName));
                }
                mapEntity.set(SCORE, (Object)maxNgramScore);
                mapEntity.set(COMBINED_SCORE, (Object)maxNgramIDFScore);
                relevantEntities.add(mapEntity);
            }
        }
        Collections.sort(relevantEntities, new Comparator<Entity>(){

            @Override
            public int compare(Entity entity1, Entity entity2) {
                return entity2.getDouble(OntologyServiceImpl.COMBINED_SCORE).compareTo(entity1.getDouble(OntologyServiceImpl.COMBINED_SCORE));
            }
        });
        return new OntologyServiceResult(OntologyServiceUtil.getEntityAsMap(inputEntity), (Iterable<? extends Entity>)relevantEntities, (long)relevantEntities.size());
    }

    @Override
    public OntologyServiceResult search(String ontologyUrl, String queryString) {
        MapEntity entity = new MapEntity();
        entity.set(DEFAULT_MATCHING_NAME_FIELD, (Object)queryString);
        return this.searchEntity(ontologyUrl, (Entity)entity);
    }

    private Entity calculateNGramOTSynonyms(String ontologyIri, final String queryString, Entity entity) {
        Iterable entities = entity.getEntities("ontologyTermSynonym");
        if (Iterables.size((Iterable)entities) > 0) {
            ImmutableList synonymEntities = FluentIterable.from((Iterable)entities).transform((Function)new Function<Entity, MapEntity>(){

                public MapEntity apply(Entity input) {
                    MapEntity mapEntity = new MapEntity();
                    for (String attrName : input.getAttributeNames()) {
                        mapEntity.set(attrName, input.get(attrName));
                    }
                    String ontologyTermSynonym = OntologyServiceImpl.this.removeIllegalCharWithSingleWhiteSpace(input.getString("ontologyTermSynonym"));
                    double score_1 = NGramDistanceAlgorithm.stringMatching((String)queryString, (String)ontologyTermSynonym);
                    mapEntity.set(OntologyServiceImpl.SCORE, (Object)score_1);
                    return mapEntity;
                }
            }).toSortedList((Comparator)new Comparator<MapEntity>(){

                @Override
                public int compare(MapEntity o1, MapEntity o2) {
                    return o2.getDouble(OntologyServiceImpl.SCORE).compareTo(o1.getDouble(OntologyServiceImpl.SCORE));
                }
            });
            Entity topMatchedSynonymEntity = (Entity)synonymEntities.get(0);
            double ngramScore = topMatchedSynonymEntity.getDouble(SCORE);
            String topMatchedSynonym = topMatchedSynonymEntity.getString("ontologyTermSynonym");
            for (int j = 1; j < synonymEntities.size(); ++j) {
                Entity nextMatchedSynonymEntity = (Entity)synonymEntities.get(j);
                String nextMatchedSynonym = nextMatchedSynonymEntity.getString("ontologyTermSynonym");
                StringBuilder tempCombinedSynonym = new StringBuilder().append(topMatchedSynonym).append(SINGLE_WHITESPACE).append(nextMatchedSynonym);
                double newScore = NGramDistanceAlgorithm.stringMatching((String)queryString.replaceAll(ILLEGAL_CHARACTERS_PATTERN, SINGLE_WHITESPACE), (String)tempCombinedSynonym.toString().replaceAll(ILLEGAL_CHARACTERS_PATTERN, SINGLE_WHITESPACE));
                if (!(newScore > ngramScore)) continue;
                ngramScore = newScore;
                topMatchedSynonym = tempCombinedSynonym.toString();
            }
            topMatchedSynonymEntity.set("ontologyTermSynonym", (Object)topMatchedSynonym);
            topMatchedSynonymEntity.set(SCORE, (Object)ngramScore);
            topMatchedSynonymEntity.set(COMBINED_SCORE, (Object)ngramScore);
            Map<String, Double> weightedWordSimilarity = this.informationContentService.redistributedNGramScore(queryString, ontologyIri);
            Set<String> synonymStemmedWordSet = this.informationContentService.createStemmedWordSet(topMatchedSynonym);
            for (String originalWord : this.informationContentService.createStemmedWordSet(queryString)) {
                if (!synonymStemmedWordSet.contains(originalWord) || !weightedWordSimilarity.containsKey(originalWord)) continue;
                topMatchedSynonymEntity.set(COMBINED_SCORE, (Object)(topMatchedSynonymEntity.getDouble(COMBINED_SCORE) + weightedWordSimilarity.get(originalWord)));
            }
            return topMatchedSynonymEntity;
        }
        return null;
    }

    private String fuzzyMatchQuerySyntax(String queryString) {
        StringBuilder stringBuilder = new StringBuilder();
        HashSet uniqueTerms = Sets.newHashSet((Object[])queryString.toLowerCase().trim().split(NON_WORD_SEPARATOR));
        uniqueTerms.removeAll(NGramDistanceAlgorithm.STOPWORDSLIST);
        for (String term : uniqueTerms) {
            if (!StringUtils.isNotEmpty((CharSequence)term.trim()) || ELASTICSEARCH_RESERVED_WORDS.contains(term)) continue;
            this.stemmer.setCurrent(this.removeIllegalCharWithEmptyString(term));
            this.stemmer.stem();
            String afterStem = this.stemmer.getCurrent();
            if (!StringUtils.isNotEmpty((CharSequence)afterStem)) continue;
            stringBuilder.append(afterStem).append(FUZZY_MATCH_SIMILARITY).append(SINGLE_WHITESPACE);
        }
        return stringBuilder.toString().trim();
    }

    public String removeIllegalCharWithSingleWhiteSpace(String string) {
        return string.replaceAll(ILLEGAL_CHARACTERS_PATTERN, SINGLE_WHITESPACE);
    }

    public String removeIllegalCharWithEmptyString(String string) {
        return string.replaceAll(ILLEGAL_CHARACTERS_PATTERN, "");
    }
}

