/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.molgenis.data.Entity;
import org.molgenis.file.FileStore;
import org.molgenis.framework.ui.MolgenisPluginController;
import org.molgenis.ontology.matching.OntologyService;
import org.molgenis.ontology.utils.OntologyServiceUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/plugin/ontologymanager"})
public class OntologyManagerController
extends MolgenisPluginController {
    public static final String ID = "ontologymanager";
    public static final String URI = "/plugin/ontologymanager";
    public static final String ONTOLOGY_MANAGER_PLUGIN = "OntologyManagerPlugin";
    @Autowired
    private FileStore fileStore;
    @Autowired
    private OntologyService ontologyService;

    public OntologyManagerController() {
        super(URI);
    }

    @RequestMapping(method={RequestMethod.GET})
    public String init(Model model) throws Exception {
        return ONTOLOGY_MANAGER_PLUGIN;
    }

    @RequestMapping(value={"/ontology"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<String, Object> getAllOntologies() {
        HashMap<String, Object> results = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> ontologies = new ArrayList<Map<String, Object>>();
        for (Entity entity : this.ontologyService.getAllOntologyEntities()) {
            ontologies.add(OntologyServiceUtil.getEntityAsMap(entity));
        }
        results.put("results", ontologies);
        return results;
    }
}

