/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.elasticsearch.admin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.molgenis.data.DataService;
import org.molgenis.data.MolgenisDataAccessException;
import org.molgenis.data.Repository;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.data.elasticsearch.ElasticsearchService;
import org.molgenis.data.elasticsearch.admin.ElasticsearchIndexManagerService;
import org.molgenis.data.meta.model.EntityType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Service
public class ElasticsearchIndexManagerServiceImpl
implements ElasticsearchIndexManagerService {
    private final DataService dataService;
    private final ElasticsearchService elasticsearchService;

    @Autowired
    public ElasticsearchIndexManagerServiceImpl(DataService dataService, ElasticsearchService elasticsearchService) {
        this.dataService = Objects.requireNonNull(dataService);
        this.elasticsearchService = Objects.requireNonNull(elasticsearchService);
    }

    @Override
    @PreAuthorize(value="hasAnyRole('ROLE_SU, ROLE_PLUGIN_READ_indexmanager')")
    public List<EntityType> getIndexedEntities() {
        ArrayList<EntityType> indexedEntityTypeList = new ArrayList<EntityType>();
        this.dataService.getEntityNames().forEach(entityName -> {
            Repository repository = this.dataService.getRepository(entityName);
            if (repository != null && repository.getCapabilities().contains(RepositoryCapability.INDEXABLE)) {
                indexedEntityTypeList.add(repository.getEntityType());
            }
        });
        Collections.sort(indexedEntityTypeList, (e1, e2) -> e1.getLabel().compareTo(e2.getLabel()));
        return indexedEntityTypeList;
    }

    @Override
    @PreAuthorize(value="hasAnyRole('ROLE_SU')")
    public void rebuildIndex(String entityName) {
        Repository repository = this.dataService.getRepository(entityName);
        if (!repository.getCapabilities().contains(RepositoryCapability.INDEXABLE)) {
            throw new MolgenisDataAccessException("Repository [" + entityName + "] is not an indexed repository");
        }
        this.elasticsearchService.rebuildIndex(repository);
    }
}

