/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology.sorta.repo;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.data.Entity;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.data.csv.CsvRepository;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.processor.CellProcessor;
import org.molgenis.data.processor.LowerCaseProcessor;
import org.molgenis.data.processor.TrimProcessor;
import org.molgenis.data.support.AbstractRepository;
import org.molgenis.data.support.DynamicEntity;
import org.molgenis.ontology.sorta.service.impl.SortaServiceImpl;
import org.molgenis.util.ApplicationContextProvider;

public class SortaCsvRepository
extends AbstractRepository {
    private EntityType entityType = null;
    private final CsvRepository csvRepository;
    private final String entityName;
    private final String entityLabel;
    public static final String ALLOWED_IDENTIFIER = "Identifier";
    private static final List<CellProcessor> LOWERCASE_AND_TRIM = Arrays.asList(new LowerCaseProcessor(), new TrimProcessor());

    public SortaCsvRepository(File file, EntityTypeFactory entityTypeFactory, AttributeFactory attrMetaFactory) {
        this.csvRepository = new CsvRepository(file, entityTypeFactory, attrMetaFactory, LOWERCASE_AND_TRIM, SortaServiceImpl.DEFAULT_SEPARATOR);
        this.entityName = file.getName();
        this.entityLabel = file.getName();
    }

    public SortaCsvRepository(String entityName, String entityLabel, File uploadedFile, EntityTypeFactory entityTypeFactory, AttributeFactory attrMetaFactory) {
        this.csvRepository = new CsvRepository(uploadedFile, entityTypeFactory, attrMetaFactory, LOWERCASE_AND_TRIM, SortaServiceImpl.DEFAULT_SEPARATOR);
        this.entityName = entityName;
        this.entityLabel = entityLabel;
    }

    public EntityType getEntityType() {
        if (this.entityType == null) {
            AttributeFactory attrMetaFactory = (AttributeFactory)ApplicationContextProvider.getApplicationContext().getBean(AttributeFactory.class);
            this.entityType = EntityType.newInstance((EntityType)this.csvRepository.getEntityType(), (EntityType.AttributeCopyMode)EntityType.AttributeCopyMode.DEEP_COPY_ATTRS, (AttributeFactory)attrMetaFactory);
            this.entityType.setName(this.entityName);
            this.entityType.setSimpleName(this.entityName);
            this.entityType.setLabel(this.entityLabel);
            this.entityType.setBackend("PostgreSQL");
            this.entityType.addAttribute(attrMetaFactory.create().setName(ALLOWED_IDENTIFIER).setNillable(false), new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_ID});
            Attribute nameAttribute = this.entityType.getAttribute("Name");
            if (nameAttribute != null) {
                nameAttribute.setLabelAttribute(Boolean.valueOf(true));
            }
        }
        return this.entityType;
    }

    public Iterator<Entity> iterator() {
        final AtomicInteger count = new AtomicInteger(0);
        final Iterator iterator = this.csvRepository.iterator();
        return new Iterator<Entity>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Entity next() {
                Entity entity = (Entity)iterator.next();
                if (StringUtils.isEmpty((CharSequence)entity.getString(SortaCsvRepository.ALLOWED_IDENTIFIER))) {
                    DynamicEntity dynamicEntity = new DynamicEntity(SortaCsvRepository.this.getEntityType());
                    dynamicEntity.set(entity);
                    entity = dynamicEntity;
                    entity.set(SortaCsvRepository.ALLOWED_IDENTIFIER, (Object)String.valueOf(count.incrementAndGet()));
                }
                return entity;
            }
        };
    }

    public Set<RepositoryCapability> getCapabilities() {
        return Collections.emptySet();
    }

    public long count() {
        return this.csvRepository.count();
    }
}

