/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology.importer.repository;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeTraverser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.Repository;
import org.molgenis.data.mem.InMemoryRepository;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.populate.IdGenerator;
import org.molgenis.data.processor.CellProcessor;
import org.molgenis.data.support.FileRepositoryCollection;
import org.molgenis.data.support.GenericImporterExtensions;
import org.molgenis.ontology.core.meta.Ontology;
import org.molgenis.ontology.core.meta.OntologyFactory;
import org.molgenis.ontology.core.meta.OntologyTerm;
import org.molgenis.ontology.core.meta.OntologyTermDynamicAnnotation;
import org.molgenis.ontology.core.meta.OntologyTermDynamicAnnotationFactory;
import org.molgenis.ontology.core.meta.OntologyTermFactory;
import org.molgenis.ontology.core.meta.OntologyTermNodePath;
import org.molgenis.ontology.core.meta.OntologyTermNodePathFactory;
import org.molgenis.ontology.core.meta.OntologyTermSynonym;
import org.molgenis.ontology.core.meta.OntologyTermSynonymFactory;
import org.molgenis.ontology.utils.OWLClassContainer;
import org.molgenis.ontology.utils.OntologyLoader;
import org.molgenis.ontology.utils.ZipFileUtil;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.springframework.beans.factory.annotation.Autowired;

public class OntologyRepositoryCollection
extends FileRepositoryCollection {
    private static final String PSEUDO_ROOT_CLASS_NODEPATH = "0[0]";
    private static final String PSEUDO_ROOT_CLASS_LABEL = "top";
    private final File file;
    private final String fileName;
    @Autowired
    private IdGenerator idGenerator;
    @Autowired
    private OntologyFactory ontologyFactory;
    @Autowired
    private OntologyTermNodePathFactory ontologyTermNodePathFactory;
    @Autowired
    private OntologyTermDynamicAnnotationFactory ontologyTermDynamicAnnotationFactory;
    @Autowired
    private OntologyTermSynonymFactory ontologyTermSynonymFactory;
    @Autowired
    private OntologyTermFactory ontologyTermFactory;
    private Repository<Entity> ontologyRepository;
    private Repository<Entity> nodePathRepository;
    private Repository<Entity> ontologyTermRepository;
    private Repository<Entity> annotationRepository;
    private Repository<Entity> synonymRepository;
    private Map<String, Repository<Entity>> repositories;
    private OntologyLoader loader;
    private Multimap<String, OntologyTermNodePath> nodePathsPerOntologyTerm = ArrayListMultimap.create();
    private Ontology ontologyEntity;

    public OntologyRepositoryCollection(File file) {
        super(GenericImporterExtensions.getOntology(), new CellProcessor[0]);
        this.file = Objects.requireNonNull(file);
        String name = file.getName();
        if (name.endsWith(GenericImporterExtensions.OBO_ZIP.toString())) {
            name = name.substring(0, name.lastIndexOf('.' + GenericImporterExtensions.OBO_ZIP.toString())).replace('.', '_');
        } else if (name.endsWith(GenericImporterExtensions.OWL_ZIP.toString())) {
            name = name.substring(0, name.lastIndexOf('.' + GenericImporterExtensions.OWL_ZIP.toString())).replace('.', '_');
        } else {
            throw new IllegalArgumentException(String.format("Not a obo.zip or owl.zip file [%s]", file.getName()));
        }
        this.fileName = name;
    }

    public void init() throws IOException {
        this.ontologyRepository = new InMemoryRepository((EntityType)this.ontologyFactory.getEntityType());
        this.nodePathRepository = new InMemoryRepository((EntityType)this.ontologyTermNodePathFactory.getEntityType());
        this.ontologyTermRepository = new InMemoryRepository((EntityType)this.ontologyTermFactory.getEntityType());
        this.annotationRepository = new InMemoryRepository((EntityType)this.ontologyTermDynamicAnnotationFactory.getEntityType());
        this.synonymRepository = new InMemoryRepository((EntityType)this.ontologyTermSynonymFactory.getEntityType());
        this.repositories = ImmutableMap.of((Object)"sys_ont_OntologyTermDynamicAnnotation", this.annotationRepository, (Object)"sys_ont_OntologyTermSynonym", this.synonymRepository, (Object)"sys_ont_OntologyTermNodePath", this.nodePathRepository, (Object)"sys_ont_Ontology", this.ontologyRepository, (Object)"sys_ont_OntologyTerm", this.ontologyTermRepository);
        List<File> uploadedFiles = ZipFileUtil.unzip(this.file);
        try {
            this.loader = new OntologyLoader(this.fileName, uploadedFiles.get(0));
        }
        catch (OWLOntologyCreationException e) {
            throw new IOException(e);
        }
        this.createOntology();
        this.createNodePaths();
        this.createOntologyTerms();
    }

    private void createOntology() {
        this.ontologyEntity = (Ontology)this.ontologyFactory.create();
        this.ontologyEntity.setId(this.idGenerator.generateId());
        this.ontologyEntity.setOntologyIri(this.loader.getOntologyIRI());
        this.ontologyEntity.setOntologyName(this.loader.getOntologyName());
        this.ontologyRepository.add((Entity)this.ontologyEntity);
    }

    private void createNodePaths() {
        TreeTraverser<OWLClassContainer> traverser = new TreeTraverser<OWLClassContainer>(){

            public Iterable<OWLClassContainer> children(OWLClassContainer container) {
                int count = 0;
                ArrayList<OWLClassContainer> containers = new ArrayList<OWLClassContainer>();
                for (OWLClass childClass : OntologyRepositoryCollection.this.loader.getChildClass(container.getOwlClass())) {
                    containers.add(new OWLClassContainer(childClass, OntologyRepositoryCollection.this.constructNodePath(container.getNodePath(), count), false));
                    ++count;
                }
                return containers;
            }
        };
        OWLClass pseudoRootClass = this.loader.createClass(PSEUDO_ROOT_CLASS_LABEL, this.loader.getRootClasses());
        for (OWLClassContainer container : traverser.preOrderTraversal((Object)new OWLClassContainer(pseudoRootClass, PSEUDO_ROOT_CLASS_NODEPATH, true))) {
            OWLClass ontologyTerm = container.getOwlClass();
            String ontologyTermNodePath = container.getNodePath();
            String ontologyTermIRI = ontologyTerm.getIRI().toString();
            OntologyTermNodePath nodePathEntity = this.createNodePathEntity(container, ontologyTermNodePath);
            this.nodePathsPerOntologyTerm.put((Object)ontologyTermIRI, (Object)nodePathEntity);
        }
    }

    private void createOntologyTerms() {
        this.loader.getAllclasses().forEach(this::createOntologyTerm);
    }

    private Entity createOntologyTerm(OWLClass ontologyTermClass) {
        String ontologyTermIRI = ontologyTermClass.getIRI().toString();
        String ontologyTermName = this.loader.getLabel((OWLEntity)ontologyTermClass);
        OntologyTerm ontologyTerm = (OntologyTerm)this.ontologyTermFactory.create();
        ontologyTerm.setId(this.idGenerator.generateId());
        ontologyTerm.setOntologyTermIri(ontologyTermIRI);
        ontologyTerm.setOntologyTermName(ontologyTermName);
        ontologyTerm.setOntologyTermSynonyms(this.createSynonyms(ontologyTermClass));
        ontologyTerm.setOntologyTermDynamicAnnotations(this.createDynamicAnnotations(ontologyTermClass));
        ontologyTerm.setOntologyTermNodePaths((Iterable)this.nodePathsPerOntologyTerm.get((Object)ontologyTermIRI));
        ontologyTerm.setOntology(this.ontologyEntity);
        this.ontologyTermRepository.add((Entity)ontologyTerm);
        return ontologyTerm;
    }

    private List<OntologyTermSynonym> createSynonyms(OWLClass ontologyTerm) {
        return this.loader.getSynonyms(ontologyTerm).stream().map(this::createSynonym).collect(Collectors.toList());
    }

    private OntologyTermSynonym createSynonym(String synonym) {
        OntologyTermSynonym entity = (OntologyTermSynonym)this.ontologyTermSynonymFactory.create();
        entity.setId(this.idGenerator.generateId());
        entity.setOntologyTermSynonym(synonym);
        this.synonymRepository.add((Entity)entity);
        return entity;
    }

    private List<OntologyTermDynamicAnnotation> createDynamicAnnotations(OWLClass term) {
        return this.loader.getDatabaseIds(term).stream().map(this::createDynamicAnnotation).collect(Collectors.toList());
    }

    private OntologyTermDynamicAnnotation createDynamicAnnotation(String label) {
        OntologyTermDynamicAnnotation entity = (OntologyTermDynamicAnnotation)this.ontologyTermDynamicAnnotationFactory.create();
        entity.setId(this.idGenerator.generateId());
        String[] fragments = label.split(":");
        entity.setName(fragments[0]);
        entity.setValue(fragments[1]);
        entity.setLabel(label);
        this.annotationRepository.add((Entity)entity);
        return entity;
    }

    private String constructNodePath(String parentNodePath, int currentPosition) {
        StringBuilder nodePathStringBuilder = new StringBuilder();
        if (!StringUtils.isEmpty((CharSequence)parentNodePath)) {
            nodePathStringBuilder.append(parentNodePath).append('.');
        }
        nodePathStringBuilder.append(currentPosition).append('[').append(nodePathStringBuilder.toString().split("\\.").length - 1).append(']');
        return nodePathStringBuilder.toString();
    }

    private OntologyTermNodePath createNodePathEntity(OWLClassContainer container, String ontologyTermNodePathText) {
        OntologyTermNodePath ontologyTermNodePath = (OntologyTermNodePath)this.ontologyTermNodePathFactory.create();
        ontologyTermNodePath.setId(this.idGenerator.generateId());
        ontologyTermNodePath.setNodePath(ontologyTermNodePathText);
        ontologyTermNodePath.setRoot(container.isRoot());
        this.nodePathRepository.add((Entity)ontologyTermNodePath);
        return ontologyTermNodePath;
    }

    public Iterable<String> getEntityIds() {
        return this.repositories.keySet();
    }

    public String getName() {
        throw new UnsupportedOperationException();
    }

    public Iterator<Repository<Entity>> iterator() {
        throw new UnsupportedOperationException();
    }

    public Repository<Entity> getRepository(String name) {
        if (!this.repositories.containsKey(name)) {
            throw new MolgenisDataException(String.format("Unknown entity name [%s]", name));
        }
        return this.repositories.get(name);
    }

    public boolean hasRepository(String name) {
        if (null == name) {
            return false;
        }
        Iterator<String> entityNames = this.getEntityIds().iterator();
        while (entityNames.hasNext()) {
            if (!entityNames.next().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRepository(EntityType entityType) {
        return this.hasRepository(entityType.getFullyQualifiedName());
    }
}

