/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology.sorta.job;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.Query;
import org.molgenis.data.jobs.Progress;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.populate.IdGenerator;
import org.molgenis.data.support.DynamicEntity;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.ontology.sorta.meta.MatchingTaskContentMetaData;
import org.molgenis.ontology.sorta.service.SortaService;
import org.molgenis.security.core.runas.RunAsSystemProxy;
import org.molgenis.ui.menu.MenuReaderService;
import org.molgenis.util.ApplicationContextProvider;

public class SortaJobProcessor {
    private static final int ADD_BATCH_SIZE = 1000;
    private static final int PROGRESS_UPDATE_BATCH_SIZE = 50;
    private final String ontologyIri;
    private final String inputRepositoryName;
    private final String resultRepositoryName;
    private final Progress progress;
    private final DataService dataService;
    private final SortaService sortaService;
    private final IdGenerator idGenerator;
    private final AtomicInteger counter;
    private final MenuReaderService menuReaderService;

    public SortaJobProcessor(String ontologyIri, String inputRepositoryName, String resultRepositoryName, Progress progress, DataService dataService, SortaService sortaService, IdGenerator idGenerator, MenuReaderService menuReaderService) {
        this.ontologyIri = Objects.requireNonNull(ontologyIri);
        this.inputRepositoryName = Objects.requireNonNull(inputRepositoryName);
        this.resultRepositoryName = Objects.requireNonNull(resultRepositoryName);
        this.progress = Objects.requireNonNull(progress);
        this.dataService = Objects.requireNonNull(dataService);
        this.sortaService = Objects.requireNonNull(sortaService);
        this.idGenerator = Objects.requireNonNull(idGenerator);
        this.counter = new AtomicInteger(0);
        this.menuReaderService = Objects.requireNonNull(menuReaderService);
    }

    public void process() {
        RunAsSystemProxy.runAsSystem(() -> {
            long maxCount = this.dataService.count(this.inputRepositoryName, (Query)new QueryImpl());
            this.progress.status("Matching " + maxCount + " input terms from " + this.inputRepositoryName + ".\nStoring results in " + this.resultRepositoryName);
            this.progress.setProgressMax((int)maxCount);
            MatchingTaskContentMetaData matchingTaskContentMetaData = (MatchingTaskContentMetaData)((Object)((Object)ApplicationContextProvider.getApplicationContext().getBean(MatchingTaskContentMetaData.class)));
            ArrayList entitiesToAdd = Lists.newArrayList();
            this.dataService.findAll(this.inputRepositoryName).forEach(inputRow -> {
                DynamicEntity resultEntity = new DynamicEntity((EntityType)matchingTaskContentMetaData){

                    protected void validateValueType(String attrName, Object value) {
                    }
                };
                resultEntity.set("inputTerm", inputRow);
                resultEntity.set("identifier", (Object)this.idGenerator.generateId());
                resultEntity.set("validated", (Object)false);
                entitiesToAdd.add(resultEntity);
                Iterable<Entity> ontologyTermEntities = this.sortaService.findOntologyTermEntities(this.ontologyIri, (Entity)inputRow);
                if (Iterables.size(ontologyTermEntities) > 0) {
                    Entity firstMatchedOntologyTerm = (Entity)Iterables.getFirst(ontologyTermEntities, (Object)new DynamicEntity((EntityType)matchingTaskContentMetaData));
                    resultEntity.set("matchTerm", firstMatchedOntologyTerm.get("ontologyTermIRI"));
                    resultEntity.set("score", firstMatchedOntologyTerm.get("Score"));
                } else {
                    resultEntity.set("score", (Object)0);
                }
                if (entitiesToAdd.size() >= 1000) {
                    this.dataService.add(this.resultRepositoryName, entitiesToAdd.stream());
                    entitiesToAdd.clear();
                }
                this.counter.incrementAndGet();
                if (this.counter.get() % 50 == 0) {
                    this.progress.progress(this.counter.get(), "Processed " + this.counter + " input terms.");
                }
            });
            if (entitiesToAdd.size() != 0) {
                this.dataService.add(this.resultRepositoryName, entitiesToAdd.stream());
            }
            this.progress.progress(this.counter.get(), "Processed " + this.counter + " input terms.");
            this.progress.setResultUrl(this.menuReaderService.getMenu().findMenuItemPath("sortaservice") + "/result/" + this.resultRepositoryName);
        });
    }
}

