/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology.controller;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.data.csv.CsvWriter;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.support.DynamicEntity;
import org.molgenis.file.FileStore;
import org.molgenis.ontology.core.service.OntologyService;
import org.molgenis.ontology.sorta.repo.SortaCsvRepository;
import org.molgenis.ontology.sorta.service.SortaService;
import org.molgenis.ontology.sorta.service.impl.SortaServiceImpl;
import org.molgenis.ontology.utils.SortaServiceUtil;
import org.molgenis.ui.MolgenisPluginController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/plugin/sorta_anonymous"})
public class SortaServiceAnonymousController
extends MolgenisPluginController {
    @Autowired
    private SortaService sortaService;
    @Autowired
    private OntologyService ontologyService;
    @Autowired
    private FileStore fileStore;
    @Autowired
    private EntityTypeFactory entityTypeFactory;
    @Autowired
    private AttributeFactory attrMetaFactory;
    public static final String VIEW_NAME = "sorta-match-anonymous-view";
    public static final String ID = "sorta_anonymous";
    public static final String URI = "/plugin/sorta_anonymous";

    public SortaServiceAnonymousController() {
        super(URI);
    }

    @RequestMapping(method={RequestMethod.GET})
    public String init(Model model) {
        model.addAttribute("ontologies", (Object)this.ontologyService.getOntologies());
        return VIEW_NAME;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/match"})
    public String match(@RequestParam(value="selectOntologies", required=true) String ontologyIri, @RequestParam(value="inputTerms", required=true) String inputTerms, HttpServletRequest httpServletRequest, Model model) throws UnsupportedEncodingException, IOException {
        String fileName = httpServletRequest.getSession().getId() + "_input.txt";
        File uploadFile = this.fileStore.store((InputStream)new ByteArrayInputStream(inputTerms.getBytes("UTF8")), fileName);
        this.validateSortaInput(ontologyIri, uploadFile, httpServletRequest, model);
        return this.init(model);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/match/upload"})
    public String upload(@RequestParam(value="selectOntologies", required=true) String ontologyIri, @RequestParam(value="file", required=true) Part file, HttpServletRequest httpServletRequest, Model model) throws UnsupportedEncodingException, IOException {
        String fileName = httpServletRequest.getSession().getId() + "_input.csv";
        File uploadFile = this.fileStore.store(file.getInputStream(), fileName);
        this.validateSortaInput(ontologyIri, uploadFile, httpServletRequest, model);
        return this.init(model);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/retrieve"})
    @ResponseBody
    public List<Map<String, Object>> matchResult(HttpServletRequest httpServletRequest) throws UnsupportedEncodingException, IOException {
        File uploadFile;
        SortaCsvRepository csvRepository;
        Object filePath = httpServletRequest.getSession().getAttribute("filePath");
        Object ontologyIriObject = httpServletRequest.getSession().getAttribute("ontologyIri");
        ArrayList<Map<String, Object>> responseResults = new ArrayList<Map<String, Object>>();
        if (filePath != null && ontologyIriObject != null && this.validateUserInputHeader((Repository<Entity>)(csvRepository = new SortaCsvRepository((uploadFile = new File(filePath.toString())).getName(), uploadFile.getName(), uploadFile, this.entityTypeFactory, this.attrMetaFactory))) && this.validateUserInputContent(csvRepository)) {
            responseResults.addAll(this.matchInputWithOntologyTerm((Repository<Entity>)csvRepository, ontologyIriObject.toString()));
        }
        return responseResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.GET}, value={"/download"})
    public void download(HttpServletRequest httpServletRequest, HttpServletResponse response) throws UnsupportedEncodingException, IOException {
        CsvWriter csvWriter = null;
        try {
            response.setContentType("text/csv");
            response.addHeader("Content-Disposition", "attachment; filename=" + this.generateCsvFileName("match-result"));
            Object filePath = httpServletRequest.getSession().getAttribute("filePath");
            Object ontologyIriObject = httpServletRequest.getSession().getAttribute("ontologyIri");
            if (filePath != null && ontologyIriObject != null) {
                DecimalFormat df = new DecimalFormat("###.##");
                String ontologyIri = ontologyIriObject.toString();
                File uploadFile = new File(filePath.toString());
                SortaCsvRepository csvRepository = new SortaCsvRepository(uploadFile, this.entityTypeFactory, this.attrMetaFactory);
                List<String> columnHeaders = this.createDownloadTableHeaders(csvRepository);
                csvWriter = new CsvWriter((OutputStream)response.getOutputStream(), SortaServiceImpl.DEFAULT_SEPARATOR.charValue());
                csvWriter.writeAttributeNames(columnHeaders);
                Iterator<Entity> iterator = csvRepository.iterator();
                block3: while (iterator.hasNext()) {
                    Entity inputEntity = iterator.next();
                    int count = 0;
                    for (Entity ontologyTermEntity : this.sortaService.findOntologyTermEntities(ontologyIri, inputEntity)) {
                        DynamicEntity mapEntity = new DynamicEntity(null);
                        if (count == 0) {
                            mapEntity = new DynamicEntity(null);
                            mapEntity.set(inputEntity);
                        }
                        if (count >= 20) continue block3;
                        mapEntity.set("ontologyTermName", (Object)ontologyTermEntity.getString("ontologyTermName"));
                        mapEntity.set("ontologyTermIRI", (Object)ontologyTermEntity.getString("ontologyTermIRI"));
                        mapEntity.set("Score", (Object)df.format(ontologyTermEntity.getDouble("Score")));
                        mapEntity.set("Combined_Score", (Object)df.format(ontologyTermEntity.getDouble("Combined_Score")));
                        csvWriter.add((Entity)mapEntity);
                        ++count;
                    }
                }
            }
        }
        finally {
            if (csvWriter != null) {
                IOUtils.closeQuietly(csvWriter);
            }
        }
    }

    private List<String> createDownloadTableHeaders(SortaCsvRepository csvRepository) {
        ImmutableList inputAttributeNames = FluentIterable.from((Iterable)csvRepository.getEntityType().getAtomicAttributes()).transform(Attribute::getName).filter(attrName -> !StringUtils.equalsIgnoreCase((CharSequence)attrName, (CharSequence)"Identifier")).toList();
        ArrayList<String> columnHeaders = new ArrayList<String>((Collection<String>)inputAttributeNames);
        columnHeaders.addAll(Arrays.asList("ontologyTermName", "ontologyTermIRI", "Score", "Combined_Score"));
        return columnHeaders;
    }

    private List<Map<String, Object>> matchInputWithOntologyTerm(Repository<Entity> repository, String ontologyIri) {
        return FluentIterable.from(repository).transform(inputEntity -> {
            Iterable<Entity> findOntologyTermEntities = this.sortaService.findOntologyTermEntities(ontologyIri, (Entity)inputEntity);
            return ImmutableMap.of((Object)"inputTerm", SortaServiceUtil.getEntityAsMap(inputEntity), (Object)"ontologyTerm", SortaServiceUtil.getEntityAsMap(findOntologyTermEntities));
        }).toList();
    }

    private void validateSortaInput(String ontologyIri, File uploadFile, HttpServletRequest httpServletRequest, Model model) {
        SortaCsvRepository csvRepository = new SortaCsvRepository(uploadFile, this.entityTypeFactory, this.attrMetaFactory);
        HttpSession session = httpServletRequest.getSession();
        session.setAttribute("filePath", (Object)uploadFile.getAbsoluteFile());
        session.setAttribute("ontologyIri", (Object)ontologyIri);
        model.addAttribute("showResult", (Object)true);
        if (!this.validateUserInputHeader((Repository<Entity>)csvRepository)) {
            model.addAttribute("message", (Object)"The input header is wrong!");
            model.addAttribute("showResult", (Object)false);
            session.removeAttribute("filePath");
            session.removeAttribute("ontologyIri");
        } else if (!this.validateUserInputContent(csvRepository)) {
            model.addAttribute("message", (Object)"There are no terms in the input!");
            model.addAttribute("showResult", (Object)false);
            session.removeAttribute("filePath");
            session.removeAttribute("ontologyIri");
        }
    }

    private boolean validateUserInputHeader(Repository<Entity> repository) {
        return Iterables.any((Iterable)repository.getEntityType().getAtomicAttributes(), attr -> StringUtils.isNotEmpty((CharSequence)attr.getName()) && StringUtils.equalsIgnoreCase((CharSequence)attr.getName(), (CharSequence)"Name"));
    }

    private boolean validateUserInputContent(SortaCsvRepository csvRepository) {
        Iterator<Entity> iterator = csvRepository.iterator();
        return iterator.hasNext();
    }

    private String generateCsvFileName(String dataSetName) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dataSetName + "_" + dateFormat.format(new Date()) + ".csv";
    }
}

