/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology.controller;

import java.util.Collections;
import java.util.Map;
import org.molgenis.ontology.core.service.OntologyService;
import org.molgenis.web.PluginController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/plugin/ontologymanager"})
public class OntologyManagerController
extends PluginController {
    public static final String ID = "ontologymanager";
    public static final String URI = "/plugin/ontologymanager";
    public static final String VIEW_ONTOLOGY_MANAGER = "ontology-manager-view";
    @Autowired
    private OntologyService ontologyService;

    public OntologyManagerController() {
        super(URI);
    }

    @RequestMapping(method={RequestMethod.GET})
    public String init(Model model) throws Exception {
        model.addAttribute("ontologies", (Object)this.ontologyService.getOntologies());
        return VIEW_ONTOLOGY_MANAGER;
    }

    @RequestMapping(method={RequestMethod.POST})
    public String delete(Model model) throws Exception {
        model.addAttribute("ontologies", (Object)this.ontologyService.getOntologies());
        return VIEW_ONTOLOGY_MANAGER;
    }

    @RequestMapping(value={"/ontology"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<String, Object> getAllOntologies() {
        return Collections.singletonMap("results", this.ontologyService.getOntologies());
    }
}

