/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology.sorta.meta;

import java.util.Objects;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.SystemEntityType;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.Package;
import org.molgenis.ontology.core.model.OntologyPackage;
import org.springframework.stereotype.Component;

@Component
public class MatchingTaskContentMetaData
extends SystemEntityType {
    public static final String SIMPLE_NAME = "MatchingTaskContent";
    public static final String MATCHING_TASK_CONTENT = "sys_ont_MatchingTaskContent";
    public static final String IDENTIFIER = "identifier";
    public static final String INPUT_TERM = "inputTerm";
    public static final String MATCHED_TERM = "matchTerm";
    public static final String SCORE = "score";
    public static final String VALIDATED = "validated";
    private final OntologyPackage ontologyPackage;

    MatchingTaskContentMetaData(OntologyPackage ontologyPackage) {
        super(SIMPLE_NAME, "sys_ont");
        this.ontologyPackage = Objects.requireNonNull(ontologyPackage);
    }

    public void init() {
        this.setLabel("Matching task content");
        this.setPackage((Package)this.ontologyPackage);
        this.setAbstract(true);
        this.addAttribute(IDENTIFIER, new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_ID});
        this.addAttribute(MATCHED_TERM, new EntityType.AttributeRole[0]).setDescription("Matched ontology term").setNillable(true);
        this.addAttribute(SCORE, new EntityType.AttributeRole[0]).setDataType(AttributeType.DECIMAL).setDescription("Score of the match").setNillable(true);
        this.addAttribute(VALIDATED, new EntityType.AttributeRole[0]).setDataType(AttributeType.BOOL).setDescription("Indication if the match was validated").setNillable(false);
    }
}

