/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology.controller;

import java.util.Collections;
import java.util.Map;
import org.molgenis.ontology.core.service.OntologyService;
import org.molgenis.web.PluginController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/plugin/ontologymanager"})
public class OntologyManagerController
extends PluginController {
    public static final String ID = "ontologymanager";
    public static final String URI = "/plugin/ontologymanager";
    public static final String VIEW_ONTOLOGY_MANAGER = "ontology-manager-view";
    @Autowired
    private OntologyService ontologyService;

    public OntologyManagerController() {
        super(URI);
    }

    @GetMapping
    public String init(Model model) {
        model.addAttribute("ontologies", (Object)this.ontologyService.getOntologies());
        return VIEW_ONTOLOGY_MANAGER;
    }

    @PostMapping
    public String delete(Model model) {
        model.addAttribute("ontologies", (Object)this.ontologyService.getOntologies());
        return VIEW_ONTOLOGY_MANAGER;
    }

    @GetMapping(value={"/ontology"}, produces={"application/json"})
    @ResponseBody
    public Map<String, Object> getAllOntologies() {
        return Collections.singletonMap("results", this.ontologyService.getOntologies());
    }
}

