/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.ontology.initializer;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Objects;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.UnknownEntityException;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.ontology.initializer.OntologyScriptInitializer;
import org.molgenis.script.core.Script;
import org.molgenis.script.core.ScriptFactory;
import org.molgenis.script.core.ScriptParameter;
import org.molgenis.script.core.ScriptParameterFactory;
import org.molgenis.security.core.runas.RunAsSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.util.FileCopyUtils;

@Service
public class OntologyScriptInitializerImpl
implements OntologyScriptInitializer {
    private static final String ROC_CURVE_SCRIPT_NAME = "roc";
    private static final String ROC_CURVE_SCRIPT_PARAMETER = "filePath";
    private static final Logger LOG = LoggerFactory.getLogger(OntologyScriptInitializerImpl.class);
    private final DataService dataService;
    private final ScriptFactory scriptFactory;
    private final ScriptParameterFactory scriptParameterFactory;

    public OntologyScriptInitializerImpl(DataService dataService, ScriptFactory scriptFactory, ScriptParameterFactory scriptParameterFactory) {
        this.dataService = Objects.requireNonNull(dataService);
        this.scriptFactory = Objects.requireNonNull(scriptFactory);
        this.scriptParameterFactory = Objects.requireNonNull(scriptParameterFactory);
    }

    @Override
    @RunAsSystem
    public void initialize() {
        ClassPathResource resource = new ClassPathResource("roc-curve.R");
        if (resource.exists()) {
            long count = this.dataService.count("sys_scr_Script", new QueryImpl().eq("name", (Object)ROC_CURVE_SCRIPT_NAME));
            if (count == 0L) {
                String scriptContent;
                Entity scriptType = this.dataService.findOne("sys_scr_ScriptType", new QueryImpl().eq("name", (Object)"R"));
                if (scriptType == null) {
                    throw new UnknownEntityException("ScriptType R does not exist!");
                }
                try {
                    scriptContent = FileCopyUtils.copyToString((Reader)new InputStreamReader(resource.getInputStream(), "UTF-8"));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                if (this.dataService.count("sys_scr_ScriptParameter", new QueryImpl().eq("name", (Object)ROC_CURVE_SCRIPT_PARAMETER)) == 0L) {
                    this.dataService.add("sys_scr_ScriptParameter", (Entity)((ScriptParameter)this.scriptParameterFactory.create()).setName(ROC_CURVE_SCRIPT_PARAMETER));
                }
                Entity scriptParameterEntity = this.dataService.findOne("sys_scr_ScriptParameter", new QueryImpl().eq("name", (Object)ROC_CURVE_SCRIPT_PARAMETER));
                Script script = (Script)this.scriptFactory.create();
                script.setName(ROC_CURVE_SCRIPT_NAME);
                script.setGenerateToken(Boolean.valueOf(true));
                script.set("type", (Object)scriptType);
                script.setResultFileExtension("png");
                script.setContent(scriptContent);
                script.set("parameters", Arrays.asList(scriptParameterEntity));
                this.dataService.add("sys_scr_Script", (Entity)script);
                LOG.info("Script entity \"roc\" has been added to the database!");
            } else {
                LOG.info("Script entity \"roc\" already exists in the database!");
            }
        } else {
            LOG.info("R script \"roc-curve.R\" does not exist on classpath!");
        }
    }
}

